/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.io;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import com.tencent.map.sdk.a.gb;
import com.tencent.map.sdk.a.gg;
import com.tencent.map.sdk.a.gh;
import com.tencent.map.sdk.a.nm;
import com.tencent.map.sdk.a.oo;
import java.io.File;

public class QStorageManager {
    public static final String DATA = "data/";
    private static QStorageManager a = null;
    private Context b;
    private String c;
    private String d;
    private String e;
    private String f;
    private String g;
    private String h;
    private String i;
    private String j;
    private String k;

    private QStorageManager(Context context) {
        if (context == null) {
            throw new Error("context can not be null");
        }
        this.b = context.getApplicationContext();
        String strPath = QStorageManager.getStorageRootPath(context);
        String packageName = oo.a(this.b);
        this.c = nm.a(packageName) ? strPath + "/tencentmapsdk/" : strPath + "/tencentmapsdk/" + packageName;
        this.d = this.c + "/data/v3/render/";
        this.e = this.c + "/sat/";
        this.j = context.getFilesDir().getAbsolutePath();
        this.g = this.j + "/tencentMapSdk/config/";
        this.k = this.g + "temp/";
        this.h = this.j + "/tencentMapSdk/assets/";
        this.i = this.j + "/tencentMapSdk/dynamicAssets/";
        this.f = this.d + "closeRoadDatas/";
        this.clearOldConfig(context, gh.a(context).a("sdkVersion"));
    }

    public static QStorageManager getInstance(Context context) {
        if (a == null) {
            a = new QStorageManager(context);
        }
        return a;
    }

    public void clearOldConfig(Context context, String cachedVersion) {
        if (nm.a(gh.a(context).a("sdkVersion"))) {
            return;
        }
        if (gb.a("4.1.0", cachedVersion) > 0) {
            gg.a(context);
            oo.e(new File(this.g));
            oo.e(new File(this.h));
            oo.e(new File(this.j + "/tencentMapSdk/subKey/"));
        }
    }

    public static String getStorageRootPath(Context context) {
        String strSdkDirectory;
        boolean externalSdCardPermission = false;
        boolean boSdcard = Environment.getExternalStorageState().equals("mounted");
        int write = 0;
        int read = 0;
        if (Build.VERSION.SDK_INT < 29 && Build.VERSION.SDK_INT >= 23) {
            write = context.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", Process.myPid(), Process.myUid());
            read = context.checkPermission("android.permission.READ_EXTERNAL_STORAGE", Process.myPid(), Process.myUid());
        }
        if (write == 0 && read == 0) {
            externalSdCardPermission = true;
        }
        if (!boSdcard || !externalSdCardPermission) {
            strSdkDirectory = context.getFilesDir().getPath();
        } else {
            strSdkDirectory = Environment.getExternalStorageDirectory().getPath();
            if (QStorageManager.getAvailableStorageSize(strSdkDirectory) < 5L && QStorageManager.getAvailableStorageSize(strSdkDirectory = context.getFilesDir().getPath()) < 5L) {
                strSdkDirectory = Environment.getExternalStorageDirectory().getPath();
            }
        }
        return strSdkDirectory;
    }

    @SuppressLint(value={"NewApi"})
    public static long getAvailableStorageSize(String path) {
        try {
            long availBlocks;
            long blockSize;
            StatFs stfs = new StatFs(path);
            if (Build.VERSION.SDK_INT < 18) {
                blockSize = stfs.getBlockSize();
                availBlocks = stfs.getAvailableBlocks();
            } else {
                blockSize = stfs.getBlockSizeLong();
                availBlocks = stfs.getAvailableBlocksLong();
            }
            return blockSize * availBlocks / 1024L / 1024L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public File getDataDir() {
        return new File(this.c + "/data/");
    }

    public File getCacheDir() {
        return new File(this.c);
    }

    public String getMapPath() {
        return this.d;
    }

    public String getSatPath() {
        return this.e;
    }

    public String getRouteBlockPath() {
        return this.f;
    }

    public String getConfigPath(String key) {
        if (nm.a(key)) {
            return this.g;
        }
        return this.j + "/tencentMapSdk/subKey/" + key + "/config/";
    }

    public String getAssetsLoadPath(String key) {
        if (nm.a(key)) {
            return this.h;
        }
        return this.j + "/tencentMapSdk/subKey/" + key + "/assets/";
    }

    public String getAssetsDynamicPath() {
        return this.i;
    }

    public String getConfigTempPath(String key) {
        if (nm.a(key)) {
            return this.k;
        }
        return this.getConfigPath(key) + "temp/";
    }
}

