/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.internal;

import com.tencent.map.lib.mapstructure.MapRouteSectionWithName;
import com.tencent.map.sdk.a.hn;
import com.tencent.map.sdk.a.kh;
import com.tencent.map.sdk.a.kr;
import com.tencent.map.sdk.a.lm;
import com.tencent.map.sdk.a.ql;
import com.tencent.map.sdk.basemap.interfaces.IMapRenderView;
import com.tencent.tencentmap.mapsdk.maps.CameraUpdate;
import com.tencent.tencentmap.mapsdk.maps.TencentMap;
import com.tencent.tencentmap.mapsdk.maps.model.CameraPosition;
import com.tencent.tencentmap.mapsdk.maps.model.IOverlay;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.LatLngBounds;
import java.util.ArrayList;
import java.util.List;

public final class TencentMapPro {
    private boolean mapDestroyed = false;
    private kh glMapControl = null;
    private lm mapManager = null;
    private kr viewControl;

    public TencentMapPro(lm mapManager, kr viewControl, kh glMapControl) {
        this.mapManager = mapManager;
        this.viewControl = viewControl;
        this.glMapControl = glMapControl;
    }

    private final void animateToNaviPosition(LatLng mLocation, float fRotate, float fTitle) {
        if (this.mapDestroyed) {
            return;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        LatLng latLng = mLocation;
        kh kh2 = this.glMapControl;
        if (kh2.a != null) {
            kh2.a.a(latLng, fRotate, fTitle);
        }
    }

    private final void animateToNaviPosition(LatLng mLocation, float fRotate, float fTitle, float fDestLevel) {
        if (this.mapDestroyed) {
            return;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        this.glMapControl.a(mLocation, fRotate, fTitle, fDestLevel, true);
    }

    private final void animateToNaviPosition(LatLng mLocation, float fRotate, float fTitle, float fDestLevel, boolean bo3D) {
        if (this.mapDestroyed) {
            return;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        this.glMapControl.a(mLocation, fRotate, fTitle, fDestLevel, bo3D);
    }

    private final void animateToNaviPosition2(LatLng mLocation, float fRotate, float fTitle, float fDestLevel, boolean bo3D) {
        if (this.mapDestroyed) {
            return;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        LatLng latLng = mLocation;
        kh kh2 = this.glMapControl;
        if (kh2.a != null) {
            kh2.a.a(latLng, fRotate, fTitle, fDestLevel);
        }
    }

    private float calNaviLevel(LatLngBounds bound, float skewangle, int topPadding, boolean is3d) {
        if (this.mapDestroyed) {
            return 0.0f;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        LatLngBounds latLngBounds = bound;
        kh kh2 = this.glMapControl;
        if (kh2.a == null) {
            return 0.0f;
        }
        return kh2.a.a(latLngBounds, skewangle, topPadding, is3d);
    }

    private float calNaviLevel2(LatLng curPos, LatLng nextPos, float skewangle, float rotateanble, int topPadding, boolean is3d) {
        if (this.mapDestroyed) {
            return 0.0f;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        LatLng latLng = nextPos;
        LatLng latLng2 = curPos;
        kh kh2 = this.glMapControl;
        if (kh2.a == null) {
            return 0.0f;
        }
        return kh2.a.a(latLng2, latLng, skewangle, topPadding, is3d);
    }

    private float calNaviLevel3(LatLng curPos, LatLng nextPos, float skewangle, int leftPadding, int rightPadding, int topPadding, int bottomPadding, boolean is3d) {
        if (this.mapDestroyed) {
            return 0.0f;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        LatLng latLng = nextPos;
        LatLng latLng2 = curPos;
        kh kh2 = this.glMapControl;
        if (kh2.a == null) {
            return 0.0f;
        }
        return kh2.a.a(latLng2, latLng, skewangle, leftPadding, rightPadding, topPadding, bottomPadding, is3d);
    }

    private void setNaviFixingProportion(float xratio, float yratio) {
        if (this.mapDestroyed) {
            return;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        kh kh2 = this.glMapControl;
        if (kh2.a != null) {
            kh2.a.a(xratio, yratio);
        }
    }

    private void setNaviFixingProportion2D(float xratio, float yratio) {
        if (this.mapDestroyed) {
            return;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        kh kh2 = this.glMapControl;
        if (kh2.a != null) {
            kh2.a.b(xratio, yratio);
        }
    }

    public final void moveToNavPosition(CameraUpdate cameraupdate, LatLng mTargetPosition) {
        if (this.mapDestroyed) {
            return;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        this.glMapControl.a(cameraupdate);
        if (mTargetPosition != null) {
            this.setNavCenter((int)(mTargetPosition.latitude * 1000000.0), (int)(mTargetPosition.longitude * 1000000.0));
        }
    }

    private CameraPosition calculateZoomToSpanLevelAsync(List<IOverlay> elements, List<LatLng> points, int leftPadding, int rightPadding, int topPadding, int bottomPadding, TencentMap.AsyncOperateCallback<CameraPosition> callback) {
        if (this.mapDestroyed) {
            if (callback != null) {
                callback.onOperateFinished(null);
            }
            return null;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        TencentMap.AsyncOperateCallback<CameraPosition> asyncOperateCallback = callback;
        List<LatLng> list = points;
        List<IOverlay> list2 = elements;
        kh kh2 = this.glMapControl;
        if (kh2.a == null) {
            return null;
        }
        return kh2.a.a(list2, list, leftPadding, rightPadding, topPadding, bottomPadding, asyncOperateCallback);
    }

    private void addSegmentsWithRouteName(List<hn> sections, List<LatLng> points) {
        if (this.mapDestroyed) {
            return;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        List<LatLng> list = points;
        List<hn> list2 = sections;
        kh kh2 = this.glMapControl;
        if (kh2.a != null) {
            kh2.a.a(list2, list);
        }
    }

    private void addRouteNameSegments(List<MapRouteSectionWithName> sections, List<LatLng> points) {
        if (sections != null) {
            ArrayList<hn> sectionList = new ArrayList<hn>();
            for (MapRouteSectionWithName name : sections) {
                if (name == null) continue;
                hn section = new hn();
                new hn().c = name.color;
                section.b = name.endNum;
                section.d = name.roadName;
                section.a = name.startNum;
                sectionList.add(section);
            }
            this.addSegmentsWithRouteName(sectionList, points);
        }
    }

    private void clearRouteNameSegments() {
        if (this.mapDestroyed) {
            return;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        kh kh2 = this.glMapControl;
        if (kh2.a != null) {
            kh2.a.m();
        }
    }

    private void setNavCenter(int lat, int lng) {
        if (this.viewControl == null) {
            return;
        }
        IMapRenderView mapView = this.viewControl.a();
        if (mapView instanceof ql) {
            ((ql)mapView).getVectorMapDelegate().c(lat, lng);
        }
    }

    public final void onDestroy() {
        this.mapDestroyed = true;
    }

    private void setOnCameraChangeListener(TencentMap.OnCameraChangeListener oncamerachangelistener) {
        if (this.mapDestroyed) {
            return;
        }
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        TencentMap.OnCameraChangeListener onCameraChangeListener = oncamerachangelistener;
        kh kh2 = this.glMapControl;
        if (kh2.a != null) {
            kh2.a.b(onCameraChangeListener);
        }
    }

    private void setNaviStateEnabled(boolean enabled) {
        if (this.glMapControl == null) {
            this.glMapControl = new kh(this.mapManager);
        }
        kh kh2 = this.glMapControl;
        if (kh2.a != null) {
            kh2.a.h(enabled);
        }
    }

    private boolean isNaviStateEnabled() {
        if (this.glMapControl == null) {
            return false;
        }
        return this.glMapControl.b();
    }
}

