/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

public final class CameraPosition {
    public LatLng target;
    public final float zoom;
    public final float tilt;
    public final float bearing;

    private CameraPosition(LatLng latlng, float fzoom, float ftilt, float fbearing, byte by2) {
        this.target = latlng;
        this.zoom = fzoom;
        this.tilt = ftilt;
        this.bearing = fbearing;
    }

    public CameraPosition(LatLng latlng, float zoomLevel, float skew, float rotate) {
        this(latlng, zoomLevel, skew, rotate, 0);
    }

    public static final CameraPosition fromLatLngZoom(LatLng latlng, float zoomLevel) {
        return new CameraPosition(latlng, zoomLevel, 0.0f, 0.0f);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition cameraposition) {
        return new Builder(cameraposition);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CameraPosition)) {
            return false;
        }
        CameraPosition cameraposition = (CameraPosition)obj;
        return this.target.equals(cameraposition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraposition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraposition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraposition.bearing);
    }

    public final String toString() {
        return "latlng:" + this.target.latitude + "," + this.target.longitude + ",zoom:" + this.zoom + ",tilt=" + this.tilt + ",bearing:" + this.bearing;
    }

    public static final class Builder {
        private LatLng a;
        private float b;
        private float c = Float.MIN_VALUE;
        private float d = Float.MIN_VALUE;

        public final Builder target(LatLng latlng) {
            this.a = latlng;
            return this;
        }

        public final Builder zoom(float zoomLevel) {
            this.b = zoomLevel;
            return this;
        }

        public final Builder tilt(float skew) {
            this.c = skew;
            return this;
        }

        public final Builder bearing(float rotate) {
            this.d = rotate;
            return this;
        }

        public final CameraPosition build() {
            return new CameraPosition(this.a, this.b, this.c, this.d);
        }

        public Builder() {
        }

        public Builder(CameraPosition cameraposition) {
            CameraPosition cameraposition1 = cameraposition;
            this.a = cameraposition1.target;
            this.b = cameraposition1.zoom;
            this.c = cameraposition1.tilt;
            this.d = cameraposition1.bearing;
        }
    }
}

