/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug.handler;

import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Build;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import com.tencent.tinker.loader.hotplug.IncrementComponentManager;
import com.tencent.tinker.loader.hotplug.interceptor.HandlerMessageInterceptor;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MHMessageHandler
implements HandlerMessageInterceptor.MessageHandler {
    private static final String TAG = "Tinker.MHMsgHndlr";
    private static final int LAUNCH_ACTIVITY;
    private final Context mContext;

    public MHMessageHandler(Context context) {
        Context baseCtx;
        while (context instanceof ContextWrapper && (baseCtx = ((ContextWrapper)context).getBaseContext()) != null) {
            context = baseCtx;
        }
        this.mContext = context;
    }

    @Override
    public boolean handleMessage(Message msg) {
        int what = msg.what;
        if (what == LAUNCH_ACTIVITY) {
            try {
                Object activityClientRecord = msg.obj;
                if (activityClientRecord == null) {
                    Log.w((String)TAG, (String)("msg: [" + msg.what + "] has no 'obj' value."));
                    return false;
                }
                Field intentField = ShareReflectUtil.findField(activityClientRecord, "intent");
                Intent maybeHackedIntent = (Intent)intentField.get(activityClientRecord);
                if (maybeHackedIntent == null) {
                    Log.w((String)TAG, (String)"cannot fetch intent from message received by mH.");
                    return false;
                }
                ShareIntentUtil.fixIntentClassLoader(maybeHackedIntent, this.mContext.getClassLoader());
                ComponentName oldComponent = (ComponentName)maybeHackedIntent.getParcelableExtra("tinker_iek_old_component");
                if (oldComponent == null) {
                    Log.w((String)TAG, (String)("oldComponent was null, start " + maybeHackedIntent.getComponent() + " next."));
                    return false;
                }
                Field activityInfoField = ShareReflectUtil.findField(activityClientRecord, "activityInfo");
                ActivityInfo aInfo = (ActivityInfo)activityInfoField.get(activityClientRecord);
                if (aInfo == null) {
                    return false;
                }
                ActivityInfo targetAInfo = IncrementComponentManager.queryActivityInfo(oldComponent.getClassName());
                if (targetAInfo == null) {
                    Log.e((String)TAG, (String)("Failed to query target activity's info, perhaps the target is not hotpluged component. Target: " + oldComponent.getClassName()));
                    return false;
                }
                this.fixActivityScreenOrientation(activityClientRecord, targetAInfo.screenOrientation);
                this.fixStubActivityInfo(aInfo, targetAInfo);
                maybeHackedIntent.setComponent(oldComponent);
                maybeHackedIntent.removeExtra("tinker_iek_old_component");
            }
            catch (Throwable thr) {
                Log.e((String)TAG, (String)"exception in handleMessage.", (Throwable)thr);
            }
        }
        return false;
    }

    private void fixStubActivityInfo(ActivityInfo stubAInfo, ActivityInfo targetAInfo) {
        this.copyInstanceFields(targetAInfo, stubAInfo);
    }

    private <T> void copyInstanceFields(T srcObj, T destObj) {
        if (srcObj == null || destObj == null) {
            return;
        }
        Class<?> infoClazz = srcObj.getClass();
        while (!infoClazz.equals(Object.class)) {
            Field[] fields;
            for (Field field : fields = infoClazz.getDeclaredFields()) {
                int modifiers;
                if (field.isSynthetic() || Modifier.isStatic(modifiers = field.getModifiers())) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    field.set(destObj, field.get(srcObj));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            infoClazz = infoClazz.getSuperclass();
        }
    }

    private void fixActivityScreenOrientation(Object activityClientRecord, int screenOrientation) {
        if (screenOrientation == -1) {
            screenOrientation = 2;
        }
        try {
            Field tokenField = ShareReflectUtil.findField(activityClientRecord, "token");
            Object token = tokenField.get(activityClientRecord);
            Class<?> activityManagerNativeClazz = Class.forName("android.app.ActivityManagerNative");
            Method getDefaultMethod = ShareReflectUtil.findMethod(activityManagerNativeClazz, "getDefault", new Class[0]);
            Object amn = getDefaultMethod.invoke(null, new Object[0]);
            Method setRequestedOrientationMethod = ShareReflectUtil.findMethod(amn, "setRequestedOrientation", IBinder.class, Integer.TYPE);
            setRequestedOrientationMethod.invoke(amn, token, screenOrientation);
        }
        catch (Throwable thr) {
            Log.e((String)TAG, (String)"Failed to fix screen orientation.", (Throwable)thr);
        }
    }

    static {
        int launchActivity = 100;
        if (Build.VERSION.SDK_INT < 27) {
            try {
                Class<?> hClazz = Class.forName("android.app.ActivityThread$H");
                launchActivity = ShareReflectUtil.findField(hClazz, "LAUNCH_ACTIVITY").getInt(null);
            }
            catch (Throwable thr) {
                launchActivity = 100;
            }
        }
        LAUNCH_ACTIVITY = launchActivity;
    }
}

