/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.hotplug.handler;

import android.content.ComponentName;
import android.content.Intent;
import android.util.Log;
import com.tencent.tinker.loader.hotplug.IncrementComponentManager;
import com.tencent.tinker.loader.hotplug.interceptor.ServiceBinderInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PMSInterceptHandler
implements ServiceBinderInterceptor.BinderInvocationHandler {
    private static final String TAG = "Tinker.PMSIntrcptHndlr";

    @Override
    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getActivityInfo".equals(methodName)) {
            return this.handleGetActivityInfo(target, method, args);
        }
        if ("resolveIntent".equals(methodName)) {
            return this.handleResolveIntent(target, method, args);
        }
        return method.invoke(target, args);
    }

    private Object handleGetActivityInfo(Object target, Method method, Object[] args) throws Throwable {
        Class<?>[] methodExceptionTypes = method.getExceptionTypes();
        try {
            Object res = method.invoke(target, args);
            if (res != null) {
                return res;
            }
            ComponentName componentName = null;
            for (int compNameIdx = 0; compNameIdx < args.length; ++compNameIdx) {
                if (!(args[compNameIdx] instanceof ComponentName)) continue;
                Log.i((String)TAG, (String)("locate componentName field of " + method.getName() + " done at idx: " + compNameIdx));
                componentName = (ComponentName)args[compNameIdx];
                break;
            }
            if (componentName != null) {
                return IncrementComponentManager.queryActivityInfo(componentName.getClassName());
            }
            Log.w((String)TAG, (String)("failed to locate componentName field of " + method.getName() + ", notice any crashes or mistakes after resolve works."));
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable targetThr = e.getTargetException();
            if (methodExceptionTypes != null && methodExceptionTypes.length > 0) {
                throw targetThr != null ? targetThr : e;
            }
            Log.e((String)TAG, (String)"unexpected exception.", (Throwable)(targetThr != null ? targetThr : e));
            return null;
        }
        catch (Throwable thr) {
            Log.e((String)TAG, (String)"unexpected exception.", (Throwable)thr);
            return null;
        }
    }

    private Object handleResolveIntent(Object target, Method method, Object[] args) throws Throwable {
        Class<?>[] methodExceptionTypes = method.getExceptionTypes();
        try {
            Object res = method.invoke(target, args);
            if (res != null) {
                return res;
            }
            Log.w((String)TAG, (String)"failed to resolve activity in base package, try again in patch package.");
            Intent intent = null;
            for (int intentIdx = 0; intentIdx < args.length; ++intentIdx) {
                if (!(args[intentIdx] instanceof Intent)) continue;
                Log.i((String)TAG, (String)("locate intent field of " + method.getName() + " done at idx: " + intentIdx));
                intent = (Intent)args[intentIdx];
                break;
            }
            if (intent != null) {
                return IncrementComponentManager.resolveIntent(intent);
            }
            Log.w((String)TAG, (String)("failed to locate intent field of " + method.getName() + ", notice any crashes or mistakes after resolve works."));
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable targetThr = e.getTargetException();
            if (methodExceptionTypes != null && methodExceptionTypes.length > 0) {
                throw targetThr != null ? targetThr : e;
            }
            Log.e((String)TAG, (String)"unexpected exception.", (Throwable)(targetThr != null ? targetThr : e));
            return null;
        }
        catch (Throwable thr) {
            Log.e((String)TAG, (String)"unexpected exception.", (Throwable)thr);
            return null;
        }
    }
}

