/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.antiddos.v20200309.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeOverviewAttackTrendResponse extends AbstractModel {

    /**
    * 攻击类型
    */
    @SerializedName("Type")
    @Expose
    private String Type;

    /**
    * 防护概览攻击趋势起始时间
    */
    @SerializedName("StartTime")
    @Expose
    private String StartTime;

    /**
    * 防护概览攻击趋势结束时间
    */
    @SerializedName("EndTime")
    @Expose
    private String EndTime;

    /**
    * 周期
    */
    @SerializedName("Period")
    @Expose
    private Long Period;

    /**
    * 每个周期点的攻击次数
    */
    @SerializedName("Data")
    @Expose
    private Long [] Data;

    /**
    * 包含的周期点数
    */
    @SerializedName("Count")
    @Expose
    private Long Count;

    /**
    * 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 攻击类型 
     * @return Type 攻击类型
     */
    public String getType() {
        return this.Type;
    }

    /**
     * Set 攻击类型
     * @param Type 攻击类型
     */
    public void setType(String Type) {
        this.Type = Type;
    }

    /**
     * Get 防护概览攻击趋势起始时间 
     * @return StartTime 防护概览攻击趋势起始时间
     */
    public String getStartTime() {
        return this.StartTime;
    }

    /**
     * Set 防护概览攻击趋势起始时间
     * @param StartTime 防护概览攻击趋势起始时间
     */
    public void setStartTime(String StartTime) {
        this.StartTime = StartTime;
    }

    /**
     * Get 防护概览攻击趋势结束时间 
     * @return EndTime 防护概览攻击趋势结束时间
     */
    public String getEndTime() {
        return this.EndTime;
    }

    /**
     * Set 防护概览攻击趋势结束时间
     * @param EndTime 防护概览攻击趋势结束时间
     */
    public void setEndTime(String EndTime) {
        this.EndTime = EndTime;
    }

    /**
     * Get 周期 
     * @return Period 周期
     */
    public Long getPeriod() {
        return this.Period;
    }

    /**
     * Set 周期
     * @param Period 周期
     */
    public void setPeriod(Long Period) {
        this.Period = Period;
    }

    /**
     * Get 每个周期点的攻击次数 
     * @return Data 每个周期点的攻击次数
     */
    public Long [] getData() {
        return this.Data;
    }

    /**
     * Set 每个周期点的攻击次数
     * @param Data 每个周期点的攻击次数
     */
    public void setData(Long [] Data) {
        this.Data = Data;
    }

    /**
     * Get 包含的周期点数 
     * @return Count 包含的周期点数
     */
    public Long getCount() {
        return this.Count;
    }

    /**
     * Set 包含的周期点数
     * @param Count 包含的周期点数
     */
    public void setCount(Long Count) {
        this.Count = Count;
    }

    /**
     * Get 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeOverviewAttackTrendResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeOverviewAttackTrendResponse(DescribeOverviewAttackTrendResponse source) {
        if (source.Type != null) {
            this.Type = new String(source.Type);
        }
        if (source.StartTime != null) {
            this.StartTime = new String(source.StartTime);
        }
        if (source.EndTime != null) {
            this.EndTime = new String(source.EndTime);
        }
        if (source.Period != null) {
            this.Period = new Long(source.Period);
        }
        if (source.Data != null) {
            this.Data = new Long[source.Data.length];
            for (int i = 0; i < source.Data.length; i++) {
                this.Data[i] = new Long(source.Data[i]);
            }
        }
        if (source.Count != null) {
            this.Count = new Long(source.Count);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Type", this.Type);
        this.setParamSimple(map, prefix + "StartTime", this.StartTime);
        this.setParamSimple(map, prefix + "EndTime", this.EndTime);
        this.setParamSimple(map, prefix + "Period", this.Period);
        this.setParamArraySimple(map, prefix + "Data.", this.Data);
        this.setParamSimple(map, prefix + "Count", this.Count);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

