/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cynosdb.v20190107.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeInstanceParamsRequest extends AbstractModel {

    /**
    * 集群ID
    */
    @SerializedName("ClusterId")
    @Expose
    private String ClusterId;

    /**
    * 实例ID，支持批量查询
    */
    @SerializedName("InstanceIds")
    @Expose
    private String [] InstanceIds;

    /**
    * 参数名搜索条件，支持模糊匹配
    */
    @SerializedName("ParamKeyword")
    @Expose
    private String ParamKeyword;

    /**
    * 是否为全局参数
    */
    @SerializedName("IsGlobal")
    @Expose
    private String IsGlobal;

    /**
     * Get 集群ID 
     * @return ClusterId 集群ID
     */
    public String getClusterId() {
        return this.ClusterId;
    }

    /**
     * Set 集群ID
     * @param ClusterId 集群ID
     */
    public void setClusterId(String ClusterId) {
        this.ClusterId = ClusterId;
    }

    /**
     * Get 实例ID，支持批量查询 
     * @return InstanceIds 实例ID，支持批量查询
     */
    public String [] getInstanceIds() {
        return this.InstanceIds;
    }

    /**
     * Set 实例ID，支持批量查询
     * @param InstanceIds 实例ID，支持批量查询
     */
    public void setInstanceIds(String [] InstanceIds) {
        this.InstanceIds = InstanceIds;
    }

    /**
     * Get 参数名搜索条件，支持模糊匹配 
     * @return ParamKeyword 参数名搜索条件，支持模糊匹配
     */
    public String getParamKeyword() {
        return this.ParamKeyword;
    }

    /**
     * Set 参数名搜索条件，支持模糊匹配
     * @param ParamKeyword 参数名搜索条件，支持模糊匹配
     */
    public void setParamKeyword(String ParamKeyword) {
        this.ParamKeyword = ParamKeyword;
    }

    /**
     * Get 是否为全局参数 
     * @return IsGlobal 是否为全局参数
     */
    public String getIsGlobal() {
        return this.IsGlobal;
    }

    /**
     * Set 是否为全局参数
     * @param IsGlobal 是否为全局参数
     */
    public void setIsGlobal(String IsGlobal) {
        this.IsGlobal = IsGlobal;
    }

    public DescribeInstanceParamsRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeInstanceParamsRequest(DescribeInstanceParamsRequest source) {
        if (source.ClusterId != null) {
            this.ClusterId = new String(source.ClusterId);
        }
        if (source.InstanceIds != null) {
            this.InstanceIds = new String[source.InstanceIds.length];
            for (int i = 0; i < source.InstanceIds.length; i++) {
                this.InstanceIds[i] = new String(source.InstanceIds[i]);
            }
        }
        if (source.ParamKeyword != null) {
            this.ParamKeyword = new String(source.ParamKeyword);
        }
        if (source.IsGlobal != null) {
            this.IsGlobal = new String(source.IsGlobal);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ClusterId", this.ClusterId);
        this.setParamArraySimple(map, prefix + "InstanceIds.", this.InstanceIds);
        this.setParamSimple(map, prefix + "ParamKeyword", this.ParamKeyword);
        this.setParamSimple(map, prefix + "IsGlobal", this.IsGlobal);

    }
}

