/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lke.v20231130.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class KnowledgeQaOutput extends AbstractModel {

    /**
    * 输出方式 1：流式 2：非流式
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Method")
    @Expose
    private Long Method;

    /**
    * 通用模型回复
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("UseGeneralKnowledge")
    @Expose
    private Boolean UseGeneralKnowledge;

    /**
    * 未知回复语，300字符以内
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("BareAnswer")
    @Expose
    private String BareAnswer;

    /**
     * Get 输出方式 1：流式 2：非流式
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Method 输出方式 1：流式 2：非流式
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getMethod() {
        return this.Method;
    }

    /**
     * Set 输出方式 1：流式 2：非流式
注意：此字段可能返回 null，表示取不到有效值。
     * @param Method 输出方式 1：流式 2：非流式
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setMethod(Long Method) {
        this.Method = Method;
    }

    /**
     * Get 通用模型回复
注意：此字段可能返回 null，表示取不到有效值。 
     * @return UseGeneralKnowledge 通用模型回复
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Boolean getUseGeneralKnowledge() {
        return this.UseGeneralKnowledge;
    }

    /**
     * Set 通用模型回复
注意：此字段可能返回 null，表示取不到有效值。
     * @param UseGeneralKnowledge 通用模型回复
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setUseGeneralKnowledge(Boolean UseGeneralKnowledge) {
        this.UseGeneralKnowledge = UseGeneralKnowledge;
    }

    /**
     * Get 未知回复语，300字符以内
注意：此字段可能返回 null，表示取不到有效值。 
     * @return BareAnswer 未知回复语，300字符以内
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getBareAnswer() {
        return this.BareAnswer;
    }

    /**
     * Set 未知回复语，300字符以内
注意：此字段可能返回 null，表示取不到有效值。
     * @param BareAnswer 未知回复语，300字符以内
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setBareAnswer(String BareAnswer) {
        this.BareAnswer = BareAnswer;
    }

    public KnowledgeQaOutput() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public KnowledgeQaOutput(KnowledgeQaOutput source) {
        if (source.Method != null) {
            this.Method = new Long(source.Method);
        }
        if (source.UseGeneralKnowledge != null) {
            this.UseGeneralKnowledge = new Boolean(source.UseGeneralKnowledge);
        }
        if (source.BareAnswer != null) {
            this.BareAnswer = new String(source.BareAnswer);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Method", this.Method);
        this.setParamSimple(map, prefix + "UseGeneralKnowledge", this.UseGeneralKnowledge);
        this.setParamSimple(map, prefix + "BareAnswer", this.BareAnswer);

    }
}

