/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tione.v20211111.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateBatchTaskRequest extends AbstractModel {

    /**
    * 批量预测任务名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
    */
    @SerializedName("BatchTaskName")
    @Expose
    private String BatchTaskName;

    /**
    * 计费模式，eg：PREPAID 包年包月；POSTPAID_BY_HOUR 按量计费
    */
    @SerializedName("ChargeType")
    @Expose
    private String ChargeType;

    /**
    * 资源配置
    */
    @SerializedName("ResourceConfigInfo")
    @Expose
    private ResourceConfigInfo ResourceConfigInfo;

    /**
    * 结果输出存储信息
    */
    @SerializedName("Outputs")
    @Expose
    private DataConfig [] Outputs;

    /**
    * 是否上报日志
    */
    @SerializedName("LogEnable")
    @Expose
    private Boolean LogEnable;

    /**
    * 工作类型 1:单次 2:周期
    */
    @SerializedName("JobType")
    @Expose
    private Long JobType;

    /**
    * 任务周期描述
    */
    @SerializedName("CronInfo")
    @Expose
    private CronInfo CronInfo;

    /**
    * 包年包月资源组ID
    */
    @SerializedName("ResourceGroupId")
    @Expose
    private String ResourceGroupId;

    /**
    * 标签配置
    */
    @SerializedName("Tags")
    @Expose
    private Tag [] Tags;

    /**
    * 服务对应的模型信息，有模型文件时需要填写
    */
    @SerializedName("ModelInfo")
    @Expose
    private ModelInfo ModelInfo;

    /**
    * 自定义镜像信息
    */
    @SerializedName("ImageInfo")
    @Expose
    private ImageInfo ImageInfo;

    /**
    * 代码包
    */
    @SerializedName("CodePackage")
    @Expose
    private CosPathInfo CodePackage;

    /**
    * 启动命令
    */
    @SerializedName("StartCmd")
    @Expose
    private String StartCmd;

    /**
    * 数据配置
    */
    @SerializedName("DataConfigs")
    @Expose
    private DataConfig [] DataConfigs;

    /**
    * 日志配置
    */
    @SerializedName("LogConfig")
    @Expose
    private LogConfig LogConfig;

    /**
    * VPC Id
    */
    @SerializedName("VpcId")
    @Expose
    private String VpcId;

    /**
    * 子网Id
    */
    @SerializedName("SubnetId")
    @Expose
    private String SubnetId;

    /**
    * 备注
    */
    @SerializedName("Remark")
    @Expose
    private String Remark;

    /**
    * 任务执行结果回调URL，仅支持http和https。回调格式&内容详见: [TI-ONE 接口回调说明](https://cloud.tencent.com/document/product/851/84292)
    */
    @SerializedName("CallbackUrl")
    @Expose
    private String CallbackUrl;

    /**
    * 以Base64方式编码的启动命令。假设启动命令是/app/run.sh，则此处输入参数应该为L2FwcC9ydW4uc2g=。
    */
    @SerializedName("StartCmdBase64")
    @Expose
    private String StartCmdBase64;

    /**
     * Get 批量预测任务名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头 
     * @return BatchTaskName 批量预测任务名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
     */
    public String getBatchTaskName() {
        return this.BatchTaskName;
    }

    /**
     * Set 批量预测任务名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
     * @param BatchTaskName 批量预测任务名称，不超过60个字符，仅支持中英文、数字、下划线"_"、短横"-"，只能以中英文、数字开头
     */
    public void setBatchTaskName(String BatchTaskName) {
        this.BatchTaskName = BatchTaskName;
    }

    /**
     * Get 计费模式，eg：PREPAID 包年包月；POSTPAID_BY_HOUR 按量计费 
     * @return ChargeType 计费模式，eg：PREPAID 包年包月；POSTPAID_BY_HOUR 按量计费
     */
    public String getChargeType() {
        return this.ChargeType;
    }

    /**
     * Set 计费模式，eg：PREPAID 包年包月；POSTPAID_BY_HOUR 按量计费
     * @param ChargeType 计费模式，eg：PREPAID 包年包月；POSTPAID_BY_HOUR 按量计费
     */
    public void setChargeType(String ChargeType) {
        this.ChargeType = ChargeType;
    }

    /**
     * Get 资源配置 
     * @return ResourceConfigInfo 资源配置
     */
    public ResourceConfigInfo getResourceConfigInfo() {
        return this.ResourceConfigInfo;
    }

    /**
     * Set 资源配置
     * @param ResourceConfigInfo 资源配置
     */
    public void setResourceConfigInfo(ResourceConfigInfo ResourceConfigInfo) {
        this.ResourceConfigInfo = ResourceConfigInfo;
    }

    /**
     * Get 结果输出存储信息 
     * @return Outputs 结果输出存储信息
     */
    public DataConfig [] getOutputs() {
        return this.Outputs;
    }

    /**
     * Set 结果输出存储信息
     * @param Outputs 结果输出存储信息
     */
    public void setOutputs(DataConfig [] Outputs) {
        this.Outputs = Outputs;
    }

    /**
     * Get 是否上报日志 
     * @return LogEnable 是否上报日志
     */
    public Boolean getLogEnable() {
        return this.LogEnable;
    }

    /**
     * Set 是否上报日志
     * @param LogEnable 是否上报日志
     */
    public void setLogEnable(Boolean LogEnable) {
        this.LogEnable = LogEnable;
    }

    /**
     * Get 工作类型 1:单次 2:周期 
     * @return JobType 工作类型 1:单次 2:周期
     * @deprecated
     */
    @Deprecated
    public Long getJobType() {
        return this.JobType;
    }

    /**
     * Set 工作类型 1:单次 2:周期
     * @param JobType 工作类型 1:单次 2:周期
     * @deprecated
     */
    @Deprecated
    public void setJobType(Long JobType) {
        this.JobType = JobType;
    }

    /**
     * Get 任务周期描述 
     * @return CronInfo 任务周期描述
     * @deprecated
     */
    @Deprecated
    public CronInfo getCronInfo() {
        return this.CronInfo;
    }

    /**
     * Set 任务周期描述
     * @param CronInfo 任务周期描述
     * @deprecated
     */
    @Deprecated
    public void setCronInfo(CronInfo CronInfo) {
        this.CronInfo = CronInfo;
    }

    /**
     * Get 包年包月资源组ID 
     * @return ResourceGroupId 包年包月资源组ID
     */
    public String getResourceGroupId() {
        return this.ResourceGroupId;
    }

    /**
     * Set 包年包月资源组ID
     * @param ResourceGroupId 包年包月资源组ID
     */
    public void setResourceGroupId(String ResourceGroupId) {
        this.ResourceGroupId = ResourceGroupId;
    }

    /**
     * Get 标签配置 
     * @return Tags 标签配置
     */
    public Tag [] getTags() {
        return this.Tags;
    }

    /**
     * Set 标签配置
     * @param Tags 标签配置
     */
    public void setTags(Tag [] Tags) {
        this.Tags = Tags;
    }

    /**
     * Get 服务对应的模型信息，有模型文件时需要填写 
     * @return ModelInfo 服务对应的模型信息，有模型文件时需要填写
     */
    public ModelInfo getModelInfo() {
        return this.ModelInfo;
    }

    /**
     * Set 服务对应的模型信息，有模型文件时需要填写
     * @param ModelInfo 服务对应的模型信息，有模型文件时需要填写
     */
    public void setModelInfo(ModelInfo ModelInfo) {
        this.ModelInfo = ModelInfo;
    }

    /**
     * Get 自定义镜像信息 
     * @return ImageInfo 自定义镜像信息
     */
    public ImageInfo getImageInfo() {
        return this.ImageInfo;
    }

    /**
     * Set 自定义镜像信息
     * @param ImageInfo 自定义镜像信息
     */
    public void setImageInfo(ImageInfo ImageInfo) {
        this.ImageInfo = ImageInfo;
    }

    /**
     * Get 代码包 
     * @return CodePackage 代码包
     */
    public CosPathInfo getCodePackage() {
        return this.CodePackage;
    }

    /**
     * Set 代码包
     * @param CodePackage 代码包
     */
    public void setCodePackage(CosPathInfo CodePackage) {
        this.CodePackage = CodePackage;
    }

    /**
     * Get 启动命令 
     * @return StartCmd 启动命令
     * @deprecated
     */
    @Deprecated
    public String getStartCmd() {
        return this.StartCmd;
    }

    /**
     * Set 启动命令
     * @param StartCmd 启动命令
     * @deprecated
     */
    @Deprecated
    public void setStartCmd(String StartCmd) {
        this.StartCmd = StartCmd;
    }

    /**
     * Get 数据配置 
     * @return DataConfigs 数据配置
     */
    public DataConfig [] getDataConfigs() {
        return this.DataConfigs;
    }

    /**
     * Set 数据配置
     * @param DataConfigs 数据配置
     */
    public void setDataConfigs(DataConfig [] DataConfigs) {
        this.DataConfigs = DataConfigs;
    }

    /**
     * Get 日志配置 
     * @return LogConfig 日志配置
     */
    public LogConfig getLogConfig() {
        return this.LogConfig;
    }

    /**
     * Set 日志配置
     * @param LogConfig 日志配置
     */
    public void setLogConfig(LogConfig LogConfig) {
        this.LogConfig = LogConfig;
    }

    /**
     * Get VPC Id 
     * @return VpcId VPC Id
     */
    public String getVpcId() {
        return this.VpcId;
    }

    /**
     * Set VPC Id
     * @param VpcId VPC Id
     */
    public void setVpcId(String VpcId) {
        this.VpcId = VpcId;
    }

    /**
     * Get 子网Id 
     * @return SubnetId 子网Id
     */
    public String getSubnetId() {
        return this.SubnetId;
    }

    /**
     * Set 子网Id
     * @param SubnetId 子网Id
     */
    public void setSubnetId(String SubnetId) {
        this.SubnetId = SubnetId;
    }

    /**
     * Get 备注 
     * @return Remark 备注
     */
    public String getRemark() {
        return this.Remark;
    }

    /**
     * Set 备注
     * @param Remark 备注
     */
    public void setRemark(String Remark) {
        this.Remark = Remark;
    }

    /**
     * Get 任务执行结果回调URL，仅支持http和https。回调格式&内容详见: [TI-ONE 接口回调说明](https://cloud.tencent.com/document/product/851/84292) 
     * @return CallbackUrl 任务执行结果回调URL，仅支持http和https。回调格式&内容详见: [TI-ONE 接口回调说明](https://cloud.tencent.com/document/product/851/84292)
     */
    public String getCallbackUrl() {
        return this.CallbackUrl;
    }

    /**
     * Set 任务执行结果回调URL，仅支持http和https。回调格式&内容详见: [TI-ONE 接口回调说明](https://cloud.tencent.com/document/product/851/84292)
     * @param CallbackUrl 任务执行结果回调URL，仅支持http和https。回调格式&内容详见: [TI-ONE 接口回调说明](https://cloud.tencent.com/document/product/851/84292)
     */
    public void setCallbackUrl(String CallbackUrl) {
        this.CallbackUrl = CallbackUrl;
    }

    /**
     * Get 以Base64方式编码的启动命令。假设启动命令是/app/run.sh，则此处输入参数应该为L2FwcC9ydW4uc2g=。 
     * @return StartCmdBase64 以Base64方式编码的启动命令。假设启动命令是/app/run.sh，则此处输入参数应该为L2FwcC9ydW4uc2g=。
     */
    public String getStartCmdBase64() {
        return this.StartCmdBase64;
    }

    /**
     * Set 以Base64方式编码的启动命令。假设启动命令是/app/run.sh，则此处输入参数应该为L2FwcC9ydW4uc2g=。
     * @param StartCmdBase64 以Base64方式编码的启动命令。假设启动命令是/app/run.sh，则此处输入参数应该为L2FwcC9ydW4uc2g=。
     */
    public void setStartCmdBase64(String StartCmdBase64) {
        this.StartCmdBase64 = StartCmdBase64;
    }

    public CreateBatchTaskRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateBatchTaskRequest(CreateBatchTaskRequest source) {
        if (source.BatchTaskName != null) {
            this.BatchTaskName = new String(source.BatchTaskName);
        }
        if (source.ChargeType != null) {
            this.ChargeType = new String(source.ChargeType);
        }
        if (source.ResourceConfigInfo != null) {
            this.ResourceConfigInfo = new ResourceConfigInfo(source.ResourceConfigInfo);
        }
        if (source.Outputs != null) {
            this.Outputs = new DataConfig[source.Outputs.length];
            for (int i = 0; i < source.Outputs.length; i++) {
                this.Outputs[i] = new DataConfig(source.Outputs[i]);
            }
        }
        if (source.LogEnable != null) {
            this.LogEnable = new Boolean(source.LogEnable);
        }
        if (source.JobType != null) {
            this.JobType = new Long(source.JobType);
        }
        if (source.CronInfo != null) {
            this.CronInfo = new CronInfo(source.CronInfo);
        }
        if (source.ResourceGroupId != null) {
            this.ResourceGroupId = new String(source.ResourceGroupId);
        }
        if (source.Tags != null) {
            this.Tags = new Tag[source.Tags.length];
            for (int i = 0; i < source.Tags.length; i++) {
                this.Tags[i] = new Tag(source.Tags[i]);
            }
        }
        if (source.ModelInfo != null) {
            this.ModelInfo = new ModelInfo(source.ModelInfo);
        }
        if (source.ImageInfo != null) {
            this.ImageInfo = new ImageInfo(source.ImageInfo);
        }
        if (source.CodePackage != null) {
            this.CodePackage = new CosPathInfo(source.CodePackage);
        }
        if (source.StartCmd != null) {
            this.StartCmd = new String(source.StartCmd);
        }
        if (source.DataConfigs != null) {
            this.DataConfigs = new DataConfig[source.DataConfigs.length];
            for (int i = 0; i < source.DataConfigs.length; i++) {
                this.DataConfigs[i] = new DataConfig(source.DataConfigs[i]);
            }
        }
        if (source.LogConfig != null) {
            this.LogConfig = new LogConfig(source.LogConfig);
        }
        if (source.VpcId != null) {
            this.VpcId = new String(source.VpcId);
        }
        if (source.SubnetId != null) {
            this.SubnetId = new String(source.SubnetId);
        }
        if (source.Remark != null) {
            this.Remark = new String(source.Remark);
        }
        if (source.CallbackUrl != null) {
            this.CallbackUrl = new String(source.CallbackUrl);
        }
        if (source.StartCmdBase64 != null) {
            this.StartCmdBase64 = new String(source.StartCmdBase64);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "BatchTaskName", this.BatchTaskName);
        this.setParamSimple(map, prefix + "ChargeType", this.ChargeType);
        this.setParamObj(map, prefix + "ResourceConfigInfo.", this.ResourceConfigInfo);
        this.setParamArrayObj(map, prefix + "Outputs.", this.Outputs);
        this.setParamSimple(map, prefix + "LogEnable", this.LogEnable);
        this.setParamSimple(map, prefix + "JobType", this.JobType);
        this.setParamObj(map, prefix + "CronInfo.", this.CronInfo);
        this.setParamSimple(map, prefix + "ResourceGroupId", this.ResourceGroupId);
        this.setParamArrayObj(map, prefix + "Tags.", this.Tags);
        this.setParamObj(map, prefix + "ModelInfo.", this.ModelInfo);
        this.setParamObj(map, prefix + "ImageInfo.", this.ImageInfo);
        this.setParamObj(map, prefix + "CodePackage.", this.CodePackage);
        this.setParamSimple(map, prefix + "StartCmd", this.StartCmd);
        this.setParamArrayObj(map, prefix + "DataConfigs.", this.DataConfigs);
        this.setParamObj(map, prefix + "LogConfig.", this.LogConfig);
        this.setParamSimple(map, prefix + "VpcId", this.VpcId);
        this.setParamSimple(map, prefix + "SubnetId", this.SubnetId);
        this.setParamSimple(map, prefix + "Remark", this.Remark);
        this.setParamSimple(map, prefix + "CallbackUrl", this.CallbackUrl);
        this.setParamSimple(map, prefix + "StartCmdBase64", this.StartCmdBase64);

    }
}

