/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeRealTimeTaskSpeedRequest extends AbstractModel {

    /**
    * 无
    */
    @SerializedName("TaskId")
    @Expose
    private String TaskId;

    /**
    * 带毫秒的时间戳
    */
    @SerializedName("StartTime")
    @Expose
    private Long StartTime;

    /**
    * 带毫秒的时间戳
    */
    @SerializedName("EndTime")
    @Expose
    private Long EndTime;

    /**
    * 粒度，1或者5
    */
    @SerializedName("Granularity")
    @Expose
    private Long Granularity;

    /**
    * 无
    */
    @SerializedName("ProjectId")
    @Expose
    private String ProjectId;

    /**
     * Get 无 
     * @return TaskId 无
     */
    public String getTaskId() {
        return this.TaskId;
    }

    /**
     * Set 无
     * @param TaskId 无
     */
    public void setTaskId(String TaskId) {
        this.TaskId = TaskId;
    }

    /**
     * Get 带毫秒的时间戳 
     * @return StartTime 带毫秒的时间戳
     */
    public Long getStartTime() {
        return this.StartTime;
    }

    /**
     * Set 带毫秒的时间戳
     * @param StartTime 带毫秒的时间戳
     */
    public void setStartTime(Long StartTime) {
        this.StartTime = StartTime;
    }

    /**
     * Get 带毫秒的时间戳 
     * @return EndTime 带毫秒的时间戳
     */
    public Long getEndTime() {
        return this.EndTime;
    }

    /**
     * Set 带毫秒的时间戳
     * @param EndTime 带毫秒的时间戳
     */
    public void setEndTime(Long EndTime) {
        this.EndTime = EndTime;
    }

    /**
     * Get 粒度，1或者5 
     * @return Granularity 粒度，1或者5
     */
    public Long getGranularity() {
        return this.Granularity;
    }

    /**
     * Set 粒度，1或者5
     * @param Granularity 粒度，1或者5
     */
    public void setGranularity(Long Granularity) {
        this.Granularity = Granularity;
    }

    /**
     * Get 无 
     * @return ProjectId 无
     */
    public String getProjectId() {
        return this.ProjectId;
    }

    /**
     * Set 无
     * @param ProjectId 无
     */
    public void setProjectId(String ProjectId) {
        this.ProjectId = ProjectId;
    }

    public DescribeRealTimeTaskSpeedRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeRealTimeTaskSpeedRequest(DescribeRealTimeTaskSpeedRequest source) {
        if (source.TaskId != null) {
            this.TaskId = new String(source.TaskId);
        }
        if (source.StartTime != null) {
            this.StartTime = new Long(source.StartTime);
        }
        if (source.EndTime != null) {
            this.EndTime = new Long(source.EndTime);
        }
        if (source.Granularity != null) {
            this.Granularity = new Long(source.Granularity);
        }
        if (source.ProjectId != null) {
            this.ProjectId = new String(source.ProjectId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TaskId", this.TaskId);
        this.setParamSimple(map, prefix + "StartTime", this.StartTime);
        this.setParamSimple(map, prefix + "EndTime", this.EndTime);
        this.setParamSimple(map, prefix + "Granularity", this.Granularity);
        this.setParamSimple(map, prefix + "ProjectId", this.ProjectId);

    }
}

