/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.bsca.v20210811.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class VulnerabilityUnion extends AbstractModel{

    /**
    * 漏洞概览信息
    */
    @SerializedName("Summary")
    @Expose
    private VulnerabilitySummary Summary;

    /**
    * 漏洞详细信息
    */
    @SerializedName("Detail")
    @Expose
    private VulnerabilityDetail Detail;

    /**
     * Get 漏洞概览信息 
     * @return Summary 漏洞概览信息
     */
    public VulnerabilitySummary getSummary() {
        return this.Summary;
    }

    /**
     * Set 漏洞概览信息
     * @param Summary 漏洞概览信息
     */
    public void setSummary(VulnerabilitySummary Summary) {
        this.Summary = Summary;
    }

    /**
     * Get 漏洞详细信息 
     * @return Detail 漏洞详细信息
     */
    public VulnerabilityDetail getDetail() {
        return this.Detail;
    }

    /**
     * Set 漏洞详细信息
     * @param Detail 漏洞详细信息
     */
    public void setDetail(VulnerabilityDetail Detail) {
        this.Detail = Detail;
    }

    public VulnerabilityUnion() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public VulnerabilityUnion(VulnerabilityUnion source) {
        if (source.Summary != null) {
            this.Summary = new VulnerabilitySummary(source.Summary);
        }
        if (source.Detail != null) {
            this.Detail = new VulnerabilityDetail(source.Detail);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "Summary.", this.Summary);
        this.setParamObj(map, prefix + "Detail.", this.Detail);

    }
}

