package com.tencentcloudapi.nlp.v20190408;
public enum NlpErrorCode {
    // 请求头部的 Authorization 不符合腾讯云标准。
     AUTHFAILURE_INVALIDAUTHORIZATION("AuthFailure.InvalidAuthorization"),
     
    // 操作失败。
     FAILEDOPERATION("FailedOperation"),
     
    // 余额不足，开通失败，请充值后再开通。
     FAILEDOPERATION_BALANCEINSUFFICIENT("FailedOperation.BalanceInsufficient"),
     
    // 非法文本输入导致返回异常
     FAILEDOPERATION_ILLEGALTEXTERROR("FailedOperation.IllegalTextError"),
     
    // 服务内部错误，请重试。
     FAILEDOPERATION_INNERERROR("FailedOperation.InnerError"),
     
    // 暂无春联生成，请更换关键词重试。
     FAILEDOPERATION_NOCOUPLETS("FailedOperation.NoCouplets"),
     
    // 暂无诗词生成，请更换关键词重试。
     FAILEDOPERATION_NOPOETRY("FailedOperation.NoPoetry"),
     
    // 暂无结果，请更换文本重试。
     FAILEDOPERATION_NORESULTS("FailedOperation.NoResults"),
     
    // 未查询到结果。
     FAILEDOPERATION_NOTFOUNDDATA("FailedOperation.NotFoundData"),
     
    // 后端服务超时。
     FAILEDOPERATION_REQUESTTIMEOUT("FailedOperation.RequestTimeout"),
     
    // 服务器繁忙，请稍后再试。
     FAILEDOPERATION_RESOURCEBUSY("FailedOperation.ResourceBusy"),
     
    // RPC请求失败，一般为算法微服务故障。
     FAILEDOPERATION_RPCFAIL("FailedOperation.RpcFail"),
     
    // 文本向量化失败
     FAILEDOPERATION_TEXTEMBEDDINGFAILED("FailedOperation.TextEmbeddingFailed"),
     
    // 内部错误。
     FAILEDOPERATION_UNKNOWERROR("FailedOperation.UnKnowError"),
     
    // 未知错误。
     FAILEDOPERATION_UNKNOWN("FailedOperation.Unknown"),
     
    // 查找不到词语
     FAILEDOPERATION_WORDNOTFOUND("FailedOperation.WordNotFound"),
     
    // 内部错误。
     INTERNALERROR("InternalError"),
     
    // 资源请求错误
     INTERNALERROR_RESOURCEREQUESTERROR("InternalError.ResourceRequestError"),
     
    // 内部服务调用错误。
     INTERNALERROR_SERVICECALLERROR("InternalError.ServiceCallError"),
     
    // 内部服务调用失败。
     INTERNALERROR_SERVICEERROR("InternalError.ServiceError"),
     
    // 参数错误。
     INVALIDPARAMETER("InvalidParameter"),
     
    // 服务调用失败。
     INVALIDPARAMETER_SERVICEERROR("InvalidParameter.ServiceError"),
     
    // 文本长度超过限制。
     INVALIDPARAMETER_TEXTTOOLONGCODE("InvalidParameter.TextTooLongCode"),
     
    // 参数空值错误
     INVALIDPARAMETERVALUE_EMPTYVALUEERROR("InvalidParameterValue.EmptyValueError"),
     
    // Genre非法，请参考Genre参数说明。
     INVALIDPARAMETERVALUE_GENRE("InvalidParameterValue.Genre"),
     
    // 参数不合法。
     INVALIDPARAMETERVALUE_INVALIDPARAMETER("InvalidParameterValue.InvalidParameter"),
     
    // PoetryType非法，请参考PoetryType参数说明。
     INVALIDPARAMETERVALUE_POETRYTYPE("InvalidParameterValue.PoetryType"),
     
    // Text输入含有敏感信息。
     INVALIDPARAMETERVALUE_SENSITIVETEXT("InvalidParameterValue.SensitiveText"),
     
    // TargetType非法，请参考TargetType参数说明。
     INVALIDPARAMETERVALUE_TARGETTYPE("InvalidParameterValue.TargetType"),
     
    // Text非法，请参考Text参数说明。
     INVALIDPARAMETERVALUE_TEXT("InvalidParameterValue.Text"),
     
    // 文本编码错误，不符合utf-8
     INVALIDPARAMETERVALUE_TEXTENCODEERROR("InvalidParameterValue.TextEncodeError"),
     
    // 文本输入格式错误
     INVALIDPARAMETERVALUE_TEXTFORMATERROR("InvalidParameterValue.TextFormatError"),
     
    // 输入文本超出数量限制
     INVALIDPARAMETERVALUE_TEXTNUMTOOMUCH("InvalidParameterValue.TextNumTooMuch"),
     
    // 输入文本超出长度限制
     INVALIDPARAMETERVALUE_TEXTTOOLONG("InvalidParameterValue.TextTooLong"),
     
    // 参数取值范围错误
     INVALIDPARAMETERVALUE_VALUERANGEERROR("InvalidParameterValue.ValueRangeError"),
     
    // 资源用量达到上限。
     LIMITEXCEEDED_RESOURCEREACHEDLIMIT("LimitExceeded.ResourceReachedLimit"),
     
    // 请求的次数超过了频率限制。
     REQUESTLIMITEXCEEDED_UINLIMITEXCEEDED("RequestLimitExceeded.UinLimitExceeded"),
     
    // 名称已存在
     RESOURCEINUSE_NAMEEXISTS("ResourceInUse.NameExists"),
     
    // 资源正在操作中
     RESOURCEINUSE_RESOURCEOPERATING("ResourceInUse.ResourceOperating"),
     
    // 额度用尽，请充值后重试
     RESOURCEINSUFFICIENT_QUOTARUNOUT("ResourceInsufficient.QuotaRunOut"),
     
    // 资源不存在。
     RESOURCENOTFOUND("ResourceNotFound"),
     
    // 数据资源不存在
     RESOURCENOTFOUND_DATANOTFOUND("ResourceNotFound.DataNotFound"),
     
    // 文件资源不存在
     RESOURCENOTFOUND_FILENOTFOUND("ResourceNotFound.FileNotFound"),
     
    // 资源不可用。
     RESOURCEUNAVAILABLE("ResourceUnavailable"),
     
    // 文件资源不可用
     RESOURCEUNAVAILABLE_FILEUNAVAILABLE("ResourceUnavailable.FileUnavailable"),
     
    // 帐号已被冻结。
     RESOURCEUNAVAILABLE_FREEZE("ResourceUnavailable.Freeze"),
     
    // 账号已欠费。
     RESOURCEUNAVAILABLE_INARREARS("ResourceUnavailable.InArrears"),
     
    // 服务正在开通中，请稍等。
     RESOURCEUNAVAILABLE_ISOPENING("ResourceUnavailable.IsOpening"),
     
    // 计费状态未知，请确认是否已在控制台开通服务。
     RESOURCEUNAVAILABLE_NOTEXIST("ResourceUnavailable.NotExist"),
     
    // 资源已被回收。
     RESOURCEUNAVAILABLE_RECOVER("ResourceUnavailable.Recover"),
     
    // 您的账号尚未开通NLP服务，请登录腾讯云NLP控制台进行服务开通后再使用
     RESOURCEUNAVAILABLE_SERVICENOTOPENEDERROR("ResourceUnavailable.ServiceNotOpenedError"),
     
    // 帐号已停服。
     RESOURCEUNAVAILABLE_STOPUSING("ResourceUnavailable.StopUsing"),
     
    // 实名认证失败
     UNAUTHORIZEDOPERATION_AUTHENTICATEFAILED("UnauthorizedOperation.AuthenticateFailed");
     
    private String value;
    private NlpErrorCode (String value){
        this.value = value;
    }
    /**
     * @return errorcode value
     */
    public String getValue() {
        return value;
    }
}

