package com.mediamain.android;

import android.content.Context;

import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.meituan.robust.Patch;
import com.meituan.robust.PatchManipulate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/**
 *    我们推荐继承PatchManipulate实现你们App独特的A补丁加载策略，其中setLocalPath设置补丁的原始路径，这个路径存储的补丁是加密过得，
 *    setTempPath存储解密之后的补丁，是可以执行的jar文件setTempPath设置的补丁加载完毕即刻删除，如果不需要加密和解密补丁，两者没有啥区别
 *
 */

public class PatchManipulateImp extends PatchManipulate {

    /***
     * connect to the network ,get the latest patches
     * l联网获取最新的补丁
     * @param context
     *
     * @return
     */
    @Override
    protected List<Patch> fetchPatchList(Context context) {

        Patch patch = new Patch();
        patch.setName("fox_patch");
        //LocalPath是存储原始的补丁文件，这个文件应该是加密过的，TempPath是加密之后的，TempPath下的补丁加载完毕就删除，保证安全性
        //这里面需要设置一些补丁的信息，主要是联网的获取的补丁信息。重要的如MD5，进行原始补丁文件的简单校验，以及补丁存储的位置，这边推荐把补丁的储存位置放置到应用的私有目录下，保证安全性
//        patch.setLocalPath(Environment.getExternalStorageDirectory().getPath()+ File.separator+"robust"+File.separator + "patch");
        patch.setLocalPath(context.getFilesDir()+ File.separator+"foxes"+File.separator + "fox");

        //setPatchesInfoImplClassFullName 设置项各个App可以独立定制，需要确保的是setPatchesInfoImplClassFullName设置的包名是和xml配置项patchPackname保持一致，而且类名必须是：PatchesInfoImpl
        //请注意这里的设置
        patch.setPatchesInfoImplClassFullName("com.meituan.robust.patch.PatchesInfoImpl");
        List  patches = new ArrayList<Patch>();
        patches.add(patch);
        return patches;
    }


    /**
     *
     * @param context
     * @param patch
     * @return
     *
     * you can verify your patches here
     */
    @Override

    protected boolean verifyPatch(Context context, Patch patch) {
        //放到app的私有目录
        patch.setTempPath(context.getCacheDir()+ File.separator+"foxes"+File.separator + "fox");
        try {
            copy(patch.getLocalPath(), patch.getTempPath());
        }catch (Exception e){
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }

        return true;
    }
    public void copy(String srcPath,String dstPath) throws IOException {
        File src=new File(srcPath);
        FoxBaseLogUtils.eTag("fixfix","本地补丁路径="+srcPath);
        FoxBaseLogUtils.eTag("fixfix","本地补丁是否存在="+src.exists());
        if(!src.exists()){
            throw new RuntimeException("source patch does not exist ");
        }
        File dst=new File(dstPath);
        if(!dst.getParentFile().exists()){
            dst.getParentFile().mkdirs();
        }
        InputStream in = new FileInputStream(src);
        try {
            OutputStream out = new FileOutputStream(dst);
            try {
                byte[] buf = new byte[1024];
                int len;
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            } finally {
                try {
                    out.close();
                } catch (Exception e) {
                    FoxBaseCrashUtils.reportErrorData(e);
                    e.printStackTrace();
                }
            }
        } finally {
            try {
                in.close();
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }
    }
    /**
     *
     * @param patch
     * @return
     *
     * you may download your patches here, you can check whether patch is in the phone
     */
    @Override
    protected boolean ensurePatchExist(Patch patch) {
        return true;
    }

}
