package com.mediamain.android.base;

import android.text.TextUtils;

import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.okgo.request.PostRequest;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * author: likaixuan
 * date: 2020/10/28
 * desc: 行为跟踪器：曝光、点击、上报数据
 */
public class BehaviorTracker {
    private final String TAG = "FoxTracker";
    /**
     * 行为上报的url链接
     */
    private String url;

    /**
     * Get方式上报的参数
     */
    private Map<String, String> params = new HashMap<>(16);

    /**
     * Post方式上报的参数
     */
    private JSONObject postParams = new JSONObject();

    private BehaviorTracker() {}

    private static class Holder {
        public static BehaviorTracker instance = new BehaviorTracker();
    }

    public static BehaviorTracker getInstance() {
        return Holder.instance;
    }

    public BehaviorTracker setUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get 方式上报，增加上报字段
     * @param key field name
     * @param value field value
     */
    public BehaviorTracker addParam(String key, String value) {
        params.put(key, value);
        return this;
    }

    /**
     * post 方式上报，增加上报字段
     * @param key filed name
     * @param value field value
     * @return instance
     */
    public BehaviorTracker addPostParam(String key, String value) {
        try {
            postParams.put(key, value);
        } catch (JSONException e) {
            FoxBaseCrashUtils.reportErrorData(e);
        }
        return this;
    }

    /**
     * Get 方式上报
     */
    public void track() {
        if (TextUtils.isEmpty(url)) {
            throw new IllegalArgumentException("点击上报的url为空");
        }
        FoxBaseLogUtils.dTag(TAG, "track url:" + url);
        OkGo.<String>get(url).params(params).execute(new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

            }
        });
    }

    /**
     * Post 方式上报
     */
    public void post() {
        if (TextUtils.isEmpty(url)) {
            throw new IllegalArgumentException("点击上报的url为空");
        }
        if (postParams == null || postParams.length() <= 0) {
            throw new IllegalArgumentException("No fields to upload!");
        }
        FoxBaseLogUtils.dTag(TAG, "post url:" + url);
        final PostRequest<String> request = OkGo.<String>post(url);
        request.upJson(postParams.toString()).execute(new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {
                FoxBaseLogUtils.dTag(TAG, "数据上报成功!");
            }
        });
    }
}
