package com.mediamain.android.base;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;

import com.mediamain.android.BuildConfig;
import com.mediamain.android.base.config.FoxBaseConstants;
import com.mediamain.android.base.config.FoxBaseUrl;
import com.mediamain.android.base.data.FoxBaseSDKConfigBean;
import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseGsonUtil;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.FoxBaseUtils;
import com.mediamain.android.base.util.FoxCycleReportTask;
import com.mediamain.android.base.util.FoxTimeRecordTask;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.hotfix.FoxSdkPatch;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

import static com.mediamain.android.base.util.FoxBaseCommonUtils.getModel;
import static com.mediamain.android.hotfix.FoxSdkPatch.LOCAL_PATCH_CODE;
import static com.mediamain.android.hotfix.FoxSdkPatch.LOCAL_PATCH_VERSION;

/**
 * @author lzy
 * Time: 2019/08/27
 * Description:
 */
public class FoxBaseSDK {

    public static final String QUERY_COMMON_CONFIG = "query_common_config";
    public static final String SP_USER_EMPOWER = "sp_user_empower";
    public static String mUnCollects = "";
    public static boolean isInit = false;

    private static Application mApplication;
    private static ApplicationInfo mInfo;

    private static List<String> mNeedAuths;
    private static String mAppKey;
    private static String mAppSecret;
    private static int mDataFrom;
    private static String mConfigData;
    private static String signature;
    private static FoxCycleReportTask mFoxCycleReportTask;

    public static void init(Application application, String packageName, int dataFrom) {
        init(application, packageName, dataFrom, "");
    }

    public static void init(Application application, String packageName, int dataFrom, String configData) {
        init(application, packageName, dataFrom, configData, null);
    }

    public static void init(Application application, String packageName, int dataFrom, String configData, ApplicationInfo info) {
        // 获取tcid 前置
        FoxBaseCommonUtils.getTcid();
        isInit = true;
        mInfo = info;
        if (mApplication == null) {
            mApplication = application;
            try {
                OkGo.getInstance().init(application);
//                FoxBaseUtils.init(application);
                FoxBaseCrashUtils.init(application, packageName, dataFrom, configData);

                //获取配置信息
                queryCommonConfig(dataFrom, configData);
            } catch (Exception e) {
            }
        }
    }

    public static ApplicationInfo getApplicationInfo() {
        return mInfo;
    }

    public static Context getContext() {
        if (mApplication != null) {
            return mApplication;
        } else {
            return getApplicationByReflect();
        }
    }

    public static void userEmpower(boolean isEmpower) {
        if (!isEmpower) {
            FoxBaseSPUtils.getInstance().setString(SP_USER_EMPOWER, "");
            return;
        }
        if (!FoxBaseCommonUtils.isEmpty(mUnCollects) && !FoxBaseCommonUtils.isEmpty(mNeedAuths)) {
            String needAuths = FoxBaseCommonUtils.listToString(mNeedAuths);
            FoxBaseSPUtils.getInstance().setString(SP_USER_EMPOWER, needAuths);
            for (String s : mNeedAuths) {
                mUnCollects = mUnCollects.replaceAll(s, "");
            }
        }

    }

    public static boolean isDebug() {
        return BuildConfig.DEBUG_LOG;
    }

//-------------------------------------------------Private--------------------------------------------------------------

    private static Application getApplicationByReflect() {
        try {
            @SuppressLint("PrivateApi")
            Class<?> activityThread = Class.forName("android.app.ActivityThread");
            Object thread = activityThread.getMethod("currentActivityThread").invoke(null);
            Object app = activityThread.getMethod("getApplication").invoke(thread);
            return (Application) app;
        } catch (Exception e) {
        }
        return null;
    }

    private static void queryCommonConfig(int dataFrom, String configData) {
        try {
            mDataFrom = dataFrom;
            mConfigData = configData;

            //避免多次请求
            boolean isQueries = FoxBaseSPUtils.getInstance().getBoolean(QUERY_COMMON_CONFIG, false);
            if (isQueries) {
                FoxBaseSPUtils.getInstance().setBoolean(QUERY_COMMON_CONFIG, false);
                return;
            }

            if (null == mFoxCycleReportTask) {
                mFoxCycleReportTask = new FoxCycleReportTask(getContext(), null, null
                        , mDataFrom, mConfigData, 0);
            }
            getSDKConfig();
        } catch (Exception e) {
        }
    }

    /**
     * 获取配置信息
     */
    private static void getSDKConfig() {
        try {
            FoxBaseSPUtils.getInstance().setBoolean(QUERY_COMMON_CONFIG, true);

            if (FoxBaseSDK.getContext() == null) {
                return;
            }
            mAppKey = FoxBaseCommonUtils.getAppKey();
            mAppSecret = FoxBaseCommonUtils.getAppSecret();
            if (FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
                return;
            }
            String imei = FoxBaseCommonUtils.getIMEI() + "";
            final String phoneBrand = Build.MANUFACTURER;
            final String phoneModel = getModel();
            final String osType = "Android";
            final String oaid = FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_APP_OAID, "") + "";
            TreeMap<String, String> mMap = new TreeMap<>();
            mMap.put("appKey", "" + mAppKey);
            mMap.put("phoneBrand", "" + phoneBrand);
            mMap.put("phoneModel", "" + phoneModel);
            mMap.put("imei", "" + imei);
            mMap.put("oaid", "" + oaid);
            mMap.put("idfa", "");
            mMap.put("deviceId", "" + imei);
            mMap.put("sdkVersion", "" + BuildConfig.VERSION_NAME);
            mMap.put("osType", "" + osType);
            mMap.put("patchVersion", FoxBaseSPUtils.getInstance().getString(LOCAL_PATCH_VERSION,""));
            mMap.put("patchCode", FoxBaseSPUtils.getInstance().getLong(LOCAL_PATCH_CODE,0l) + "");
            // 拼接要签名的参数字符串
            StringBuilder signSB = new StringBuilder();
            // 对map的key进行排序
            Set<String> keySet = mMap.keySet();
            Iterator<String> iter = keySet.iterator();
            while (iter.hasNext()) {
                String key = iter.next();
                signSB = signSB.append(key).append("=").append(mMap.get(key)).append("&");
            }
            String signStr = signSB.substring(0, signSB.length() - 1);
            // 对参数字符串进行SHA-1
            signature = FoxBaseCommonUtils.sha1(signStr);
            mMap.put("signature", signature);
            mMap.put("tcid", FoxBaseCommonUtils.getTcid());
            OkGo.<String>post(FoxBaseUrl.BASE_SDK_PUT_QUERYCOMMONCONFIG)
                .upJson(FoxBaseGsonUtil.GsonString(mMap))
                .execute(new StringCallback() {
                    @Override
                    public void onSuccess(Response<String> response) {
                        try {
                            if (response == null || response.body() == null) {
                                return;
                            }
                            FoxBaseSDKConfigBean sdkConfigBean = FoxBaseGsonUtil.GsonToBean(response.body(), FoxBaseSDKConfigBean.class);
                            if ( null == sdkConfigBean || null == sdkConfigBean.getData() ) {
                                return;
                            }
                            FoxBaseSDKConfigBean.DataBean dataBean = sdkConfigBean.getData();
                            //补丁处理
                            FoxSdkPatch.init(getContext(),dataBean);

                            //数据采集过滤
                            List<String> unCollects = sdkConfigBean.getData().getCollectShieldFields();
                            mNeedAuths = sdkConfigBean.getData().getNeedAuthFields();
                            if (!FoxBaseCommonUtils.isEmpty(unCollects)) {
                                mUnCollects = FoxBaseCommonUtils.listToString(unCollects);
                            }
                            if (!FoxBaseCommonUtils.isEmpty(mNeedAuths)) {
                                String needAuths = FoxBaseCommonUtils.listToString(mNeedAuths);
                                if (!FoxBaseSPUtils.getInstance().getString(SP_USER_EMPOWER, "").equals(needAuths)) {
                                    //没有授权历史
                                    mUnCollects = mUnCollects + "," + FoxBaseCommonUtils.listToString(mNeedAuths);
                                } else {
                                    //恢复授权历史状态
                                    for (String auth : mNeedAuths) {
                                        mUnCollects = mUnCollects.replaceAll(auth, "");
                                    }
                                }
                            }
                            //第一次数据采集
                            if (sdkConfigBean.getData().isCollectUserInfo()) {
                                dealCWork();
                            }
                            //数据采集轮训（单位：分钟）
                            if (sdkConfigBean.getData().getCollectEnable() == 1) {
                                if (getContext() != null) {
                                    mFoxCycleReportTask.setUploadInterval(sdkConfigBean.getData().getCollectFrequency() * 60);
                                    mFoxCycleReportTask.setmConfigData(mConfigData);
                                    mFoxCycleReportTask.setmDataFrom(mDataFrom);
                                    mFoxCycleReportTask.startCycleReportTask(false);
                                }
                            }
                            // 记录用户使用时长
                            if (sdkConfigBean.getData().getCloseEventEnable() == 1) {
                                FoxTimeRecordTask foxTimeRecordTask = new FoxTimeRecordTask(getContext(), null, null);
                                foxTimeRecordTask.startRecordTask();
                            }
                            FoxBaseSPUtils.getInstance().setBoolean(FoxBaseConstants.KEY_TUIA_SDK_ISSUPPORTDOWNLOAD, sdkConfigBean.getData().isSupportDownload());
                            FoxBaseSPUtils.getInstance().setString(FoxBaseConstants.KEY_TUIA_SDK_CONFIG, FoxBaseGsonUtil.GsonString(sdkConfigBean.getData()));
                            FoxBaseSPUtils.getInstance().setString(FoxBaseConstants.KEY_FLOATING_WEB_AD_URL, sdkConfigBean.getData().getFloatingWebAdUrl());
                            FoxBaseSPUtils.getInstance().setInt(FoxBaseConstants.KEY_TUIA_SDK_ERROR_REPORT_SWITCH, sdkConfigBean.getData().getCrashReportEnable());
                            FoxBaseSPUtils.getInstance().setInt(FoxBaseConstants.KEY_TUIA_SDK_ERROR_REPORT_TIME_INTERVAL, sdkConfigBean.getData().getCrashReportInterval());
                        } catch (Exception e) {
                            FoxBaseCrashUtils.reportErrorData(e);
                        } finally {
                            FoxBaseSPUtils.getInstance().setBoolean(QUERY_COMMON_CONFIG, false);
                        }
                    }

                    @Override
                    public void onError(Response<String> response) {
                        super.onError(response);
                        FoxBaseSPUtils.getInstance().setBoolean(QUERY_COMMON_CONFIG, false);
                    }
                });
        } catch (Exception ignored) {
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
        finally {
            FoxBaseSPUtils.getInstance().setBoolean(QUERY_COMMON_CONFIG, false);
        }
    }

    /**
     * 触发采集任务
     */
    private static void dealCWork() {
        try {
            if (mFoxCycleReportTask == null) {
                mFoxCycleReportTask = new FoxCycleReportTask(getContext(), null, null
                        , mDataFrom, mConfigData, 0);
            }
            mFoxCycleReportTask.startCycleReportTask();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
        }
    }
}
