package com.mediamain.android.base;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;

import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.util.FoxBaseAppUtil;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.FoxBaseUtils;
import com.mediamain.android.R;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.io.File;

import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_INSTALL_START;
import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_OPEN_SUCCESS;

public class FoxRouteActivity extends Activity {

    public static final int TYPE = 157;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.fox_activity_route);
        try {
            final Intent intent = getIntent();
            if (intent!=null){
                final String packageName = intent.getStringExtra("packageName");
                final String fileName = intent.getStringExtra("file");
                final String mTuiaId = intent.getStringExtra("tuiaId");
                final String url = intent.getStringExtra("url");
                if (!FoxBaseCommonUtils.isEmpty(packageName) && FoxBaseAppUtil.isAppInstall(FoxRouteActivity.this, packageName)) {
                    FoxBaseAppUtil.openOtherApp(FoxBaseUtils.getApp(),packageName);
                    FoxBaseMaidianUtil.build(TYPE)
                        .set("tuia_id", mTuiaId)
                        .set("sub_type", Constants.SUB_TYPE_OPEN)
                        .set("businessType", Integer.toString(KEY_CHECK_OPEN_SUCCESS))
                        .set("package_name", packageName)
                        .set("url_package", url)
                        .set("is_rail", "1")
                        .postCheck();

                }else {
                    if (!FoxBaseCommonUtils.isEmpty(fileName)){
                        final File file = new File(fileName);
                        if (file!=null && file.exists()){
                            FoxBaseAppUtil.openFile(FoxBaseUtils.getApp(),file);
                            FoxBaseMaidianUtil.build(TYPE)
                                .set("sub_type", Constants.SUB_TYPE_INSTALL)
                                .set("businessType", Integer.toString(KEY_CHECK_INSTALL_START))
                                .set("tuia_id", mTuiaId)
                                .set("package_name", packageName)
                                .set("url_package", url)
                                .set("is_rail", "1")
                                .postCheck();
                        }
                    }

                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
        }
        finish();
    }
}
