package com.mediamain.android.base.config;

import java.util.HashMap;
import java.util.Map;

/**
 * author: likaixuan
 * date: 2020/8/24
 * desc: 环境切换，因为日志收集，素材曝光和点击都是sdk内部进行的，所以AutoConfig只能定义在sdk中
 * question:
 * 1.如果媒体调用了AutoConfig.init()方法呢？
 * 2.日志收集的url，第一次会根据build type(默认test)决定，切换环境后，根据环境变化
 */
public class AutoConfig {
    public static final int DEV = 0;
    public static final int TEST = 1;
    public static final int PRE = 2;
    public static final int RELEASE = 3;

    private static Map<String, String> configMap = new HashMap<>(10);

    static {
        configMap.put("app_key", "4UycwwZv41rwzne1ZXgtQBgDSnPH");
        configMap.put("app_secret", "3WpyTLfifQyGhvgivxtUjvzXxtkzdceETBU2n5g");

        configMap.put("host", "https://engine.tuia.cn");
        configMap.put("host_url", "https://engine.tuia.cn/index/sdk/serving");
        configMap.put("host_key", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC8p3Zdgu9HDu0eAA5ZRaD1Jq3rr/hCgRq7tHXD4M9Ww4LSSrF7Rw/aAQcDaes7sjje354/RkVYRHqFYA+nHTS2xNvadm8m1die1PFxgcsGSCx0sHSyxMbghru+A/TkeIJMs+eWeDyk28KzN47Fh4QDzSKYmIgQU0q0gkXOrbf2mwIDAQAB");
        configMap.put("host_activity", "https://activity.tuia.cn");
        configMap.put("host_old_comm", "https://engine.tuia.cn/index/activity?sdkVersionName=%s&sdkVersionCode=%s&returnScene=0&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s");
        configMap.put("host_old_more", "https://engine.tuia.cn/index/activity?sdkVersionName=%s&sdkVersionCode=%s&returnScene=2&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s");
        configMap.put("host_comm", "https://activity.tuia.cn/native/nativeApi?sdkVersionName=%s&sdkVersionCode=%s&returnScene=0&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s&isEmbed=%s&isNewApi=1");
        configMap.put("host_more", "https://activity.tuia.cn/native/nativeApi?sdkVersionName=%s&sdkVersionCode=%s&returnScene=2&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s&isEmbed=%s");

    }

    public static void init(int env) {
        switch (env) {
            case TEST:
                configMap.put("app_key", "427wTcUcwxkttDmGcqYMTU7NJo3k");
                configMap.put("app_secret", "3Wfp5DiA5jqVaUZ8CMkJemWopxefsBxtwm6mk67");

                configMap.put("host", "https://engine.tuiatest.cn");
                configMap.put("host_url", "https://engine.tuiatest.cn/index/sdk/serving");
                configMap.put("host_key", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCH7qD/XYZJZnWv4sULdNlphWtUQju3wKz5ekpbn0jXRvj88MjuS+RnfGZ1M7AVFEoNQMR0oyrxK6cihUUDINkC1oU/M4e03d9SDNe1Vmnl2rTe3ctRI2AvW6QW3CEmNFST3yBwiC8p0lJrKonA7eXcy39aAGFg3F8e4WsD93ZS4QIDAQAB");
                configMap.put("host_activity", "https://activity.tuiatest.cn");
                configMap.put("host_old_comm", "https://engine.tuiatest.cn/index/activity?sdkVersionName=%s&sdkVersionCode=%s&returnScene=0&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s");
                configMap.put("host_old_more", "https://engine.tuiatest.cn/index/activity?sdkVersionName=%s&sdkVersionCode=%s&returnScene=2&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s");
                configMap.put("host_comm", "https://activity.tuiatest.cn/native/nativeApi?sdkVersionName=%s&sdkVersionCode=%s&returnScene=0&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s&isEmbed=%s&isNewApi=1");
                configMap.put("host_more", "https://activity.tuiatest.cn/native/nativeApi?sdkVersionName=%s&sdkVersionCode=%s&returnScene=2&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s&isEmbed=%s");
                break;
            case PRE:
                configMap.put("app_key", "4UycwwZv41rwzne1ZXgtQBgDSnPH");
                configMap.put("app_secret", "3WpyTLfifQyGhvgivxtUjvzXxtkzdceETBU2n5g");

                configMap.put("host", "https://engine.tuiapre.cn");
                configMap.put("host_url", "https://engine.tuiapre.cn/index/sdk/serving");
                configMap.put("host_key", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCi6EKXURr/usJ15JsQKzQtUDu5Pj0pqlAuklm3wecH3XIoUQOUN7CvjpmorxtPh/OJTpZip02HP/P2oFdYkYqm1KszWlM9hBZhWrXfO0zCtMribFCaVdTfFZc/pflwLgrU52Gep4ir1AbPh9tyUfenFflSlTC2QooC5JjPhHuP+wIDAQAB");
                configMap.put("host_activity", "https://activity.tuiapre.cn");
                configMap.put("host_old_comm", "https://engine.tuiapre.cn/index/activity?sdkVersionName=%s&sdkVersionCode=%s&returnScene=0&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s");
                configMap.put("host_old_more", "https://engine.tuiapre.cn/index/activity?sdkVersionName=%s&sdkVersionCode=%s&returnScene=2&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s");
                configMap.put("host_comm", "https://activity.tuiapre.cn/native/nativeApi?sdkVersionName=%s&sdkVersionCode=%s&returnScene=0&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s&isEmbed=%s&isNewApi=1");
                configMap.put("host_more", "https://activity.tuiapre.cn/native/nativeApi?sdkVersionName=%s&sdkVersionCode=%s&returnScene=2&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s&isEmbed=%s");
                break;
            case DEV:
            case RELEASE:
                configMap.put("app_key", "4UycwwZv41rwzne1ZXgtQBgDSnPH");
                configMap.put("app_secret", "3WpyTLfifQyGhvgivxtUjvzXxtkzdceETBU2n5g");

                configMap.put("host", "https://engine.tuia.cn");
                configMap.put("host_url", "https://engine.tuia.cn/index/sdk/serving");
                configMap.put("host_key", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC8p3Zdgu9HDu0eAA5ZRaD1Jq3rr/hCgRq7tHXD4M9Ww4LSSrF7Rw/aAQcDaes7sjje354/RkVYRHqFYA+nHTS2xNvadm8m1die1PFxgcsGSCx0sHSyxMbghru+A/TkeIJMs+eWeDyk28KzN47Fh4QDzSKYmIgQU0q0gkXOrbf2mwIDAQAB");
                configMap.put("host_activity", "https://activity.tuia.cn");
                configMap.put("host_old_comm", "https://engine.tuia.cn/index/activity?sdkVersionName=%s&sdkVersionCode=%s&returnScene=0&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s");
                configMap.put("host_old_more", "https://engine.tuia.cn/index/activity?sdkVersionName=%s&sdkVersionCode=%s&returnScene=2&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s");
                configMap.put("host_comm", "https://activity.tuia.cn/native/nativeApi?sdkVersionName=%s&sdkVersionCode=%s&returnScene=0&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s&isEmbed=%s&isNewApi=1");
                configMap.put("host_more", "https://activity.tuia.cn/native/nativeApi?sdkVersionName=%s&sdkVersionCode=%s&returnScene=2&appKey=%s&adslotId=%s&userId=%s&device_id=%s&useLoading=%s&isEmbed=%s");
                break;
        }
    }

    public static String getConfigAppKey() {
        return configMap.get("app_key");
    }

    public static String getConfigAppSecret() {
        return configMap.get("app_secret");
    }

    public static String getConfigHost() {
        return configMap.get("host");
    }

    public static String getConfigHostUrl() {
        return configMap.get("host_url");
    }

    public static String getConfigHostKey() {
        return configMap.get("host_key");
    }

    public static String getConfigHostActivity() {
        return configMap.get("host_activity");
    }

    public static String getConfigHostOldComm() {
        return configMap.get("host_old_comm");
    }

    public static String getConfigHostOldMore() {
        return configMap.get("host_old_more");
    }

    public static String getConfigHostComm() {
        return configMap.get("host_comm");
    }

    public static String getConfigHostMore() {
        return configMap.get("host_more");
    }
}
