package com.mediamain.android.base.config;

/**
 * @author lzy
 */
public class FoxBaseConstants {

    /**
     * Android cache
     */
    public static final String KEY_TUIA_ANDROID_CACHE = "/storage/emulated/0/Android/data/";

    /**
     * applist
     */
    public static final String KEY_TUIA_SDK = "tuia_sdk";

    /**
     * app cache
     */
    public static final String KEY_TUIA_SDK_CACHE = "tm_sdk_cache";

    /**
     * app usage
     */
    public static final String KEY_TUIA_SDK_APP_USAGE = "tuia_sdk_usage";

    /**
     * app sensor
     */
    public static final String KEY_TUIA_SDK_APP_SENSOR = "tuia_sdk_app_sensor";


    /**
     * Crash info
     */
    public static final String KEY_TUIA_SDK_APP_CRASH = "tuia_sdk_app_crash:";

    /**
     * 引起崩溃类型：
     * 1 -> sdk引起
     * 2 -> oaid引起
     * 3 -> 其他异常
     */
    public static final String KEY_TUIA_SDK_CRASH_INFO_TYPE = "tuia_sdk_crash_info_type";

    /**
     * 开启try/catch错误上报开关
     */
    public static final String KEY_TUIA_SDK_ERROR_REPORT_SWITCH = "tuia_sdk_error_report_switch";

    /**
     * 异常上报周期 / h
     */
    public static final String KEY_TUIA_SDK_ERROR_REPORT_TIME_INTERVAL = "tuia_sdk_error_report_interval";

    /**
     * SDK 包名
     */
    public static final String KEY_TUIA_SDK_PACKAGE_NAME = "com.mediamain.android";

    /**
     * OAID 包名
     */
    public static final String KEY_TUIA_SDK_OAID_PACKAGE_NAME = "com.bun.";


    /**
     * OAID
     */
    public static final String KEY_TUIA_SDK_APP_OAID = "tuia_sdk_app_oaid";

    /**
     * 支持活动是否开启下载
     */
    public static final String KEY_TUIA_SDK_ISSUPPORTDOWNLOAD = "tuia_sdk_isSupportDownload";

    /**
     * IMEI缓存
     */
    public static final String KEY_TUIA_SDK_IMEI = "tuia_sdk_imei";

    /**
     * 配置参数
     */
    public static final String KEY_TUIA_SDK_CONFIG = "tuia_sdk_config";

    /**
     * 签名
     */
//    public static final String KEY_SECRET = BuildConfig.HOST_KEY;
    public static final String KEY_SECRET = AutoConfig.getConfigHostKey();

    /**
     * appkey
     */
    public static final String KEY_TUIA_APPKEY = "TUIA_APPKEY";
    /**
     * appsecret
     */
    public static final String KEY_TUIA_APPSECRET="TUIA_APPSECRET";
    /**
     * 代理appkey
     */
    public static final String KEY_PRO_APPKEY="PRO_APPKEY";
    /**
     * 代理appsecret
     */
    public static final String KEY_PRO_APPSECRET="PRO_APPSECRET";

    /**
     * 埋点-信息流广告-下载类
     * 曝光：dpm=AppId.66.101.6
     * access_log.sls_duiba_exposure_log
     */
    public static final String ANDROID_APK_EVENT_INFO_STREAM_EXPOSED = "AppId.66.101.6";

    /**
     * 埋点-信息流广告-下载类
     * 点击: dpm=AppId.66.101.6
     * access_log.sls_duiba_access_log
     */
    public static final String ANDROID_APK_EVENT_INFO_STREAM_CLICK = "AppId.66.101.6";


    /**
     * 埋点-弹窗曝光
     */
    public static final String ANDROID_APK_EVENT_POP_EXPOSED = "AppId.66.101.0";


    /**
     * 埋点-弹窗关闭按钮点击的pv/uv
     */
    public static final String ANDROID_APK_EVENT_POP_CLOSE_CLICK = "AppId.66.101.3";

    /**
     * 埋点 - 开始下载的曝光pv/uv
     */
    public static final String ANDROID_APK_EVENT_DOWNLOAD_START_EXPOSURE = "AppId.66.101.1";


    /**
     *  埋点 - 下载完成的曝光PV/UV
     */
    public static final String ANDROID_APK_EVENT_DOWNLOAD_END_EXPOSURE = "AppId.66.101.2";


    /**
     * 埋点-.apk的后续转化行为（立即安装）
     * 立即安装按钮曝光pv/uv
     */
    public static final String ANDROID_APK_EVENT_INSTALL_EXPOSURE = "AppId.66.101.4";

    /**
     * 埋点-.apk的后续转化行为（立即安装）
     * 立即安装按钮的点击pv/uv
     */
    public static final String ANDROID_APK_EVENT_INSTALL_CLICK = "AppId.66.101.4";

    /**
     * 埋点-.apk的后续转化行为（立即打开）
     * 打开领取奖励按钮的曝光pv/uv
     * 曝光：dpm=AppId.66.101.5
     * access_log.sls_duiba_exposure_log
     */
    public static final String ANDROID_APK_EVENT_OPEN_EXPOSURE = "AppId.66.101.5";

    /**
     * 埋点-apk的后续转化行为（立即打开）
     * 打开领取奖励按钮的点击pv/uv
     *
     * 点击: dpm=AppId.66.101.5
     * access_log.sls_duiba_access_log
     */
    public static final String ANDROID_APK_EVENT_OPEN_CLICK = "AppId.66.101.5";


    /**
     * 埋点-下载中断
     * 曝光：dpm=AppId.66.101.7
     *
     * access_log.sls_duiba_exposure_log
     */
    public static final String ANDROID_APK_EVENT_DOWNLOAD_ERROR_EXPOSURE = "AppId.66.101.7";


    /**
     * 下载器下载场景
     * 1-信息流直投下载
     */
    public static final int ANDROID_APK_EVENT_APK_DOWN_SCENES_1 = 1;
    /**
     * 下载器下载场景
     * 2-券弹层原生下载
     */
    public static final int ANDROID_APK_EVENT_APK_DOWN_SCENES_2 = 2;
    /**
     * 下载器下载场景
     * 3-落地页弹窗下载
     */
    public static final int ANDROID_APK_EVENT_APK_DOWN_SCENES_3 = 3;
    /**
     * 下载器下载场景
     * 4-原生插屏下载
     */
    public static final int ANDROID_APK_EVENT_APK_DOWN_SCENES_4 = 4;

    /**
     * 曝光上报
     */
    public static final int OPERATETYPE_EXPOSED = 0;
    /**
     * 点击上报
     */
    public static final int OPERATETYPE_CLICK = 1;


    /**
     * 打开
     */
    public static final int SUB_TYPE_OPEN = 2;

    /**
     * 自动检测工具类型 1-活动参与
     */
    public static final int KEY_CHECK_ACTIVITY = 1;

    /**
     * 自动检测工具类型 2-下载开始
     */
    public static final int KEY_CHECK_DOWNLOAD_START = 2;

    /**
     * 自动检测工具类型 3-下载成功
     */
    public static final int KEY_CHECK_DOWNLOAD_SUCCESSED = 3;

    /**
     * 自动检测工具类型 4-开始安装
     */
    public static final int KEY_CHECK_INSTALL_START = 4;

    /**
     * 自动检测工具类型 5-安装成功
     */
    public static final int KEY_CHECK_INSTALL_SUCCESSED = 5;

    /**
     * 自动检测工具类型 6-打开成功
     */
    public static final int KEY_CHECK_OPEN_SUCCESS = 6;

    /**
     * 测试包名
     */
    public static final String KEY_CHECK_PACKAGE_NEME="com.mediamain.android.demo";

    /**
     * 悬浮升级入口url
     */
    public static final String KEY_FLOATING_WEB_AD_URL = "floating_web_ad_url";

    public static final String ERROR_CODE_1001 = "1001";
    public static final String ERROR_CODE_1002 = "1002";
    public static final String ERROR_CODE_1003 = "1003";
    public static final String ERROR_CODE_1004 = "1004";
    public static final String ERROR_CODE_1005 = "1005";
    public static final String ERROR_CODE_1006 = "1006";
    public static final String ERROR_CODE_1007 = "1007";
}
