package com.mediamain.android.base.config;

/**
 * author: likaixuan
 * date: 2020/10/29
 * desc:
 */
public enum FoxSDKError {

    SDK_TYPE_LIMIT(100, "广告投放限制"),
    INVALID_PARAM(101, "请求参数错误"),

    INVALID_SERVING_DATA(200, "接口返回错误"),
    INVALID_IMAGE_URL(201, "素材url为空"),
    INVALID_ACTIVITY_URL(202, "活动url为空"),
    INVALID_CUSTOM_IMAGE_URI(203, "使用本地素材的路径有误"),
    FLOATING_EMPTY_URL(204, "悬浮升级入口url为空"),
    FLOATING_EMPTY_HOST(205, "悬浮升级宿主为空"),

    REQUEST_SERVING_ERROR(300, "请求接口错误"),
    LOAD_AD_ERROR(301, "加载广告失败"),

    UNKNOWN(400, "未知错误"),
    UNINITIATED(401, "未进行初始化，请先对SDK进行初始化"),

    NETWORK_ERROR(500, "网络错误，请检查网络！");

    private int code;
    private String message;

    FoxSDKError(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
