package com.mediamain.android.base.data;

import java.io.Serializable;

public class FoxBaseNewDownloadBean implements Serializable {

    private String url;
    private String packageName;
    private String applicationName;
    private String appIconUri;
    private String slotId;
    private String tuiaId;
    private String title;
    private String desc;
    private String tmId;
    private int styleControl = 1;
    private FoxBaseSdkDsmLogRspBean sdkDsmLogRsp;

    public FoxBaseNewDownloadBean(){}

    public FoxBaseNewDownloadBean(String url,
                                  String slotId,
                                  String tuiaId,
                                  FoxBaseAdvertSdkRspBean advertSdkRspBean, FoxBaseSdkDsmLogRspBean sdkDsmLogRspBean) {
        this.url = url;
        this.slotId = slotId;
        this.tuiaId = tuiaId;
        if (advertSdkRspBean != null) {
            this.packageName = advertSdkRspBean.getPackageName();
            this.applicationName = advertSdkRspBean.getApplicationName();
            this.appIconUri = advertSdkRspBean.getAppIconUri();
            this.styleControl = advertSdkRspBean.getStyleControl();
            this.title = advertSdkRspBean.getTitle();
            this.desc = advertSdkRspBean.getDesc();
        }
        if (sdkDsmLogRspBean!= null) {
            this.tuiaId = sdkDsmLogRspBean.getOrderId();
            this.slotId = sdkDsmLogRspBean.getSlotId();
            this.sdkDsmLogRsp = sdkDsmLogRspBean;
        }
    }

    public String getTuiaId() {
        return tuiaId;
    }

    public void setTuiaId(String tuiaId) {
        this.tuiaId = tuiaId;
    }

    public FoxBaseSdkDsmLogRspBean getSdkDsmLogRspBean() {
        return sdkDsmLogRsp;
    }

    public void setSdkDsmLogRspBean(FoxBaseSdkDsmLogRspBean sdkDsmLogRspBean) {
        this.sdkDsmLogRsp = sdkDsmLogRspBean;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }


    public String getSlotId() {
        return slotId;
    }

    public void setSlotId(String slotId) {
        this.slotId = slotId;
    }

    public int getStyleControl() {
        return styleControl;
    }

    public void setStyleControl(int styleControl) {
        this.styleControl = styleControl;
    }


    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getApplicationName() {
        return applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getAppIconUri() {
        return appIconUri;
    }

    public void setAppIconUri(String appIconUri) {
        this.appIconUri = appIconUri;
    }

    public String getTmId() {
        return tmId;
    }

    public void setTmId(String tmId) {
        this.tmId = tmId;
    }
}
