package com.mediamain.android.base.download;

/**
 * <p> File description: <p>
 * <p> Creator: Adroll   <p>
 * <p> Created date: 11/30/20 <p>
 * * * * * * * * * * * * * * * * * * * * * *
 * Thinking is more important than coding *
 * * * * * * * * * * * * * * * * * * * * * *
 */
public interface DownloadMethods {

    /**
     * 默认下载方式（通知栏显示下载进度）
     */
    void defaultDownload();

    /**
     * 静默下载
     */
    void backgroundDownload();

    /**
     * 暂停下载
     */
    void cancel();

    /**
     * 获取下载进度
     */
    float getProgress();

    /**
     * 安装应用
     * @param isRail : 是否通知栏
     */
    void installApp(int isRail);

    /**
     * 获取当前应用下载状态
     */
    int getDownloadStatus();

    /**
     * 设置是否显示通知栏
     */
    void setShowNotification(boolean showNotification, String icon);

    /**
     * 获取是否显示通知栏状态
     */
    boolean isShowNotification();

    /**
     * 打开应用
     * @param isRail : 是否通知栏
     */
    void openApp(int isRail);

    /**
     * 是否暂停任务
     */
    boolean isCancel();

    /**
     * 设置当前中断任务的进度
     */
    void setCurrentProgress(float progress);

    /**
     * 获取包名
     */
    String getPackageName();

    /**
     * 获取图标地址
     */
    String getIcon();

    /**
     * 获取tuia id
     */
    String getTuiaId();
}
