package com.mediamain.android.base.download;

import android.content.Intent;
import android.text.TextUtils;

import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.OkDownload;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxBaseConstants;
import com.mediamain.android.base.util.FoxBaseAppUtil;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseEncryptUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.FoxBaseThreadUtils;
import com.mediamain.android.base.util.FoxBaseUtils;

import java.io.File;
import java.util.concurrent.TimeUnit;

import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_DOWNLOAD_START;
import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_DOWNLOAD_SUCCESSED;
import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_OPEN_SUCCESS;

/**
 * <p> File description: <p>
 * <p> Creator: Adroll   <p>
 * <p> Created date: 11/27/20 <p>
 * * * * * * * * * * * * * * * * * * * * * *
 * Thinking is more important than coding *
 * * * * * * * * * * * * * * * * * * * * * *
 */
abstract class IntegrateH5Download implements DownloadMethods {

    private volatile boolean isTaskCancel;

    private float progress;

    private boolean isShowNotification;

    private String url;
    private String packageName;
    private String icon;
    private String tuiaId;

    /**
     * 暂停任务保存时间
     */
    private final long STOP_TASK_CACHE_DURATION = 24 * 60 * 60 * 1000;

    private DownloadTask task;

    private final DownloadCallback downloadCallback;

    public IntegrateH5Download(final String url, final String packageName, final String icon, final String tuiaId){
        this.url = url;
        this.packageName = packageName;
        this.icon = icon;
        this.tuiaId = tuiaId;

        downloadCallback = new DownloadCallback() {
            @Override
            public void onTaskStart() {
                if (progress > 0){
                    return;
                }

                // 下载开始通知栏埋点
                FoxBaseMaidianUtil.build(157)
                        .set("businessType", Integer.toString(KEY_CHECK_DOWNLOAD_START))
                        .set("package_name", packageName)
                        .set("url_package", url)
                        .set("tuia_id", tuiaId)
                        .set("is_rail", isShowNotification ? "1" : "-1")
                        .postCheck();
            }

            @Override
            public void updateProgress(float progress) {
                IntegrateH5Download.this.progress = progress;

                //  如果没有设置则不显示通知栏
                if (!isShowNotification){
                    return;
                }

                DownloadController.getInstance().showNotification(url, packageName, icon,
                        (int) progress, isTaskCancel, tuiaId, true);
            }

            @Override
            public void onTaskEnd() {
                if (progress < 100f){
                    return;
                }

                downloadCompleted(url);
                FoxBaseSPUtils.getInstance().remove(url);

                FoxBaseMaidianUtil.build(157)
                        .set("businessType", "" + KEY_CHECK_DOWNLOAD_SUCCESSED)
                        .set("package_name", packageName)
                        .set("url_package", url)
                        .set("tuia_id", tuiaId)
                        .set("is_rail", isShowNotification ? "1" : "-1")
                        .postCheck();

                if (isShowNotification){
                    installApp(0);
                }
            }

            @Override
            public boolean cancelTask() {
                return isTaskCancel;
            }
        };
    }

    @Override
    public void defaultDownload(){
        if (TextUtils.isEmpty(url)){
            return;
        }

        isShowNotification = true;
        isTaskCancel = false;

        if (task != null){
            DownloadController.getInstance().taskContinue(task, task.getListener(), 1);
            return;
        }

        localStorageTask();

        task = DownloadController.getInstance().download(url,
                FoxBaseEncryptUtils.encryptMD5ToString(url) + "tm.apk", icon,
                false, 10, downloadCallback);
        // 将任务开始的时间戳和OkDownload里的任务id保存
        FoxBaseSPUtils.getInstance().setString(url, System.currentTimeMillis() + "," + task.getId());
    }

    @Override
    public void backgroundDownload(){
        if (TextUtils.isEmpty(url)){
            return;
        }

        isShowNotification = false;
        isTaskCancel = false;

        if (task != null){
            DownloadController.getInstance().taskContinue(task, task.getListener(), 1);
            return;
        }

        localStorageTask();

        task = DownloadController.getInstance().download(url,
                FoxBaseEncryptUtils.encryptMD5ToString(url) + "tm.apk", icon,
                false, 10, downloadCallback);
        // 将任务开始的时间戳和OkDownload里的任务id保存
        FoxBaseSPUtils.getInstance().setString(url, System.currentTimeMillis() + "," + task.getId());
    }

    @Override
    public void cancel(){
        isTaskCancel = true;
        // 更新状态栏信息
        if (isShowNotification){
            DownloadController.getInstance().showNotification(url, packageName, icon, (int) progress,
                    true, tuiaId, true);
        }
    }

    @Override
    public float getProgress(){
        return progress;
    }

    @Override
    public void installApp(int isRail){
        if (FoxBaseUtils.getApp() == null){
            return;
        }

        FoxBaseMaidianUtil.build(157)
                .set("businessType", "" + FoxBaseConstants.KEY_CHECK_INSTALL_START)
                .set("sub_type", Constants.SUB_TYPE_INSTALL)
                .set("package_name", packageName)
                .set("url_package", url)
                .set("tuia_id", tuiaId)
                .set("is_rail", "" + isRail)
                .postCheck();

        // 避免偶现通知栏信息更新失败，采用延时
        FoxBaseThreadUtils.executeBySingleWithDelay(new FoxBaseThreadUtils.Task<Float>() {

            @Override
            public Float doInBackground() throws Throwable {
                DownloadController.getInstance().showNotification(url, packageName, icon, 100, false, tuiaId, true);
                return null;
            }

            @Override
            public void onSuccess(Float result) {

            }

            @Override
            public void onCancel() {

            }

            @Override
            public void onFail(Throwable t) {

            }
        }, 500, TimeUnit.MILLISECONDS);
        // 引导安装
        final File file = FoxBaseCommonUtils.checkFileExit(Constants.CACHE_NAME,
                FoxBaseEncryptUtils.encryptMD5ToString(url) + "tm.apk");
        if (file != null && file.exists()){
            FoxBaseAppUtil.openFile(FoxBaseUtils.getApp(), file);
        }
    }

    @Override
    public int getDownloadStatus(){
        DownloadController.DownloadStatus status = DownloadController.getInstance().getStatus(url, packageName, isTaskCancel);
        switch (status){
            case UN_DOWNLOAD:
                return 1;
            case DOWNLOADING:
                return 2;
            case UN_INSTALL:
                return 3;
            case INSTALLED:
                return 4;
            case STOP_DOWNLOAD:
                return 5;
            default:
                return -1;
        }
    }

    @Override
    public void setShowNotification(boolean showNotification, String icon) {
        isShowNotification = showNotification;

        if (!isShowNotification){
            DownloadController.getInstance().showNotification(url, packageName, icon, (int) progress,
                    isTaskCancel, tuiaId, false);
        }
    }

    @Override
    public boolean isShowNotification() {
        return isShowNotification;
    }

    @Override
    public void openApp(int isRail) {
        if (FoxBaseUtils.getApp() == null){
            return;
        }

        FoxBaseMaidianUtil.build(157)
                .set("sub_type", Constants.SUB_TYPE_OPEN)
                .set("businessType", "" + KEY_CHECK_OPEN_SUCCESS)
                .set("package_name", packageName)
                .set("url_package", url)
                .set("tuia_id", tuiaId)
                .set("is_rail", "" + isRail)
                .postCheck();

        try {
            Intent intent = FoxBaseUtils.getApp().getPackageManager().getLaunchIntentForPackage(packageName);
            FoxBaseUtils.getApp().startActivity(intent);
        }catch (Exception e){

        }
    }

    @Override
    public boolean isCancel() {
        return isTaskCancel;
    }

    @Override
    public String getPackageName() {
        return packageName;
    }

    @Override
    public String getIcon() {
        return icon;
    }

    @Override
    public String getTuiaId() {
        return tuiaId;
    }

    @Override
    public void setCurrentProgress(float progress) {
        this.progress = progress;
    }

    /**
     * 对比当前缓存下载任务是否过期
     */
    private void localStorageTask() {
        if (!FoxBaseSPUtils.getInstance().containsKey(url)){
            return;
        }

        String temp = FoxBaseSPUtils.getInstance().getString(url, "");
        if (TextUtils.isEmpty(temp)){
            return;
        }

        String[] tempArray = temp.split(",");
        if (tempArray == null || tempArray.length <= 1){
            return;
        }

        try {
            long lastTime = Long.parseLong(tempArray[0]);
            if (System.currentTimeMillis() - lastTime > STOP_TASK_CACHE_DURATION){
                OkDownload.with().breakpointStore().remove(Integer.parseInt(tempArray[1]));
                FoxBaseSPUtils.getInstance().remove(url);
            }
        }catch (Exception e){

        }
    }

    /**
     * 下载完成后操作
     * @param url：下载链接
     */
    public abstract void downloadCompleted(String url);
}
