package com.mediamain.android.base.download;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;

import com.liulishuo.okdownload.OkDownload;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.download.broadcast.DownloadBroadCast;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseEncryptUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;

import java.io.File;

/**
 * <p> File description: <p>
 * <p> Creator: Adroll   <p>
 * <p> Created date: 11/30/20 <p>
 * * * * * * * * * * * * * * * * * * * * * *
 * Thinking is more important than coding *
 * * * * * * * * * * * * * * * * * * * * * *
 */
public class IntegrateH5DownloadManager {

    private static volatile IntegrateH5DownloadManager INSTANCE;

    private static Handler handler = new Handler(Looper.getMainLooper());

    private String url;
    private String completeUrl;
    private String icon;

    private DownloadMethods downloadTask;
    private DownloadMethods completedDownloadTask;

    private IntegrateH5DownloadManager(){}

    public static IntegrateH5DownloadManager getInstance() {
        if (INSTANCE == null){
            synchronized (IntegrateH5DownloadManager.class){
                if (INSTANCE == null){
                    INSTANCE = new IntegrateH5DownloadManager();
                }
            }
        }

        return INSTANCE;
    }

    private DownloadMethods preCheckTask(String url, String packageName){
        // 对传入的下载链接和包名进行非空判断
        if (TextUtils.isEmpty(url) || TextUtils.isEmpty(packageName)){
            return null;
        }

        // 判断是否存在正在下载的任务
        if (TextUtils.isEmpty(this.url)){
            return null;
        }

        // 根据下载链接判断是否相同下载任务
        if (this.url.equals(url)){
            return downloadTask;
        }

        return null;
    }

    private void dependencyDownloadBroadcast(String url, String packageName, String icon, String tuiaId){
        DownloadBroadCast downloadBroadCast = FoxBaseCommonUtils.registerDownloadBroadCast();
        if(null != downloadBroadCast) {
            downloadBroadCast.setBean(url, packageName, icon, tuiaId);
        }
    }

    private DownloadMethods createDownloadMethods(String url, String packageName, final String icon, String tuiaId){
        final DownloadMethods downloadMethods = new IntegrateH5Download(url, packageName, icon, tuiaId) {
            @Override
            public void downloadCompleted(String url) {
                // 下载完成后将本地变量置空
                completedDownloadTask = downloadTask;
                IntegrateH5DownloadManager.this.completeUrl = IntegrateH5DownloadManager.this.url;
                downloadTask = null;
                IntegrateH5DownloadManager.this.icon = "";
                IntegrateH5DownloadManager.this.url = "";
                DownloadController.getInstance().removeBitmapFuture(icon);
            }
        };

        if (downloadTask != null){
            // 取消正在进行的下载任务
            downloadTask.cancel();

            String temp = FoxBaseSPUtils.getInstance().getString(this.url, "");
            if (!TextUtils.isEmpty(temp)){
                String[] tempArray = temp.split(",");
                if (tempArray != null && tempArray.length > 1){
                    // 移除OkDownload保存的下载缓存
                    OkDownload.with().breakpointStore().remove(Integer.parseInt(tempArray[1]));

                    // 移除未完成的下载文件
                    File file = FoxBaseCommonUtils.checkFileExit(Constants.CACHE_NAME, FoxBaseEncryptUtils.encryptMD5ToString(this.url) + "tm.apk");
                    if (file != null){
                        file.delete();
                    }
                    // 移除SP保存的任务信息
                    FoxBaseSPUtils.getInstance().remove(this.url);
                }
            }
        }

        // 将新创建的下载任务保存
        this.url = url;
        this.icon = icon;
        downloadTask = downloadMethods;

        return downloadMethods;
    }

    public void defaultDownload(final String url, String packageName, String icon,String tuiaId){
        if (TextUtils.isEmpty(url)){
            return;
        }

        dependencyDownloadBroadcast(url, packageName, icon, tuiaId);

        try {
            DownloadMethods downloadMethods = preCheckTask(url, packageName);
            if (downloadMethods == null){
                downloadMethods = createDownloadMethods(url, packageName, icon, tuiaId);
            }
            downloadMethods.setShowNotification(true, icon);

            DownloadController.DownloadStatus status = DownloadController.getInstance().getStatus(url, packageName, downloadMethods.isCancel());
            if (status == DownloadController.DownloadStatus.UN_DOWNLOAD || status == DownloadController.DownloadStatus.STOP_DOWNLOAD){
                final DownloadMethods finalDownloadMethods = downloadMethods;
                // H5调用该方法无效，故采用延迟启动
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        finalDownloadMethods.defaultDownload();
                    }
                }, 1000);
            }
        }catch (Exception e){

        }
    }

    public void backgroundDownload(final String url, String packageName,String tuiaId){
        if (TextUtils.isEmpty(url)){
            return;
        }

        dependencyDownloadBroadcast(url, packageName, "", tuiaId);

        try {
            DownloadMethods downloadMethods = preCheckTask(url, packageName);
            if (downloadMethods == null){
                downloadMethods = createDownloadMethods(url, packageName, "", tuiaId);
            }

            DownloadController.DownloadStatus status = DownloadController.getInstance().getStatus(url, packageName, downloadMethods.isCancel());
            if (status == DownloadController.DownloadStatus.UN_DOWNLOAD || status == DownloadController.DownloadStatus.STOP_DOWNLOAD){
                final DownloadMethods finalDownloadMethods = downloadMethods;
                // H5调用该方法无效，故采用延迟启动
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        finalDownloadMethods.backgroundDownload();
                    }
                }, 1000);
            }
        }catch (Exception e){

        }
    }

    public void cancel(String url, String packageName,String tuiaId){
        DownloadMethods downloadMethods = preCheckTask(url, packageName);
        if (downloadMethods == null){
            return;
        }

        downloadMethods.cancel();
    }

    public float getProgress(String url, String packageName,String tuiaId){
        DownloadMethods downloadMethods = preCheckTask(url, packageName);
        if (downloadMethods == null){
            return 0;
        }

        return downloadMethods.getProgress();
    }

    public void installApp(String url, String packageName, String icon, int isRail, String tuiaId){
        dependencyDownloadBroadcast(url, packageName, icon, tuiaId);

        try {
            // 该任务没下载完成
            if (getDownloadStatus(url, packageName, tuiaId) != 3){
                return;
            }

            DownloadMethods downloadMethods = preCheckTask(url, packageName);
            if (downloadMethods == null){
                // 如果为空，说明是重新打开app，本地变量已经被清空无需设置下载完成操作
                downloadMethods = new IntegrateH5Download(url, packageName, icon, tuiaId) {
                    @Override
                    public void downloadCompleted(String url) {

                    }
                };
            }

            downloadMethods.installApp(isRail);
        }catch (Exception e){

        }
    }

    public int getDownloadStatus(String url, String packageName,String tuiaId){
        DownloadController.DownloadStatus status;

        DownloadMethods downloadMethods = preCheckTask(url, packageName);
        if ((downloadMethods == null || downloadMethods.isCancel()) && FoxBaseSPUtils.getInstance().containsKey(url)){
            status = DownloadController.getInstance().getStatus(url, packageName, true);
        }else {
            status = DownloadController.getInstance().getStatus(url, packageName, false);
        }

        switch (status){
            case UN_DOWNLOAD:
                return 1;
            case DOWNLOADING:
                return 2;
            case UN_INSTALL:
                return 3;
            case INSTALLED:
                return 4;
            case STOP_DOWNLOAD:
                return 5;
            default:
                return -1;
        }
    }

    public void setShowNotification(String url, String packageName, String icon, boolean showNotification,String tuiaId){
        DownloadMethods downloadMethods = preCheckTask(url, packageName);
        if (downloadMethods == null){
            return;
        }

        this.icon = icon;
        downloadMethods.setShowNotification(showNotification, icon);
    }

    public void openApp(String url, String packageName, String icon, int isRail, String tuiaId){
        dependencyDownloadBroadcast(url, packageName, icon, tuiaId);

        DownloadMethods downloadMethods = new IntegrateH5Download(url, packageName, icon, tuiaId) {
            @Override
            public void downloadCompleted(String url) {

            }
        };

        downloadMethods.openApp(isRail);
    }

    public void webviewDestroy(){
        try {
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    if (downloadTask == null){
                        return;
                    }

                    // 暂停下载退出WebView重新显示通知栏
                    if (downloadTask.isCancel()){
                        DownloadController.getInstance().showNotification(url,
                                downloadTask.getPackageName(),
                                downloadTask.getIcon(),
                                (int) downloadTask.getProgress(),
                                downloadTask.isCancel(),
                                downloadTask.getTuiaId(), true);
                    }
                    // 正在下载退出WebView继续下载静默任务
                    else if (TextUtils.isEmpty(icon)){
                        downloadTask.backgroundDownload();
                    }
                    // 正在下载退出WebView继续下载普通任务
                    else if (!TextUtils.isEmpty(url)){
                        downloadTask.defaultDownload();
                    }
                }
            }, 1000);

            // 该任务正在下载
            if (!TextUtils.isEmpty(url)){
                return;
            }

            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    if (completedDownloadTask == null){
                        return;
                    }

                    // 安装完成退出WebView重新显示通知栏
                    if (DownloadController.getInstance().getStatus(completeUrl, completedDownloadTask.getPackageName(),
                            false) == DownloadController.DownloadStatus.INSTALLED){
                        DownloadController.getInstance().showNotification(completeUrl,
                                completedDownloadTask.getPackageName(),
                                completedDownloadTask.getIcon(),
                                200,
                                completedDownloadTask.isCancel(),
                                completedDownloadTask.getTuiaId(), true);
                    }
                    // 完成下载退出WebView，且属于普通下载，重新显示通知栏
                    else if (completedDownloadTask != null && completedDownloadTask.getProgress() == 100
                            && completedDownloadTask.isShowNotification()){
                        DownloadController.getInstance().showNotification(completeUrl,
                                completedDownloadTask.getPackageName(),
                                completedDownloadTask.getIcon(),
                                (int) completedDownloadTask.getProgress(),
                                completedDownloadTask.isCancel(),
                                completedDownloadTask.getTuiaId(), true);
                    }
                }
            }, 1000);
        }catch (Exception e){

        }
    }
}
