package com.mediamain.android.base.download.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.mediamain.android.base.download.DownloadController;
import com.mediamain.android.base.data.DownloadTaskBean;
import com.mediamain.android.base.util.FoxBaseAppUtil;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.FoxBaseUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.util.HashMap;
import java.util.Set;

import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_INSTALL_SUCCESSED;

/**
 * <p> File description: <p>
 * <p> Creator: Adroll   <p>
 * <p> Created date: 12/2/20 <p>
 * * * * * * * * * * * * * * * * * * * * * *
 * Thinking is more important than coding *
 * * * * * * * * * * * * * * * * * * * * * *
 */
public class DownloadBroadCast extends BroadcastReceiver {

    private HashMap<String, DownloadTaskBean> beanMap = null;
    private String mPackageName = "";
    private String mUrl = "";

    public void setBean(String url, String packageName, String icon, String tuiaId) {
        setData(packageName,url);
        if (beanMap == null){
            beanMap = new HashMap<>();
        }
        if (beanMap.containsKey(packageName)) {
            return;
        }

        DownloadTaskBean bean = new DownloadTaskBean(url, packageName, icon, tuiaId);
        beanMap.put(packageName, bean);
    }

    public void setData(String packageName, String url){
        beanMap = null;
        mPackageName = packageName;
        mUrl = url;
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        try {
            if (intent.getAction().equals(Intent.ACTION_PACKAGE_ADDED)){
                if(beanMap != null) {
                    String p = filterPackageName();
                    if (!TextUtils.isEmpty(p)){
                        DownloadController.getInstance().showNotification(beanMap.get(p).getUrl(), p, beanMap.get(p).getIcon(),
                                200, true, beanMap.get(p).getTuiaId(), true);
                        sendLimitBroadcast(beanMap.get(p).getUrl(), p);
                    }
                    beanMap.remove(p);
                }

                //安装成功的埋点
                String data = intent.getDataString();
                if(!FoxBaseCommonUtils.isEmpty(data) && data.contains(mPackageName)) {
                    FoxBaseMaidianUtil.build(157)
                            .set("businessType", Integer.toString(KEY_CHECK_INSTALL_SUCCESSED))
                            .set("package_name", mPackageName)
                            .set("url_package", mUrl)
                            .postCheck();
                }
            }
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }


    }

    private String filterPackageName(){
        Set<String> nameList = beanMap.keySet();
        for (String s : nameList) {
            if (FoxBaseAppUtil.isAppInstall(FoxBaseUtils.getApp(), s)){
                return s;
            }
        }

        return null;
    }

    private void sendLimitBroadcast(String url, String packageName){
        Intent intent = new Intent();
        intent.putExtra("url", url);
        intent.putExtra("packageName", packageName);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setAction("com.mediamain.installed");
        FoxBaseUtils.getApp().sendBroadcast(intent);
    }
}
