package com.mediamain.android.base.download.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.mediamain.android.base.download.IntegrateH5DownloadManager;

/**
 * <p> File description: <p>
 * <p> Creator: Adroll   <p>
 * <p> Created date: 12/2/20 <p>
 * * * * * * * * * * * * * * * * * * * * * *
 * Thinking is more important than coding *
 * * * * * * * * * * * * * * * * * * * * * *
 */
public class NotificationBroadCast extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        String url = intent.getStringExtra("url");
        String packageName = intent.getStringExtra("packageName");
        String icon = intent.getStringExtra("icon");
        String tuiaId = intent.getStringExtra("tuiaId");
        int status = IntegrateH5DownloadManager.getInstance().getDownloadStatus(url, packageName, tuiaId);
        // 下载中
        if (status == 2){
//            IntegrateH5DownloadManager.getInstance().cancel(url, packageName);
        }
        // 暂停下载
        else if (status == 5){
//            IntegrateH5DownloadManager.getInstance().defaultDownload(url, packageName, icon, null);
        }
        // 已下载未安装
        else if (status == 3){
            IntegrateH5DownloadManager.getInstance().installApp(url, packageName, icon, 1, tuiaId);
        }
        // 已安装
        else if (status == 4){
            IntegrateH5DownloadManager.getInstance().openApp(url, packageName, icon, 1, tuiaId);
        }
    }
}
