package com.mediamain.android.base.util;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.ScaleAnimation;
import android.widget.RelativeLayout;

import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.view.imageloader.FoxImageView;

import static android.view.View.VISIBLE;

public class FoxBaseAnimationUtil {

public static final Long ANIMA_TIME = 300L;

    /**
     * 缩放动画 与 平移动画
     *
     * @param view
     * @param fromScale
     * @param toScale
     * @param fromX
     * @param toX
     * @param fromY
     * @param toY
     * @param listener
     */
    public static void startZoomAnim(View view,
                                     // 缩放
                                     float fromScale, float toScale,
                                     // 平移
                                     float fromX, float toX, float fromY, float toY,
                                     // 动画
                                     Animator.AnimatorListener listener
    ) {

        if (view == null) {
            return;
        }
        if (view.getAnimation() != null) {
            view.getAnimation().cancel();
            view.clearAnimation();
            return;
        }

        AnimatorSet localAnimatorSet = new AnimatorSet();
        // ############## scaleX ###############
        float[] scaleX = new float[2];
        scaleX[0] = fromScale;
        scaleX[1] = toScale;
        ObjectAnimator scaleXAnima = ObjectAnimator.ofFloat(view,
                "scaleX", scaleX);
        scaleXAnima.setDuration(ANIMA_TIME);
        scaleXAnima.setInterpolator(new DecelerateInterpolator());
        // ############## scaleY ###############
        float[] scaleY = new float[2];
        scaleY[0] = fromScale;
        scaleY[1] = toScale;
        ObjectAnimator scaleYAnima = ObjectAnimator.ofFloat(view,
                "scaleY", scaleY);
        scaleYAnima.setDuration(ANIMA_TIME);
        scaleYAnima.setInterpolator(new DecelerateInterpolator());
        // #############translationX ##########
        float[] translationX = new float[2];
        translationX[0] = fromX;
        translationX[1] = toX;
        ObjectAnimator translationXAnima = ObjectAnimator.ofFloat(view,
                "translationX", translationX);
        translationXAnima.setDuration(ANIMA_TIME);
        translationXAnima.setInterpolator(new DecelerateInterpolator());
        // ###############translationY##################
        float[] translationY = new float[2];
        translationY[0] = fromY;
        translationY[1] = toY;
        ObjectAnimator translationYAnima = ObjectAnimator.ofFloat(view,
                "translationY", translationY);
        translationYAnima.setDuration(ANIMA_TIME);
        translationYAnima.setInterpolator(new DecelerateInterpolator());

        //
        Animator[] arrayOfAnimator = new Animator[4];
        arrayOfAnimator[0] = scaleXAnima;
        arrayOfAnimator[1] = scaleYAnima;
        arrayOfAnimator[2] = translationXAnima;
        arrayOfAnimator[3] = translationYAnima;
        localAnimatorSet.playTogether(arrayOfAnimator);
        if (listener != null) {
            localAnimatorSet.addListener(listener);
        }
        //
        localAnimatorSet.start();
    }

    /**
     * 开启Alpha 动画
     *
     * @param view
     * @param fromAlpha
     * @param toAlpha
     */
    public static void startAlphaAnima(View view,
                                       float fromAlpha, float toAlpha) {
        if (view == null) {
            return;
        }
        if (view.getAnimation() != null) {
            view.getAnimation().cancel();
            view.clearAnimation();
            return;
        }
        //-------Alpaha--------
        AnimatorSet set = new AnimatorSet();
        set.play(ObjectAnimator.ofFloat(view, "alpha", fromAlpha, toAlpha));
        set.setDuration(ANIMA_TIME);
        set.setInterpolator(new DecelerateInterpolator());
        set.start();

    }

    /**
     * 清理目标View的动画
     * 
     * @param paramView
     */
    public static void clearAnimation(View paramView) {
        try {
            if (null != paramView) {
                if (null != paramView.getAnimation()) {
                    paramView.getAnimation().cancel();
                }
                paramView.clearAnimation();
            }

            if(null != localAnimatorSet){
                localAnimatorSet.removeAllListeners();
            }
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

    /**
     * 旋转动画
     * 
     * @param paramView
     * @param paramInt
     *            时间
     */
    public static void startRotateAnimation(View paramView, int paramInt) {
        float[] arrayOfFloat = new float[2];
        arrayOfFloat[0] = 0.0F;
        arrayOfFloat[1] = 360.0F;
        ObjectAnimator localObjectAnimator = ObjectAnimator.ofFloat(paramView,
                "rotation", arrayOfFloat);
        localObjectAnimator.setDuration(paramInt);
        localObjectAnimator.setInterpolator(null);
        localObjectAnimator.setRepeatCount(-1);
        localObjectAnimator.start();
    }

    /**
     * 放大动画
     * 
     * @param paramView
     *            目标View
     * @param paramFloat
     *            放大的比例
     * @param paramAnimatorListener
     * @return
     */
    public static AnimatorSet startScaleToBigAnimation(View paramView,
            float paramFloat, Animator.AnimatorListener paramAnimatorListener) {
        if (paramView.getAnimation() != null)
            paramView.getAnimation().cancel();
        paramView.clearAnimation();
        AnimatorSet localAnimatorSet = new AnimatorSet();
        float[] arrayOfFloat1 = new float[2];
        arrayOfFloat1[0] = 1.0F;
        arrayOfFloat1[1] = paramFloat;
        ObjectAnimator localObjectAnimator1 = ObjectAnimator.ofFloat(paramView,
                "scaleY", arrayOfFloat1);
        localObjectAnimator1.setDuration(240L);
        localObjectAnimator1.setInterpolator(new DecelerateInterpolator());
        float[] arrayOfFloat2 = new float[2];
        arrayOfFloat2[0] = 1.0F;
        arrayOfFloat2[1] = paramFloat;
        ObjectAnimator localObjectAnimator2 = ObjectAnimator.ofFloat(paramView,
                "scaleX", arrayOfFloat2);
        localObjectAnimator2.setDuration(240L);
        localObjectAnimator2.setInterpolator(new DecelerateInterpolator());
        Animator[] arrayOfAnimator = new Animator[2];
        arrayOfAnimator[0] = localObjectAnimator1;
        arrayOfAnimator[1] = localObjectAnimator2;
        localAnimatorSet.playTogether(arrayOfAnimator);
        if (paramAnimatorListener != null)
            localAnimatorSet.addListener(paramAnimatorListener);
        localAnimatorSet.start();
        return localAnimatorSet;
    }

    /**
     * 缩小动画
     * 
     * @param paramView
     * @param paramFloat
     *            缩小的比例
     * @param paramAnimatorListener
     * @return
     */
    public static AnimatorSet startScaleToSmallAnimation(View paramView,
            float paramFloat, Animator.AnimatorListener paramAnimatorListener) {
        AnimatorSet animatorSet = new AnimatorSet();
        try {
            clearAnimation(paramView);
            float[] arrayOfFloat1 = new float[2];
            arrayOfFloat1[0] = paramFloat;
            arrayOfFloat1[1] = 1.0F;
            ObjectAnimator localObjectAnimator1 = ObjectAnimator.ofFloat(paramView,
                    "scaleY", arrayOfFloat1);
            localObjectAnimator1.setDuration(500L);
            localObjectAnimator1.setRepeatCount(Animation.INFINITE);
            localObjectAnimator1.setRepeatMode(ValueAnimator.REVERSE);
            localObjectAnimator1.setInterpolator(new DecelerateInterpolator());
            float[] arrayOfFloat2 = new float[2];
            arrayOfFloat2[0] = paramFloat;
            arrayOfFloat2[1] = 1.0F;
            ObjectAnimator localObjectAnimator2 = ObjectAnimator.ofFloat(paramView,
                    "scaleX", arrayOfFloat2);
            localObjectAnimator2.setDuration(500L);
            localObjectAnimator2.setRepeatCount(Animation.INFINITE);
            localObjectAnimator2.setRepeatMode(ValueAnimator.REVERSE);
            localObjectAnimator2.setInterpolator(new DecelerateInterpolator());
            Animator[] arrayOfAnimator = new Animator[2];
            arrayOfAnimator[0] = localObjectAnimator1;
            arrayOfAnimator[1] = localObjectAnimator2;
            animatorSet.playTogether(arrayOfAnimator);
            animatorSet.start();
        }catch (Exception e){
            clearAnimation(paramView);
            FoxBaseCrashUtils.reportErrorData(e);
        }

        return animatorSet;
    }

    /**
     * 缩放
     * @param paramView
     * @param pivotX
     * @param pivotY
     */
    public static void  startScaleAnimation(View paramView,float paramFloat,float pivotX,float pivotY){
        try {
            clearAnimation(paramView);
            ScaleAnimation scaleAnimation;
            if(pivotX >0 && pivotY > 0) {
                scaleAnimation = new ScaleAnimation(paramFloat, 1.0f, paramFloat, 1.0f, pivotX, pivotY);
            }else{
                scaleAnimation = new ScaleAnimation(paramFloat, 1.0f, paramFloat, 1.0f);
            }
            scaleAnimation.setDuration(500L);
            scaleAnimation.setRepeatCount(Animation.INFINITE);
            scaleAnimation.setRepeatMode(ValueAnimator.REVERSE);
            if(null != paramView) {
                paramView.startAnimation(scaleAnimation);
            }
        }catch (Exception e){
            clearAnimation(paramView);
            FoxBaseCrashUtils.reportErrorData(e);
        }
    }

    public static AnimatorSet localAnimatorSet = new AnimatorSet();
    public static boolean isTranlateDownning = false;
    /**
     * 降落抖动
     *
     * @param paramView
     * @return
     */
    public static AnimatorSet startTranlateDownAnimation(final View paramView, final int delay, final Animator.AnimatorListener paramAnimatorListener) {
        try {
            clearAnimation(paramView);
            float[] arrayOfFloat = new float[2];
            arrayOfFloat[0] = -200.0F;
            arrayOfFloat[1] = 1.0F;
            ObjectAnimator localObjectAnimator1 = ObjectAnimator.ofFloat(paramView,
                    "translationY", arrayOfFloat);
            localObjectAnimator1.setDuration(1000L);
            ObjectAnimator localObjectAnimator2 = ObjectAnimator.ofFloat(paramView,
                    "rotation", 0.0F, -30.0F,0.0F,30.0F,0.0F);
            localObjectAnimator2.setDuration(200L);
            localObjectAnimator2.setRepeatCount(3);
            localObjectAnimator2.setInterpolator(new AccelerateInterpolator());
            localObjectAnimator2.setRepeatMode(ValueAnimator.RESTART);

            localAnimatorSet.playSequentially(localObjectAnimator1,localObjectAnimator2);
            localAnimatorSet.setStartDelay(delay);
            if(FoxBaseCommonUtils.isEmpty(localAnimatorSet.getListeners())){
                localAnimatorSet.addListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        if(isTranlateDownning) {
                            startTranlateDownAnimation(paramView, 0, null);
                        }
                    }
                });
            }
            if(!isTranlateDownning) return localAnimatorSet;
            localAnimatorSet.start();
        } catch (Exception e) {
            clearAnimation(paramView);
            FoxBaseCrashUtils.reportErrorData(e);
        }

        return localAnimatorSet;
    }

    /**
     * 向下移动动画
     * @param paramView
     * @param duration
     * @param paramAnimatorListener
     * @return
     */
    public static void startTranlateDown(View paramView, long duration, Animator.AnimatorListener paramAnimatorListener) {
        try {
            clearAnimation(paramView);
            float[] arrayOfFloat = new float[2];
            arrayOfFloat[0] = 0.0F;
            arrayOfFloat[1] = paramView.getHeight();
            ObjectAnimator animator = ObjectAnimator.ofFloat(paramView,
                    "translationY", arrayOfFloat);
            animator.setDuration(duration);
            if(null != paramAnimatorListener) {
                animator.addListener(paramAnimatorListener);
            }

            animator.start();

        } catch (Exception e) {
            clearAnimation(paramView);
            FoxBaseCrashUtils.reportErrorData(e);
        }
    }

    /**
     * 向上移动动画
     * @param paramView
     * @param duration
     * @param paramAnimatorListener
     * @return
     */
    public static void startTranlateUp(View paramView, long duration, Animator.AnimatorListener paramAnimatorListener) {
        try {
            clearAnimation(paramView);
            float[] arrayOfFloat = new float[2];
            arrayOfFloat[0] = paramView.getHeight();
            arrayOfFloat[1] = 0.0F;
            ObjectAnimator animator = ObjectAnimator.ofFloat(paramView,
                    "translationY", arrayOfFloat);
            animator.setDuration(duration);
            if(null != paramAnimatorListener) {
                animator.addListener(paramAnimatorListener);
            }

            animator.start();

        } catch (Exception e) {
            clearAnimation(paramView);
            FoxBaseCrashUtils.reportErrorData(e);
        }
    }

    public static AnimatorSet startRotationAnimation(View paramView, Animator.AnimatorListener paramAnimatorListener) {
        if (paramView.getAnimation() != null)
            paramView.getAnimation().cancel();
        paramView.clearAnimation();
        AnimatorSet localAnimatorSet = new AnimatorSet();
        float[] arrayOfFloat = new float[2];
        arrayOfFloat[0] = -100.0F;
        arrayOfFloat[1] = 1.0F;
        ObjectAnimator localObjectAnimator = ObjectAnimator.ofFloat(paramView,
                "rotation", 0.0F, -30.0F,0.0F,30.0F);
        localObjectAnimator.setDuration(200L);
        localObjectAnimator.setRepeatCount(10);
        localObjectAnimator.setRepeatMode(ValueAnimator.RESTART);
        localObjectAnimator.start();
//        localAnimatorSet.play(localObjectAnimator);
//        localAnimatorSet.setDuration(1000L);
//        localAnimatorSet.addListener(paramAnimatorListener);
//        localAnimatorSet.start();
        return localAnimatorSet;
    }

    /**
     * 从下往上移动的位移动画
     * 
     * @param paramView
     * @return
     */
    public static AnimatorSet startTranlateUpAnimation(View paramView) {
        if (paramView.getAnimation() != null)
            paramView.getAnimation().cancel();
        paramView.clearAnimation();
        AnimatorSet localAnimatorSet = new AnimatorSet();
        float[] arrayOfFloat = new float[2];
        arrayOfFloat[0] = 1.0F;
        arrayOfFloat[1] = -80.0F;
        ObjectAnimator localObjectAnimator = ObjectAnimator.ofFloat(paramView,
                "translationY", arrayOfFloat);
        localObjectAnimator.setDuration(240L);
        localObjectAnimator.setInterpolator(new DecelerateInterpolator());
        localAnimatorSet.play(localObjectAnimator);
        localAnimatorSet.start();
        return localAnimatorSet;
    }

    public static ValueAnimator initOutAnimator(int margin, int duration){
        ValueAnimator outAnimator = ValueAnimator.ofInt(margin, 0);
        outAnimator.setDuration(duration);
        outAnimator.setInterpolator(new AccelerateDecelerateInterpolator());

        return outAnimator;
    }

    public static ValueAnimator initInAnimator(int current, final int margin, int duration){
        ValueAnimator inAnimator = ValueAnimator.ofInt(current, margin);
        inAnimator.setDuration(duration);
        inAnimator.setInterpolator(new AccelerateDecelerateInterpolator());

        return inAnimator;
    }

    public static int updateAnimationParams(Context context, ValueAnimator valueAnimator, FoxImageView imageView,
                                            int margin, int minWidth, int maxWidth){
        try {
            int currentWidth;
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) imageView.getLayoutParams();
            int current = (int) valueAnimator.getAnimatedValue();
            float scale = (float) current / (float)margin;
            float alpha = 0.5f * (1f + scale);

            currentWidth = (int) (minWidth + scale * maxWidth);
            params.bottomMargin = current;
            if (currentWidth >= maxWidth){
                params.width = FoxBaseDensityUtils.dip2px(context, maxWidth);
                params.height = FoxBaseDensityUtils.dip2px(context, maxWidth);
            }else {
                params.width = FoxBaseDensityUtils.dip2px(context, currentWidth);
                params.height = FoxBaseDensityUtils.dip2px(context, currentWidth);
            }

            imageView.setLayoutParams(params);
            imageView.setAlpha(alpha);
            imageView.requestLayout();

            return current;
        }catch (Exception e){
            FoxBaseCrashUtils.reportErrorData(e);
        }

        return 0;
    }
}
