package com.mediamain.android.base.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;

import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;

/**
 * 检测其他应用是否安装
 * Created by Administrator on 2018/1/25.
 */

public class FoxBaseAppUtil {


    public static String sortAppend(Map<String, String> paramMap) {
        TreeMap<String, String> sortedMap = new TreeMap<>(paramMap);
        StringBuilder builder = new StringBuilder();
        boolean flag = true;
        for (Map.Entry<String, String> entry : sortedMap.entrySet()) {
            String value = entry.getValue();
            if (flag) {
                flag = false;
                builder.append(value);
            } else {
                builder.append("," + value);
            }
        }
        return builder.toString();
    }

    /**
     * 打开app
     *
     * @return
     */
    public static boolean openOtherApp(Context context, String appPackageName) {
        try {
            PackageManager packageManager = context.getPackageManager();
            Intent launchIntentForPackage = packageManager.getLaunchIntentForPackage(appPackageName);
            if (launchIntentForPackage != null) {
                context.startActivity(launchIntentForPackage);
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            return false;
        }
    }


    /**
     * 检查是否安装应用
     *
     * @param context
     * @param packageName
     * @return
     */
    public static boolean isAppInstall(Context context, String packageName) {
        if (packageName == null || "".equals(packageName))
            return false;
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(packageName,
                    PackageManager.GET_UNINSTALLED_PACKAGES);
            return true;
        } catch (PackageManager.NameNotFoundException e) {
            FoxBaseCrashUtils.reportErrorData(e);
            return false;
        }
    }

    /**
     * 在手机上打开文件
     */
    public static void openFile(Context mContext, File f) {
        try {
            if (mContext!=null){
                Intent intent = new Intent();
                intent.setAction(Intent.ACTION_VIEW);
                if (Build.VERSION.SDK_INT < 24) {
                    /* 调用getMIMEType()来取得MimeType */
                    String type = "application/vnd.android.package-archive";
                    /* 设置intent的file与MimeType */
                    intent.putExtra(Intent.EXTRA_NOT_UNKNOWN_SOURCE, true);
                    intent.putExtra(Intent.EXTRA_RETURN_RESULT, true);
                    intent.setDataAndType(Uri.fromFile(f), type);
                } else {
                    Uri uri = FileProvider.getUriForFile(mContext, mContext.getPackageName() + ".foxbasefileprovider", f);
                    intent.setDataAndType(uri, "application/vnd.android.package-archive");
                    intent.putExtra(Intent.EXTRA_NOT_UNKNOWN_SOURCE, true);
                    intent.putExtra(Intent.EXTRA_RETURN_RESULT, true);
                    intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
                }
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                mContext.startActivity(intent);
            }
        }catch (Exception e){
            FoxBaseCrashUtils.reportErrorData(e);
        }
    }
}
