package com.mediamain.android.base.util;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.support.annotation.RequiresPermission;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.content.ContextCompat;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.webkit.WebSettings;

import com.mediamain.android.BuildConfig;
import com.mediamain.android.R;
import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.FoxRouteActivity;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxBaseConstants;
import com.mediamain.android.base.data.DeviceTypeEnum;
import com.mediamain.android.base.data.FoxBaseAppInfo;
import com.mediamain.android.base.data.FoxBaseCollectBean;
import com.mediamain.android.base.data.FoxBaseCrashBean;
import com.mediamain.android.base.data.FoxBaseFileBean;
import com.mediamain.android.base.data.FoxBaseMDBean;
import com.mediamain.android.base.data.FoxBaseNewDownloadBean;
import com.mediamain.android.base.data.FoxBaseSDCardInfo;
import com.mediamain.android.base.data.FoxBaseSDKConfigBean;
import com.mediamain.android.base.data.FoxBaseSensorBean;
import com.mediamain.android.base.data.FoxBaseUsageStatsBean;
import com.mediamain.android.base.data.FoxBaseWifiInfoBean;
import com.mediamain.android.base.download.broadcast.DownloadBroadCast;
import com.mediamain.android.base.util.cache.FoxBaseCacheUtils;
import com.mediamain.android.view.imageloader.FoxImageWorker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLDecoder;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;

import javax.crypto.Cipher;

import static android.Manifest.permission.INTERNET;
import static android.content.Context.BATTERY_SERVICE;
import static android.content.Context.SENSOR_SERVICE;
import static android.content.Context.WIFI_SERVICE;
import static android.telephony.TelephonyManager.PHONE_TYPE_NONE;
import static com.mediamain.android.hotfix.FoxSdkPatch.LOCAL_PATCH_CODE;
import static com.mediamain.android.hotfix.FoxSdkPatch.LOCAL_PATCH_VERSION;

public class FoxBaseCommonUtils {

    private static DownloadBroadCast mDownloadBroadCast = null;
    public static DownloadBroadCast registerDownloadBroadCast(){
        if(mDownloadBroadCast == null){
            mDownloadBroadCast = new DownloadBroadCast();
            IntentFilter downloadFilter = new IntentFilter();
            downloadFilter.addAction(Intent.ACTION_PACKAGE_ADDED);
            downloadFilter.addDataScheme("package");
            FoxBaseUtils.getApp().getApplicationContext().registerReceiver(mDownloadBroadCast, downloadFilter);
        }
        return mDownloadBroadCast;
    }

    /**
     * 开发者自动校验工具-检测上报(下载器埋点上报)
     *
     * @param checkState
     */
    public static void postDataCheck(int checkState, String slotId,FoxBaseNewDownloadBean mNewDownloadBean) {

        if (!FoxBaseCommonUtils.isEmpty(slotId)) {
            FoxBaseMaidianUtil.build(157)
                    .set("businessType", Integer.toString(checkState))
                    .set("slotId", slotId)
                    .set("package_name", null != mNewDownloadBean ? mNewDownloadBean.getPackageName():"")
                    .set("url_package", null != mNewDownloadBean ? mNewDownloadBean.getUrl():"")
                    .set("tuia_id", null != mNewDownloadBean ? mNewDownloadBean.getTuiaId():"")
                    .postCheck();
        }
    }

    /**
     * 取消通知
     *
     * @param mActivity
     * @param id
     */
    public static void cancelNotify(Context mActivity, String id) {
        try {
            NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from(mActivity.getApplicationContext());
            notificationManagerCompat.cancel(Integer.parseInt(id));
        } catch (Exception e) {
        }
    }

    private static Future<Bitmap> mFuture = null;
    private static Bitmap mBitmap = null;

    /**
     * 展示通知栏新下载器
     * @param context
     * @param id 通知栏 id
     * @param foxBaseNewDownloadBean
     * @param progress
     * @param file
     * @param icon
     */
    public static void showChannelNewNotification( Context context, String id, FoxBaseNewDownloadBean foxBaseNewDownloadBean,
                                                   int progress,  File file, int icon, String customDesc) {
        try {
            if(null ==foxBaseNewDownloadBean) return;
            String iconUrl = foxBaseNewDownloadBean.getAppIconUri();
            final String channelId = "channelId";
            if (FoxImageWorker.getInstance().isBitmapExist(iconUrl)) {
                mBitmap = FoxImageWorker.getInstance().getBitmapFromMemCache(iconUrl);
            } else {
                if (null == mFuture){
                    mFuture = FoxImageWorker.getInstance().getBitmapFromUrl(context, 0, iconUrl, new FoxImageWorker.LoadImgCallable() {
                        @Override
                        public void setImage(Bitmap bitmap, String url) {
                            mBitmap = bitmap;
//                            showNotification(context,id,foxBaseNewDownloadBean, progress, file, icon,channelId, mBitmap);
                        }

                        @Override
                        public void loadFaild() {
                        }
                    });
                }
            }

            if (FoxBaseSPUtils.getInstance().getBoolean(FoxBaseConstants.KEY_TUIA_SDK_ISSUPPORTDOWNLOAD, true)) {
//                String channelId = "channelId";
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    CharSequence channelName = "channelName";
                    String channelDescription = "channelDescription";
                    int channelImportance = NotificationManager.IMPORTANCE_DEFAULT;

                    NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, channelImportance);
                    // 设置描述 最长30字符
                    notificationChannel.setDescription(channelDescription);
                    // 该渠道的通知是否使用震动
                    notificationChannel.enableLights(false);
                    notificationChannel.enableVibration(false);
                    notificationChannel.setVibrationPattern(new long[]{0});
                    notificationChannel.setSound(null, null);
                    // 设置显示模式
                    notificationChannel.setLockscreenVisibility(NotificationCompat.VISIBILITY_PUBLIC);

                    NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
                    notificationManager.createNotificationChannel(notificationChannel);
                }

                showNotification(context,id,foxBaseNewDownloadBean, progress, file, icon,channelId, mBitmap, customDesc);
            }
        } catch (Exception e) {
            destroyNotification();
        }
    }

    private static void destroyNotification(){
        try {
            if (mFuture != null) {
                mFuture.cancel(true);
            }
            mFuture = null;
//            mBitmap = null;
        } catch (Exception ignored) {
        }
    }

    private static void showNotification(Context context, String id,FoxBaseNewDownloadBean foxBaseNewDownloadBean,
                                  int progress, File file, int icon, String channelId,Bitmap iconBitmap, String customDesc){
        try {
            if (null == foxBaseNewDownloadBean) return;
            String appName = foxBaseNewDownloadBean.getApplicationName();
            String desc = foxBaseNewDownloadBean.getDesc();
            String url = foxBaseNewDownloadBean.getUrl();
            NotificationCompat.Builder notificationCompatBuilder = new NotificationCompat.Builder(context.getApplicationContext(), channelId);
            Notification notification;
            if (progress != 100) {
                notification = notificationCompatBuilder
                        // Title for API <16 (4.0 and below) devices.
                        .setContentTitle(TextUtils.isEmpty(appName) ? "福利" : appName)
                        // Content for API <24 (7.0 and below) devices.
                        .setContentText(TextUtils.isEmpty(customDesc) ? "点击领取新人福利" : customDesc)
                        .setSmallIcon(icon)
                        .setLargeIcon(null == iconBitmap ? BitmapFactory.decodeResource(
                                context.getResources(),
                                icon) : iconBitmap)
                        .setDefaults(NotificationCompat.DEFAULT_ALL)
                        .setColor(ContextCompat.getColor(context.getApplicationContext(), R.color.colorPrimary))
                        .setCategory(Notification.CATEGORY_REMINDER)
                        .setPriority(NotificationCompat.PRIORITY_MAX)
                        .setVibrate(new long[]{0})
                        .setSound(null)
                        .setProgress(100, progress, false)
                        .build();
            } else {
                notification = notificationCompatBuilder
                        // Title for API <16 (4.0 and below) devices.
                        .setContentTitle(TextUtils.isEmpty(appName) ? "福利" : appName)
                        // Content for API <24 (7.0 and below) devices.
                        .setContentText(TextUtils.isEmpty(customDesc) ? "点击领取新人福利" : customDesc)
                        .setSmallIcon(icon)
                        .setLargeIcon(null == iconBitmap ? BitmapFactory.decodeResource(
                                context.getResources(),
                                icon) : iconBitmap)
                        .setDefaults(NotificationCompat.DEFAULT_ALL)
                        .setColor(ContextCompat.getColor(context.getApplicationContext(), R.color.colorPrimary))
                        .setCategory(Notification.CATEGORY_REMINDER)
                        .setPriority(NotificationCompat.PRIORITY_MAX)
                        .setVibrate(new long[]{0})
                        .setSound(null)
                        .build();
                destroyNotification();
            }
            //延迟意图
            //点击安装PendingIntent
            Intent intent = new Intent(context, FoxRouteActivity.class);
            if (file != null && file.exists()) {
                intent.putExtra("file", file.getAbsolutePath());
            }
            intent.putExtra("packageName", foxBaseNewDownloadBean.getPackageName());
            intent.putExtra("tuiaId", FoxBaseCommonUtils.isEmpty(foxBaseNewDownloadBean.getTuiaId()) ? foxBaseNewDownloadBean.getTmId() : foxBaseNewDownloadBean.getTuiaId());
            intent.putExtra("url", FoxBaseCommonUtils.isEmpty(url) ? "" : url);
            PendingIntent pendingIntent;
            if (progress != 100) {
                pendingIntent = PendingIntent.getActivity(context, 0, intent, PendingIntent.FLAG_NO_CREATE);
            } else {
                pendingIntent = PendingIntent.getActivity(context, 0, intent, PendingIntent.FLAG_ONE_SHOT);
            }
            notification.contentIntent = pendingIntent;
            // 滑动或者clear都不会清空
            notification.flags |= Notification.FLAG_AUTO_CANCEL;
            NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from(context.getApplicationContext());
            notificationManagerCompat.notify(Integer.parseInt(id), notification);
        }catch (Exception e){
            destroyNotification();
        }
    }


    /**
     * 展示通知栏
     *
     * @param appName
     * @param desc
     */
    public static void showChannel1Notification(Context mActivity, String id,
                                                String appName, String desc, String packageName, int progress, File file, String tuiaId) {
        try {
            if (FoxBaseSPUtils.getInstance().getBoolean(FoxBaseConstants.KEY_TUIA_SDK_ISSUPPORTDOWNLOAD, true)) {
                String channelId = "channelId";
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    CharSequence channelName = "channelName";
                    String channelDescription = "channelDescription";
                    int channelImportance = NotificationManager.IMPORTANCE_DEFAULT;

                    NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, channelImportance);
                    // 设置描述 最长30字符
                    notificationChannel.setDescription(channelDescription);
                    // 该渠道的通知是否使用震动
                    notificationChannel.enableLights(false);
                    notificationChannel.enableVibration(false);
                    notificationChannel.setVibrationPattern(new long[]{0});
                    notificationChannel.setSound(null, null);
                    // 设置显示模式
                    notificationChannel.setLockscreenVisibility(NotificationCompat.VISIBILITY_PUBLIC);

                    NotificationManager notificationManager = (NotificationManager) mActivity.getSystemService(Context.NOTIFICATION_SERVICE);
                    notificationManager.createNotificationChannel(notificationChannel);
                }
                NotificationCompat.Builder notificationCompatBuilder = new NotificationCompat.Builder(mActivity.getApplicationContext(), channelId);
                Notification notification;
                if (progress != 100) {
                    notification = notificationCompatBuilder
                            // Title for API <16 (4.0 and below) devices.
                            .setContentTitle(TextUtils.isEmpty(appName) ? "福利" : appName)
                            // Content for API <24 (7.0 and below) devices.
                            .setContentText(TextUtils.isEmpty(desc) ? "点击领取新人福利" : desc)
                            .setSmallIcon(R.drawable.fox_app_iocn_default)
                            .setLargeIcon(BitmapFactory.decodeResource(
                                    mActivity.getResources(),
                                    R.drawable.fox_app_iocn_default))
                            .setDefaults(NotificationCompat.DEFAULT_ALL)
                            .setColor(ContextCompat.getColor(mActivity.getApplicationContext(), R.color.colorPrimary))
                            .setCategory(Notification.CATEGORY_REMINDER)
                            .setPriority(NotificationCompat.PRIORITY_MAX)
                            .setVibrate(new long[]{0})
                            .setSound(null)
                            .setProgress(100, progress, false)
                            .build();
                } else {
                    notification = notificationCompatBuilder
                            // Title for API <16 (4.0 and below) devices.
                            .setContentTitle(TextUtils.isEmpty(appName) ? "福利" : appName)
                            // Content for API <24 (7.0 and below) devices.
                            .setContentText(TextUtils.isEmpty(desc) ? "点击领取新人福利" : desc)
                            .setSmallIcon(R.drawable.fox_app_iocn_default)
                            .setLargeIcon(BitmapFactory.decodeResource(
                                    mActivity.getResources(),
                                    R.drawable.fox_app_iocn_default))
                            .setDefaults(NotificationCompat.DEFAULT_ALL)
                            .setColor(ContextCompat.getColor(mActivity.getApplicationContext(), R.color.colorPrimary))
                            .setCategory(Notification.CATEGORY_REMINDER)
                            .setPriority(NotificationCompat.PRIORITY_MAX)
                            .setVibrate(new long[]{0})
                            .setSound(null)
                            .build();
                }
                //延迟意图
                //点击安装PendingIntent
                Intent intent = new Intent(mActivity, FoxRouteActivity.class);
                if (file != null && file.exists()) {
                    intent.putExtra("file", file.getAbsolutePath());
                }
                intent.putExtra("packageName", packageName);
                intent.putExtra("tuiaId", tuiaId);
                PendingIntent pendingIntent;
                if (progress != 100) {
                    pendingIntent = PendingIntent.getActivity(mActivity, 0, intent, PendingIntent.FLAG_NO_CREATE);
                } else {
                    pendingIntent = PendingIntent.getActivity(mActivity, 0, intent, PendingIntent.FLAG_ONE_SHOT);
                }
                notification.contentIntent = pendingIntent;
                // 滑动或者clear都不会清空
                notification.flags |= Notification.FLAG_AUTO_CANCEL;
                NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from(mActivity.getApplicationContext());
                notificationManagerCompat.notify(Integer.parseInt(id), notification);
            }
        } catch (Exception e) {
        }
    }

    /**
     * 加密RSA
     * 用公钥加密
     *
     * @param data
     * @param key
     * @return
     */
    public static String encrypt(String data, String key) {
        try {
            if (isEmpty(data) || isEmpty(key)) {
                return "";
            }
            // 对公钥解密
            byte[] keyBytes = FoxBaseEncodeUtils.base64Decode(key.getBytes("UTF-8"));
            // 取得公钥
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            Key publicKey = keyFactory.generatePublic(x509KeySpec);
            // 对数据加密
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(Cipher.ENCRYPT_MODE, publicKey);
            byte[] inputArray = data.getBytes("UTF-8");
            int inputLength = inputArray.length;
            // 最大加密字节数，超出最大字节数需要分组加密
            int MAX_ENCRYPT_BLOCK = 117;
            // 标识
            int offSet = 0;
            byte[] resultBytes = {};
            byte[] cache;
            while (inputLength - offSet > 0) {
                if (inputLength - offSet > MAX_ENCRYPT_BLOCK) {
                    cache = cipher.doFinal(inputArray, offSet, MAX_ENCRYPT_BLOCK);
                    offSet += MAX_ENCRYPT_BLOCK;
                } else {
                    cache = cipher.doFinal(inputArray, offSet, inputLength - offSet);
                    offSet = inputLength;
                }
                resultBytes = Arrays.copyOf(resultBytes, resultBytes.length + cache.length);
                System.arraycopy(cache, 0, resultBytes, resultBytes.length - cache.length, cache.length);
            }
            return new String(FoxBaseEncodeUtils.base64Encode(resultBytes), "UTF-8");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }


    /**
     * 根据Uri 调起应用
     *
     * @param context
     * @param uri
     * @return
     */
    public static boolean startActivity(Context context, Uri uri) {
        if (context == null) {
            return false;
        }
        if (uri == null) {
            return false;
        }
        Intent intent = new Intent(Intent.ACTION_VIEW, uri);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, PackageManager.MATCH_DEFAULT_ONLY);
        if (resolveInfo == null) {
            return false;
        }
        context.startActivity(intent);
        return true;
    }

    public static boolean checkAppUsagePermission() {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                UsageStatsManager usageStatsManager = null;
                usageStatsManager = (UsageStatsManager) FoxBaseSDK.getContext().getSystemService(Context.USAGE_STATS_SERVICE);
                if (usageStatsManager == null) {
                    return false;
                }
                long currentTime = System.currentTimeMillis();
                // try to get app usage state in last 1 min
                List<UsageStats> stats = usageStatsManager.queryUsageStats(UsageStatsManager.INTERVAL_DAILY, currentTime - 60 * 1000, currentTime);
                if (stats.size() == 0) {
                    return false;
                }
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {

        }
        return false;
    }

    @SuppressWarnings("ResourceType")
    public static List<FoxBaseUsageStatsBean> getUsageList(Context context) {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                List<FoxBaseUsageStatsBean> list = new ArrayList<>();
                long currentTime = System.currentTimeMillis();
                long endTime = currentTime - 7 * 24 * 60 * 60 * 60 * 1000;
                UsageStatsManager mUsmManager = (UsageStatsManager) context.getSystemService("usagestats");
                Map<String, UsageStats> map = mUsmManager.queryAndAggregateUsageStats(endTime, currentTime);
                if (map == null || map.size() == 0) {
                    return null;
                }
                for (Map.Entry<String, UsageStats> entry : map.entrySet()) {
                    UsageStats stats = entry.getValue();
                    if (stats.getTotalTimeInForeground() > 0) {
                        list.add(new FoxBaseUsageStatsBean(stats.getPackageName(),
                                stats.getFirstTimeStamp(),
                                stats.getLastTimeStamp(),
                                stats.getLastTimeUsed(),
                                stats.getTotalTimeInForeground()));
                    }
                }
                return list;
            }
        } catch (Exception e) {

        }
        return null;
    }

    /**
     * 获取电量信息
     *
     * @return
     */
    public static int getBatteryInfo() {
        int intProperty = 0;
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                BatteryManager manager = (BatteryManager) FoxBaseSDK.getContext().getSystemService(BATTERY_SERVICE);
                intProperty = manager.getIntProperty(BatteryManager.BATTERY_PROPERTY_CAPACITY);
            } else {
                intProperty = 0;
            }
        } catch (Exception e) {
        }
        return intProperty;
    }

    /**
     * 获取缓存文件信息
     *
     * @param fileAbsolutePath
     * @return
     */
    public static List<FoxBaseFileBean> getAppCacheData(String fileAbsolutePath) {
        try {
            final long timeMillis = System.currentTimeMillis();
            final List<File> files = FoxBaseFileUtils.listFilesInDir(fileAbsolutePath);
            List<FoxBaseFileBean> data = new ArrayList<>();
            if (!FoxBaseCommonUtils.isEmpty(files)) {
                for (File file : files) {
                    if (file != null && file.exists() && !file.getName().startsWith(".")) {
                        final String fileSize = FoxBaseFileUtils.getDirSize(file);
                        data.add(new FoxBaseFileBean(FoxBaseFileUtils.getFileName(file), fileSize, timeMillis));
                    }
                }
            }
            return data;
        } catch (Exception e) {
        }
        return null;
    }


    /**
     * 签名
     *
     * @param input
     * @return
     */
    public static String sha1(String input) {
        StringBuffer sb = new StringBuffer();
        MessageDigest mDigest = null;
        try {
            mDigest = MessageDigest.getInstance("SHA1");
            byte[] result = mDigest.digest(input.getBytes());
            for (int i = 0; i < result.length; i++) {
                sb.append(Integer.toString((result[i] & 0xff) + 0x100, 16).substring(1));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    /***
     * 获取url 指定name的value;
     * @param url
     * @param name
     * @return
     */
    public static String getValueByName(String url, String name) {
        String decodeUrl = url;
        try {
            decodeUrl = URLDecoder.decode(url, "UTF-8");
        } catch (Exception ignored) {
        }
        String result = "";
        int index = decodeUrl.indexOf("?");
        String temp = decodeUrl.substring(index + 1);
        String[] keyValue = temp.split("&");
        for (String str : keyValue) {
            if (str.contains(name)) {
                result = str.replace(name + "=", "");
                break;
            }
        }
        return result;
    }

    /**
     * 获取ua
     *
     * @return
     */
    public static String getUserAgent() {
        String userAgent;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            try {
                userAgent = WebSettings.getDefaultUserAgent(FoxBaseSDK.getContext());
            } catch (Exception e) {
                userAgent = System.getProperty("http.agent");
            }
        } else {
            userAgent = System.getProperty("http.agent");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0, length = userAgent.length(); i < length; i++) {
            char c = userAgent.charAt(i);
            if (c <= '\u001f' || c >= '\u007f') {
                sb.append(String.format("\\u%04x", (int) c));
            } else {
                sb.append(c);
            }
        }
        if (TextUtils.isEmpty(userAgent)) {
            sb.append("Android");
        }
        return sb.toString();
    }

    /**
     * 获取 构建并获取 Imei 信息
     * Pseudo-IMEI, 这个在任何Android手机中都有效
     * 有一些特殊的情况，一些如平板电脑的设置没有通话功能，或者你不愿加入READ_PHONE_STATE许可。而你仍然想获得唯
     * 一序列号之类的东西。这时你可以通过取出ROM版本、制造商、CPU型号、以及其他硬件信息来实现这一点。这样计算出
     * 来的ID不是唯一的（因为如果两个手机应用了同样的硬件以及Rom 镜像）。但应当明白的是，出现类似情况的可能性基
     * 本可以忽略。大多数的Build成员都是字符串形式的，我们只取他们的长度信息。我们取到13个数字，并在前面加上“ta
     * ”。这样这个ID看起来就和15位IMEI一样了。
     *
     * @return PesudoUniqueID
     */
    public static String getPesudoIMEI() {
        String m_szDevIDShort = "ta" +
                Build.BOARD.length() % 10 +
                Build.BRAND.length() % 10 +
                Build.CPU_ABI.length() % 10 +
                Build.DEVICE.length() % 10 +
                Build.DISPLAY.length() % 10 +
                Build.HOST.length() % 10 +
                Build.ID.length() % 10 +
                Build.MANUFACTURER.length() % 10 +
                Build.MODEL.length() % 10 +
                Build.PRODUCT.length() % 10 +
                Build.TAGS.length() % 10 +
                Build.TYPE.length() % 10 +
                Build.USER.length() % 10; //13 digits
        return m_szDevIDShort;
    }

    /**
     * The Android ID（OPENUUID）
     * 通常被认为不可信，因为它有时为null。开发文档中说明了：这个ID会改变如果进行了出厂设置。并且，如果某个
     * Andorid手机被Root过的话，这个ID也可以被任意改变。无需任何许可。
     *
     * @return AndroidID
     */
    @SuppressLint("HardwareIds")
    public static String getAndroidId(Context context) {
        return Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
    }

    private static boolean isAddressNotInExcepts(final String address, final String... excepts) {
        if (excepts == null || excepts.length == 0) {
            return !"02:00:00:00:00:00".equals(address);
        }
        for (String filter : excepts) {
            if (address.equals(filter)) {
                return false;
            }
        }
        return true;
    }

    @SuppressLint({"MissingPermission", "HardwareIds"})
    private static String getMacAddressByWifiInfo() {
        try {
            final WifiManager wifi = (WifiManager) FoxBaseSDK.getContext()
                    .getApplicationContext().getSystemService(WIFI_SERVICE);
            if (wifi != null) {
                final WifiInfo info = wifi.getConnectionInfo();
                if (info != null) return info.getMacAddress();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByNetworkInterface() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (ni == null || !ni.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = ni.getHardwareAddress();
                if (macBytes != null && macBytes.length > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (byte b : macBytes) {
                        sb.append(String.format("%02x:", b));
                    }
                    return sb.substring(0, sb.length() - 1);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByInetAddress() {
        try {
            InetAddress inetAddress = getInetAddress();
            if (inetAddress != null) {
                NetworkInterface ni = NetworkInterface.getByInetAddress(inetAddress);
                if (ni != null) {
                    byte[] macBytes = ni.getHardwareAddress();
                    if (macBytes != null && macBytes.length > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (byte b : macBytes) {
                            sb.append(String.format("%02x:", b));
                        }
                        return sb.substring(0, sb.length() - 1);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static InetAddress getInetAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                // To prevent phone of xiaomi return "10.0.2.15"
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress inetAddress = addresses.nextElement();
                    if (!inetAddress.isLoopbackAddress()) {
                        String hostAddress = inetAddress.getHostAddress();
                        if (hostAddress.indexOf(':') < 0) return inetAddress;
                    }
                }
            }
        } catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * Return whether using ethernet.
     * <p>Must hold
     * {@code <uses-permission android:name="android.permission.ACCESS_NETWORK_STATE" />}</p>
     *
     * @return {@code true}: yes<br>{@code false}: no
     */
    private static boolean isEthernet() {
        if (ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.ACCESS_NETWORK_STATE) == PackageManager.PERMISSION_GRANTED) {
            final ConnectivityManager cm =
                    (ConnectivityManager) FoxBaseSDK.getContext().getSystemService(Context.CONNECTIVITY_SERVICE);
            if (cm == null) return false;
            final NetworkInfo info = cm.getNetworkInfo(ConnectivityManager.TYPE_ETHERNET);
            if (info == null) return false;
            NetworkInfo.State state = info.getState();
            if (null == state) return false;
            return state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING;
        }
        return false;
    }

    private static NetworkInfo getActiveNetworkInfo() {
        if (ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.ACCESS_NETWORK_STATE) == PackageManager.PERMISSION_GRANTED) {
            ConnectivityManager cm = (ConnectivityManager) FoxBaseSDK.getContext().getSystemService(Context.CONNECTIVITY_SERVICE);
            if (cm == null) return null;
            return cm.getActiveNetworkInfo();
        }
        return null;
    }

    /**
     * Return the name of network operate.
     *
     * @return the name of network operate
     */
    public static String getNetworkOperatorName() {
        TelephonyManager tm =
                (TelephonyManager) FoxBaseSDK.getContext().getSystemService(Context.TELEPHONY_SERVICE);
        if (tm == null) return "";
        return tm.getNetworkOperatorName();
    }


    /**
     * Return the serial of device.
     *
     * @return the serial of device
     */
    @SuppressLint("HardwareIds")
    public static String getSerial() {
        if (ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
            return Build.VERSION.SDK_INT >= Build.VERSION_CODES.O ? Build.getSerial() : Build.SERIAL;
        }
        return "";
    }

    /**
     * Return the IMSI.
     * <p>Must hold {@code <uses-permission android:name="android.permission.READ_PHONE_STATE" />}</p>
     *
     * @return the IMSI
     */
    @SuppressLint("HardwareIds")
    public static String getIMSI() {
        String imsi = "";
        try{
            if (ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
                TelephonyManager tm = (TelephonyManager) FoxBaseSDK.getContext().getSystemService(Context.TELEPHONY_SERVICE);
                imsi = tm.getSubscriberId();
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return imsi;
    }

    /**
     * Return whether the device is phone.
     *
     * @return {@code true}: yes<br>{@code false}: no
     */
    public static boolean isPhone() {
        TelephonyManager tm = getTelephonyManager();
        return tm.getPhoneType() != TelephonyManager.PHONE_TYPE_NONE;
    }

    private static String filterImei(String imei) {
        // 过滤掉空的串码，小于8位的串码(0,unknown,null)
        if (imei == null || imei.isEmpty() || imei.length() < 8) {
            return "";
        }
        if (imei.length() == 15) {
            // 可能是正确的手机imei，进行校验
            if (isCorrectImei(imei)) {
                return imei;
            } else {
                // 15 位不合法的imei
                return "";
            }
        } else {
            // 其他情况，直接返回，包括以下几种
            // 1、8位ESN
            // 2、14位MEID
            // 3、16位平板串码
            // 4、带前缀的合法imei——"IMEI: 863284041223575"、"1:862941031639729"
            // 5、其他
            return imei;
        }
    }

    /**
     * Return the IMEI.
     * v3.0.0.0更正：获取的不一定是imei，可能是ESN(8位)、MEID(14位)、16位imei(平板)、其他的串码
     * <p>Must hold {@code <uses-permission android:name="android.permission.READ_PHONE_STATE" />}</p>
     *
     * @return the IMEI
     */
    @SuppressLint("HardwareIds")
    public static String getIMEI() {
        String imei = "";
        try {
            imei = FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_IMEI, "");
            if(!FoxBaseCommonUtils.isEmpty(imei) || Build.VERSION.SDK_INT > Build.VERSION_CODES.P){
                return imei;
            }
            if (ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
                TelephonyManager tm = (TelephonyManager) FoxBaseSDK.getContext().getSystemService(Context.TELEPHONY_SERVICE);
                if (tm != null) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                        if (tm.getImei() != null) {
                            imei = filterImei(tm.getImei());
                            FoxBaseSPUtils.getInstance().setString(FoxBaseConstants.KEY_TUIA_SDK_IMEI, "" + imei);
                            return imei;
                        }
                    } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                        Class clazz = tm.getClass();
                        //noinspection unchecked
                        Method getImeiMethod = clazz.getDeclaredMethod("getImei");
                        getImeiMethod.setAccessible(true);
                        final String imeiInvoke = (String) getImeiMethod.invoke(tm);
                        if (imeiInvoke != null) {
                            imei = filterImei(imeiInvoke);
                            FoxBaseSPUtils.getInstance().setString(FoxBaseConstants.KEY_TUIA_SDK_IMEI, "" + imei);
                            return imei;
                        }
                    }
                    final String deviceId = tm.getDeviceId();
                    imei = filterImei(deviceId);
                    FoxBaseSPUtils.getInstance().setString(FoxBaseConstants.KEY_TUIA_SDK_IMEI, "" + imei);
                    return imei;
                }
            }
            if (FoxBaseCommonUtils.isEmpty(imei)) {
                imei = FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_IMEI, "");
            }
        } catch (Exception e) {
        }
        return imei;
    }

    /**
     * 检验imei是否正确
     * imei 由15位数字组成
     * 前6位：TAC，一般代表机型
     * 接着2位：FAC，装配号，一般代表产地
     * 之后6位：SNR，出产序号，一般代表生产顺序号
     * 最后1位：SP，校验码， 由前14位数字通过Luhn算法得出
     * @param imei imei串
     * @return true, 合法的imei; false, 不合法的imei
     */
    public static boolean isCorrectImei(String imei) {
        // 17 位imei 的处理
        if (imei.length() == 17) {
            imei = imei.substring(0, 15);
        }
        if (!TextUtils.isDigitsOnly(imei)) {
            return false;
        }
        final int length = 15;
        if (imei.length() == length) {
            // 最后一位校验码
            int check = Integer.parseInt(imei.substring(14));
            imei = imei.substring(0, 14);
            char[] imeiChar = imei.toCharArray();
            int resultInt = 0;
            for (int i = 0; i < imeiChar.length; i++) {
                int a = Integer.parseInt(String.valueOf(imeiChar[i]));
                i++;
                final int temp = Integer.parseInt(String.valueOf(imeiChar[i])) * 2;
                final int b = temp < 10 ? temp : temp - 9;
                resultInt += a + b;
            }
            resultInt %= 10;
            resultInt = resultInt == 0 ? 0 : 10 - resultInt;
            return resultInt == check;
        }
        return false;
    }

    /**
     * IMEI
     *
     * @param context
     * @return
     */
    public static Location getGPSInfo(final Context context) {
        Location bestLocation = null;
        try {
            if (ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
                    && ActivityCompat.checkSelfPermission(context, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                return bestLocation;
            }
            LocationManager lm = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);
            //判断GPS是否正常启动
            if (lm != null && (lm.isProviderEnabled(LocationManager.GPS_PROVIDER) || lm.isProviderEnabled(LocationManager.NETWORK_PROVIDER))) {
                try {
                    List<String> providers = lm.getProviders(true);
                    for (String provider : providers) {
                        Location l = lm.getLastKnownLocation(provider);
                        if (l == null) {
                            continue;
                        }
                        if (bestLocation == null || l.getAccuracy() < bestLocation.getAccuracy()) {
                            bestLocation = l;
                        }
                    }
                } catch (Exception e) {
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return bestLocation;
    }

    /**
     * Returns the current phone type.
     *
     * @return the current phone type
     * <ul>
     * <li>{@link TelephonyManager#PHONE_TYPE_NONE}</li>
     * <li>{@link TelephonyManager#PHONE_TYPE_GSM }</li>
     * <li>{@link TelephonyManager#PHONE_TYPE_CDMA}</li>
     * <li>{@link TelephonyManager#PHONE_TYPE_SIP }</li>
     * </ul>
     */
    public static int getPhoneType() {
        try {
            TelephonyManager tm = (TelephonyManager) FoxBaseSDK.getContext().getSystemService(Context.TELEPHONY_SERVICE);
            if (tm != null) {
                return tm.getPhoneType();
            }
        } catch (Exception e) {
        }
        return PHONE_TYPE_NONE;
    }

    public static final int NETWORK_TYPE_NR = 20;
    public enum NetworkType {
        NETWORK_ETHERNET,
        NETWORK_WIFI,
        NETWORK_5G,
        NETWORK_4G,
        NETWORK_3G,
        NETWORK_2G,
        NETWORK_UNKNOWN,
        NETWORK_NO
    }

    /**
     * Return type of network.
     * <p>Must hold {@code <uses-permission android:name="android.permission.ACCESS_NETWORK_STATE" />}</p>
     *
     * @return type of network
     * <ul>
     * <li>{@link NetworkType#NETWORK_ETHERNET} </li>
     * <li>{@link NetworkType#NETWORK_WIFI    } </li>
     * <li>{@link NetworkType#NETWORK_4G      } </li>
     * <li>{@link NetworkType#NETWORK_3G      } </li>
     * <li>{@link NetworkType#NETWORK_2G      } </li>
     * <li>{@link NetworkType#NETWORK_UNKNOWN } </li>
     * <li>{@link NetworkType#NETWORK_NO      } </li>
     * </ul>
     */
    public static NetworkType getNetworkType() {
        if (isEthernet()) {
            return NetworkType.NETWORK_ETHERNET;
        }
        if (ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.ACCESS_NETWORK_STATE) == PackageManager.PERMISSION_GRANTED) {
            NetworkInfo info = getActiveNetworkInfo();
            if (info != null && info.isAvailable()) {
                if (info.getType() == ConnectivityManager.TYPE_WIFI) {
                    return NetworkType.NETWORK_WIFI;
                } else if (info.getType() == ConnectivityManager.TYPE_MOBILE) {
                    switch (info.getSubtype()) {
                        case TelephonyManager.NETWORK_TYPE_GSM:
                        case TelephonyManager.NETWORK_TYPE_GPRS:
                        case TelephonyManager.NETWORK_TYPE_CDMA:
                        case TelephonyManager.NETWORK_TYPE_EDGE:
                        case TelephonyManager.NETWORK_TYPE_1xRTT:
                        case TelephonyManager.NETWORK_TYPE_IDEN:
                            return NetworkType.NETWORK_2G;
                        case TelephonyManager.NETWORK_TYPE_TD_SCDMA:
                        case TelephonyManager.NETWORK_TYPE_EVDO_A:
                        case TelephonyManager.NETWORK_TYPE_UMTS:
                        case TelephonyManager.NETWORK_TYPE_EVDO_0:
                        case TelephonyManager.NETWORK_TYPE_HSDPA:
                        case TelephonyManager.NETWORK_TYPE_HSUPA:
                        case TelephonyManager.NETWORK_TYPE_HSPA:
                        case TelephonyManager.NETWORK_TYPE_EVDO_B:
                        case TelephonyManager.NETWORK_TYPE_EHRPD:
                        case TelephonyManager.NETWORK_TYPE_HSPAP:
                            return NetworkType.NETWORK_3G;

                        case TelephonyManager.NETWORK_TYPE_IWLAN:
                        case TelephonyManager.NETWORK_TYPE_LTE:
                            return NetworkType.NETWORK_4G;
                        case NETWORK_TYPE_NR:
                            return NetworkType.NETWORK_5G;

                        default:
                            String subtypeName = info.getSubtypeName();
                            if (subtypeName.equalsIgnoreCase("TD-SCDMA")
                                    || subtypeName.equalsIgnoreCase("WCDMA")
                                    || subtypeName.equalsIgnoreCase("CDMA2000")) {
                                return NetworkType.NETWORK_3G;
                            }
                    }
                }
            }
        }

        try {
            if(NetworkUtil.getNetWorkType(FoxBaseSDK.getContext()) == NETWORK_TYPE_NR){
                return NetworkType.NETWORK_5G;
            }
        } catch (Exception ignore) {}
        return NetworkType.NETWORK_UNKNOWN;
    }

    public static class NetworkUtil {

        /**
         * get the network type
         *
         * @param ctx Context
         * @return networktype
         */
        public static int getNetWorkType(Context ctx) {
            int networkType = 0;
            TelephonyManager tm = (TelephonyManager) ctx.getSystemService(Context.TELEPHONY_SERVICE);
            try {
                int defaultDataSubId = getSubId();
                if (defaultDataSubId == -1) {
                    networkType = tm.getNetworkType();
                } else {
                    try {
                        Method dataNetworkType = TelephonyManager.class
                                .getDeclaredMethod("getDataNetworkType", new Class[]{int.class});
                        dataNetworkType.setAccessible(true);
                        networkType = (int) dataNetworkType.invoke(tm, defaultDataSubId);
                    } catch (Throwable t) {
                        networkType = tm.getNetworkType();
                    }
                }
            } catch (Throwable t) {
                // do nothing
            }
            if (networkType == TelephonyManager.NETWORK_TYPE_LTE) {
                networkType = adjustNetworkType(ctx, networkType);
            }
            return networkType;
        }

        /**
         * get the 5G network type
         *
         * @param ctx Context
         * @param networkTypeFromSys this method can be call only when networkTypeFromSys = 13(LET)
         * @return correct network type
         */
        private static int adjustNetworkType(Context ctx, int networkTypeFromSys) {
            int networkType = 0;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O
                    && ctx.checkSelfPermission(Manifest.permission.READ_PHONE_STATE)
                    == PackageManager.PERMISSION_GRANTED) {
                try {
                    TelephonyManager tm = (TelephonyManager) ctx
                            .getSystemService(Context.TELEPHONY_SERVICE);
                    ServiceState ss;
                    int defaultDataSubId = getSubId();
                    if (defaultDataSubId == -1) {
                        ss = tm.getServiceState();
                    } else {
                        try {
                            Class<TelephonyManager> infTm = TelephonyManager.class;
                            Method method = infTm
                                    .getDeclaredMethod("getServiceStateForSubscriber",
                                            new Class[]{int.class});
                            method.setAccessible(true);
                            ss = (ServiceState) method.invoke(tm, defaultDataSubId);
                        } catch (Throwable t) {
                            ss = tm.getServiceState();
                        }
                    }
                    if (ss != null && isServiceStateFiveGAvailable(ss.toString())) {
                        networkType = NETWORK_TYPE_NR;
                    }
                } catch (Exception e) {
                    // do nothing
                }
            }
            return networkType;
        }

        /**
         * get data sub id
         *
         * @return subId
         */
        private static int getSubId() {
            int defaultDataSubId = -1;
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
                defaultDataSubId = SubscriptionManager.getDefaultDataSubscriptionId();
            }
            return defaultDataSubId;
        }

        /**
         * check the service state str is 5G
         *
         * @param ss services state str
         * @return true if is 5G
         */
        private static boolean isServiceStateFiveGAvailable(String ss) {
            boolean available = false;
            if (!TextUtils.isEmpty(ss)
                    && (ss.contains("nrState=NOT_RESTRICTED")
                    || ss.contains("nrState=CONNECTED"))) {
                available = true;
            }
            return available;
        }
    }


    /**
     * Return the ip address.
     * <p>Must hold {@code <uses-permission android:name="android.permission.INTERNET" />}</p>
     *
     * @param useIPv4 True to use ipv4, false otherwise.
     * @return the ip address
     */
    @RequiresPermission(INTERNET)
    public static String getIPAddress(final boolean useIPv4) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            LinkedList<InetAddress> adds = new LinkedList<>();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                // To prevent phone of xiaomi return "10.0.2.15"
                if (!ni.isUp() || ni.isLoopback()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    adds.addFirst(addresses.nextElement());
                }
            }
            for (InetAddress add : adds) {
                if (!add.isLoopbackAddress()) {
                    String hostAddress = add.getHostAddress();
                    boolean isIPv4 = hostAddress.indexOf(':') < 0;
                    if (useIPv4) {
                        if (isIPv4) return hostAddress;
                    } else {
                        if (!isIPv4) {
                            int index = hostAddress.indexOf('%');
                            return index < 0
                                    ? hostAddress.toUpperCase(Locale.getDefault())
                                    : hostAddress.substring(0, index).toUpperCase(Locale.getDefault());
                        }
                    }
                }
            }
        } catch (SocketException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * Return the version name of device's system.
     *
     * @return the version name of device's system
     */
    public static String getSDKVersionName() {
        return Build.VERSION.RELEASE;
    }

    /**
     * Return the model of device.
     * <p>e.g. MI2SC</p>
     *
     * @return the model of device
     */
    public static String getModel() {
        String model = Build.MODEL;
        if (model != null) {
            model = model.trim().replaceAll("\\s*", "");
        } else {
            model = "";
        }
        return model;
    }


    private static TelephonyManager getTelephonyManager() {
        return (TelephonyManager) FoxBaseSDK.getContext().getSystemService(Context.TELEPHONY_SERVICE);
    }

    /**
     * Return the sim operator using mnc.
     *
     * @return the sim operator
     */
    public static String getSimOperatorByMnc() {
        TelephonyManager tm = getTelephonyManager();
        String operator = tm.getSimOperator();
        if (operator == null) return "";
        switch (operator) {
            case "46000":
            case "46002":
            case "46007":
            case "46020":
                return "中国移动";
            case "46001":
            case "46006":
            case "46009":
                return "中国联通";
            case "46003":
            case "46005":
            case "46011":
                return "中国电信";
            default:
                return operator;
        }
    }


    /**
     * MD
     * imei  device_id  api_version  advert_like_type longitude latitude os page_title nt apps  apps_active_list
     *
     * @return
     */
    public static String getMD(String slotId) {
        FoxBaseMDBean foxBaseMdBean = new FoxBaseMDBean();
        foxBaseMdBean.setDataType("1");
        foxBaseMdBean.setOs("Android");
        foxBaseMdBean.setApi_version("1.0.0");
        foxBaseMdBean.setSdk_version(BuildConfig.VERSION_NAME + "");
        try {
            foxBaseMdBean.setImei(getIMEI() + "");
            foxBaseMdBean.setDevice_id(getIMEI() + "");
            if (getNetworkType() == NetworkType.NETWORK_2G) {
                foxBaseMdBean.setNt("2G");
            } else if (getNetworkType() == NetworkType.NETWORK_3G) {
                foxBaseMdBean.setNt("3G");
            } else if (getNetworkType() == NetworkType.NETWORK_4G) {
                foxBaseMdBean.setNt("4G");
            } else if (getNetworkType() == NetworkType.NETWORK_WIFI) {
                foxBaseMdBean.setNt("wifi");
            } else if (getNetworkType() == NetworkType.NETWORK_5G) {
                foxBaseMdBean.setNt("5G");
            }

            foxBaseMdBean.setOaid(FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_APP_OAID, "") + "");
            //AB分流
            foxBaseMdBean.setTest_type(FoxBaseTestUtils.getABTest(slotId));
            foxBaseMdBean.setPackageName(FoxBaseUtils.getApp().getPackageName());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return Base64.encodeToString(FoxBaseGZipUtil.compress(FoxBaseGsonUtil.GsonString(foxBaseMdBean), FoxBaseGZipUtil.GZIP_ENCODE_UTF_8), Base64.NO_WRAP);
    }

    /**
     * MD
     * imei  device_id  api_version  advert_like_type longitude latitude os page_title nt apps  apps_active_list
     *
     * @return
     */
    public static String getCollectData(Context context, int dataFrom, String configData, String appkey, String appList, List<FoxBaseFileBean> appCacheData
            , List<FoxBaseUsageStatsBean> usageList, List<FoxBaseSensorBean> sensorList, String mUnCollect) {
        FoxBaseCollectBean foxBaseCollectBean = new FoxBaseCollectBean();
        foxBaseCollectBean.setData1(configData + "");
        foxBaseCollectBean.setDataType("1");
        foxBaseCollectBean.setApi_version("1.0.0");
        if (!mUnCollect.contains("data_from")) {
            try {
                foxBaseCollectBean.setData_from(dataFrom + "");
            }catch (Exception e){
                foxBaseCollectBean.setData_from("");
            }
        }
        if (!mUnCollect.contains("time")) {
            try {
                foxBaseCollectBean.setTime(System.currentTimeMillis() + "");
            }catch (Exception e){
                foxBaseCollectBean.setTime("");
            }
        }
        if (!mUnCollect.contains("os_type")) {
            foxBaseCollectBean.setOs_type("Android");
        }
        if (!mUnCollect.contains("app_key")) {
            try {
                foxBaseCollectBean.setApp_key(appkey + "");
            }catch (Exception e){
                foxBaseCollectBean.setApp_key("");
            }

        }
        try {
            if (!mUnCollect.contains("os_version")) {
                try {
                    foxBaseCollectBean.setOs_version(Build.VERSION.RELEASE);
                } catch (Exception e) {
                    foxBaseCollectBean.setOs_version("");
                }
            }
            if (!mUnCollect.contains("package_name")) {
                try {
                    foxBaseCollectBean.setPackage_name(FoxBaseUtils.getApp().getPackageName());
                } catch (Exception e) {
                    foxBaseCollectBean.setPackage_name("");
                }
            }
            if (!mUnCollect.contains("sdk_version")) {
                try {
                    foxBaseCollectBean.setSdk_version(BuildConfig.VERSION_NAME + "");
                } catch (Exception e) {
                    foxBaseCollectBean.setSdk_version("");
                }
            }
            if (!mUnCollect.contains("imei")) {
                try {
                    foxBaseCollectBean.setImei(getIMEI() + "");
                } catch (Exception e) {
                    foxBaseCollectBean.setImei("");
                }
            }
            if (!mUnCollect.contains("device_id")) {
                try {
                    foxBaseCollectBean.setDevice_id(getIMEI() + "");
                } catch (Exception e) {
                    foxBaseCollectBean.setDevice_id("");
                }
            }
            if (!mUnCollect.contains("net_carrier")) {
                try {
                    foxBaseCollectBean.setNet_carrier(getSimOperatorByMnc() + "");
                } catch (Exception e) {
                    foxBaseCollectBean.setNet_carrier("");
                }
            }
            if (!mUnCollect.contains("phone_model")) {
                try {
                    foxBaseCollectBean.setPhone_model(getModel() + "");
                } catch (Exception e) {
                    foxBaseCollectBean.setPhone_model("");
                }
            }
            if (!mUnCollect.contains("phone_brand")) {
                try {
                    foxBaseCollectBean.setPhone_brand(Build.MANUFACTURER + "");
                } catch (Exception e) {
                    foxBaseCollectBean.setPhone_brand("");
                }
            }
            if (!mUnCollect.contains("phone_ip")) {
                try {
                    foxBaseCollectBean.setPhone_ip(getIPAddress(true) + "");
                } catch (Exception e) {
                    foxBaseCollectBean.setPhone_ip("");
                }
            }
            if (!mUnCollect.contains("phone_electric")) {
                try {
                    foxBaseCollectBean.setPhone_electric(getBatteryInfo() + "%");
                } catch (Exception e) {
                    foxBaseCollectBean.setPhone_electric("");
                }
            }
            if (!mUnCollect.contains("net_type")) {
                try {
                    if (getNetworkType() == NetworkType.NETWORK_2G) {
                        foxBaseCollectBean.setNet_type("2G");
                    } else if (getNetworkType() == NetworkType.NETWORK_3G) {
                        foxBaseCollectBean.setNet_type("3G");
                    } else if (getNetworkType() == NetworkType.NETWORK_4G) {
                        foxBaseCollectBean.setNet_type("4G");
                    } else if (getNetworkType() == NetworkType.NETWORK_WIFI) {
                        foxBaseCollectBean.setNet_type("wifi");
                    } else if (getNetworkType() == NetworkType.NETWORK_5G) {
                        foxBaseCollectBean.setNet_type("5G");
                    }
                } catch (Exception e) {
                    foxBaseCollectBean.setNet_type("");
                }
            }

            if (!mUnCollect.contains("gps_longitude")) {
                try {
                    Location gpsInfo = FoxBaseCommonUtils.getGPSInfo(context);
                    foxBaseCollectBean.setGps_longitude(null != gpsInfo ? String.valueOf(gpsInfo.getLongitude()) : "");
                } catch (Exception e) {
                    foxBaseCollectBean.setGps_longitude("");
                }
            }
            if (!mUnCollect.contains("gps_latitude")) {
                try {
                    Location gpsInfo = FoxBaseCommonUtils.getGPSInfo(context);
                    foxBaseCollectBean.setGps_latitude(null != gpsInfo ? String.valueOf(gpsInfo.getLatitude()) : "");
                } catch (Exception e) {
                    foxBaseCollectBean.setGps_latitude("");
                }
            }

            if (!mUnCollect.contains("app_list")) {
                try {
                    foxBaseCollectBean.setApp_list(FoxBaseCommonUtils.isEmpty(appList) ? "" : appList);
                } catch (Exception e) {
                    foxBaseCollectBean.setApp_list("");
                }
            }
            if (!mUnCollect.contains("sensor_info")) {
                try {
                    if (FoxBaseCommonUtils.isEmpty(sensorList)) {
                        sensorList = new ArrayList<>();
                    }
                    foxBaseCollectBean.setSensor_info(sensorList);
                } catch (Exception e) {
                    foxBaseCollectBean.setSensor_info(new ArrayList<FoxBaseSensorBean>());
                }
            }
            if (!mUnCollect.contains("app_active_list")) {
                try {
                    if (FoxBaseCommonUtils.isEmpty(usageList)) {
                        usageList = new ArrayList<>();
                    }
                    foxBaseCollectBean.setApp_active_list(usageList);
                } catch (Exception e) {
                    foxBaseCollectBean.setApp_active_list(new ArrayList<FoxBaseUsageStatsBean>());
                }
            }
            if (!mUnCollect.contains("file_cache")) {
                try {
                    if (FoxBaseCommonUtils.isEmpty(appCacheData)) {
                        appCacheData = new ArrayList<>();
                    }
                    foxBaseCollectBean.setFile_cache(appCacheData);
                } catch (Exception e) {
                    foxBaseCollectBean.setFile_cache(new ArrayList<FoxBaseFileBean>());
                }
            }
            if (!mUnCollect.contains("oaid")) {
                try {
                    foxBaseCollectBean.setOaid(FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_APP_OAID, ""));
                } catch (Exception e) {
                    foxBaseCollectBean.setOaid("");
                }
            }
            if (!mUnCollect.contains("wifi_name")) {
                try {
                    foxBaseCollectBean.setWifi_name(getWifiInfo());
                } catch (Exception e) {
                    foxBaseCollectBean.setWifi_name("");
                }
            }
            if (!mUnCollect.contains("wifi_list")) {
                try {
                    foxBaseCollectBean.setWifi_list(getWifiList());
                } catch (Exception e) {
                    foxBaseCollectBean.setWifi_list(new ArrayList<FoxBaseWifiInfoBean>());
                }
            }
            if (!mUnCollect.contains("basestation_id")) {
                try {
                    foxBaseCollectBean.setBasestation_id(getLacInfo());
                } catch (Exception e) {
                    foxBaseCollectBean.setBasestation_id("");
                }
            }
            if (!mUnCollect.contains("rom_capacity")) {
                try {
                    foxBaseCollectBean.setRom_capacity(getStorageValue() + "kb");
                } catch (Exception e) {
                    foxBaseCollectBean.setRom_capacity("");
                }
            }
            if (!mUnCollect.contains("available_rom")) {
                try {
                    foxBaseCollectBean.setAvailable_rom(getFreeStorageValue() + "kb");
                } catch (Exception e) {
                    foxBaseCollectBean.setAvailable_rom("");
                }
            }
            if (!mUnCollect.contains("is_root")) {
                try {
                    foxBaseCollectBean.setIs_root(isDeviceRooted() ? "1" : "0");
                } catch (Exception e) {
                    foxBaseCollectBean.setIs_root("");
                }
            }

            //双卡数据
            if (!mUnCollect.contains("num_cardslot")) {
                try {
                    foxBaseCollectBean.setNum_cardslot(FoxPhoneStateUtil.getSimCount());
                } catch (Exception e) {
                    foxBaseCollectBean.setNum_cardslot("");
                }
            }
            if (!mUnCollect.contains("num_cardsim")) {
                try {
                    foxBaseCollectBean.setNum_cardsim(FoxPhoneStateUtil.getUsedSimCount());
                } catch (Exception e) {
                    foxBaseCollectBean.setNum_cardsim("");
                }
            }
            if (!mUnCollect.contains("imei2")) {
                try {
                    int mSimId = FoxPhoneStateUtil.getMasterSimId();
                    foxBaseCollectBean.setImei2(FoxPhoneStateUtil.getDeviced(mSimId <= 0 ? 1 : 0));
                } catch (Exception e) {
                    foxBaseCollectBean.setImei2("");
                }
            }
            if (!mUnCollect.contains("tcid")) {
                try {
                    String tcid = getTcid();
                    foxBaseCollectBean.setTcid(tcid);
                } catch (Exception e) {
                    foxBaseCollectBean.setTcid("");
                }
            }
            //追加数据采集
            supplyPlusInfo(context, foxBaseCollectBean, mUnCollect);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return Base64.encodeToString(FoxBaseGZipUtil.compress(FoxBaseGsonUtil.GsonString(foxBaseCollectBean), FoxBaseGZipUtil.GZIP_ENCODE_UTF_8), Base64.NO_WRAP);
    }


    /**
     * MD
     * imei  device_id  api_version  advert_like_type longitude latitude os page_title nt apps  apps_active_list
     *
     * @return
     */
    public static String getCrashData(Context context, int dataFrom, String mConfigData, String
            appkey, String crashLog, String dataType, boolean isError) {
        FoxBaseCrashBean foxBaseCrashBean = new FoxBaseCrashBean();
        foxBaseCrashBean.setOs_type("Android");
        foxBaseCrashBean.setData_type(dataType + "");
        foxBaseCrashBean.setData1(mConfigData + "");
        foxBaseCrashBean.setData_from(dataFrom + "");
        foxBaseCrashBean.setTime(System.currentTimeMillis() + "");
        foxBaseCrashBean.setApp_key(appkey + "");
        try {
            foxBaseCrashBean.setOs_version(Build.VERSION.RELEASE + "");
            foxBaseCrashBean.setPhone_model(getModel() + "");
            foxBaseCrashBean.setPhone_brand(Build.MANUFACTURER + "");
            foxBaseCrashBean.setPackage_name(context != null ? context.getPackageName() : "");
            foxBaseCrashBean.setSdk_version(BuildConfig.VERSION_NAME + "");
            foxBaseCrashBean.setImei(getIMEI() + "");
            foxBaseCrashBean.setDevice_id(getIMEI() + "");
            if (getNetworkType() == NetworkType.NETWORK_2G) {
                foxBaseCrashBean.setNet_type("2G");
            } else if (getNetworkType() == NetworkType.NETWORK_3G) {
                foxBaseCrashBean.setNet_type("3G");
            } else if (getNetworkType() == NetworkType.NETWORK_4G) {
                foxBaseCrashBean.setNet_type("4G");
            } else if (getNetworkType() == NetworkType.NETWORK_WIFI) {
                foxBaseCrashBean.setNet_type("wifi");
            } else if (getNetworkType() == NetworkType.NETWORK_5G) {
                foxBaseCrashBean.setNet_type("5G");
            }
            foxBaseCrashBean.setCrash_logs(crashLog + "");
            foxBaseCrashBean.setOaid(FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_APP_OAID, "") + "");
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (dataType.equals("1")) {
            String onTime = FoxBaseSPUtils.getInstance().getString(FoxTimeRecordTask.LAST_ON_TIME, "");
            String offTime = FoxBaseSPUtils.getInstance().getString(FoxTimeRecordTask.LAST_OFF_TIME, "");
            foxBaseCrashBean.setLast_on_time(onTime);
            foxBaseCrashBean.setLast_off_time(offTime);
        }

        //数据匹配
        boolean is_empower = false;
        try {
            is_empower = ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED;
        } catch (Exception e) {
            e.printStackTrace();
        }
        foxBaseCrashBean.setIs_empower(is_empower ? "1" : "0");
        String tcid = getTcid();
        foxBaseCrashBean.setTcid(tcid);
        foxBaseCrashBean.setPatchVersion(FoxBaseSPUtils.getInstance().getString(LOCAL_PATCH_VERSION,""));
        foxBaseCrashBean.setPatchCode(FoxBaseSPUtils.getInstance().getLong(LOCAL_PATCH_CODE,0l) + "");

        if (isError){
            foxBaseCrashBean.setCrashType("3");
        }else if (dataType.equals("2")){
            foxBaseCrashBean.setCrashType(FoxBaseCacheUtils.readString(FoxBaseConstants.KEY_TUIA_SDK_CRASH_INFO_TYPE));
        }

        return Base64.encodeToString(FoxBaseGZipUtil.compress(FoxBaseGsonUtil.GsonString(foxBaseCrashBean), FoxBaseGZipUtil.GZIP_ENCODE_UTF_8), Base64.NO_WRAP);
    }

    /**
     * 获取手机总内存大小
     */
    public static long getStorageValue() {
        long TotalBlocks = 0;
        try {
            FoxBaseSDCardInfo mSDCardInfo = getSDCardInfo();
            FoxBaseSDCardInfo mSystemInfo = getSystemSpaceInfo();
            if (mSDCardInfo != null) {
                TotalBlocks = (mSDCardInfo.total + mSystemInfo.total) / 1024;
            } else {
                TotalBlocks = mSystemInfo.total / 1024;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return TotalBlocks;
    }

    /**
     * 获取手机剩余内存大小
     */
    public static long getFreeStorageValue() {
        long mFreeBlocks = 0;
        try {
            FoxBaseSDCardInfo mSDCardInfo = getSDCardInfo();
            FoxBaseSDCardInfo mSystemInfo = getSystemSpaceInfo();
            if (mSDCardInfo != null) {
                mFreeBlocks = (mSDCardInfo.free + mSystemInfo.free) / 1024;
            } else {
                mFreeBlocks = mSystemInfo.free / 1024;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return mFreeBlocks;
    }

    /**
     * 获取SD卡信息
     *
     * @return
     */
    public static FoxBaseSDCardInfo getSDCardInfo() {
        try {
            if (Environment.isExternalStorageRemovable()) {
                String sDcString = Environment.getExternalStorageState();
                if (sDcString.equals(Environment.MEDIA_MOUNTED)) {
                    File pathFile = Environment.getExternalStorageDirectory();
                    try {
                        StatFs statfs = new StatFs(pathFile.getPath());
                        // 获取SDCard上BLOCK总数
                        long nTotalBlocks = statfs.getBlockCount();
                        // 获取SDCard上每个block的SIZE
                        long nBlocSize = statfs.getBlockSize();
                        // 获取可供程序使用的Block的数量
                        long nAvailaBlock = statfs.getAvailableBlocks();
                        // 获取剩下的所有Block的数量(包括预留的一般程序无法使用的块)
                        long nFreeBlock = statfs.getFreeBlocks();
                        FoxBaseSDCardInfo info = new FoxBaseSDCardInfo();
                        // 计算SDCard 总容量大小MB
                        info.total = nTotalBlocks * nBlocSize;
                        // 计算 SDCard 剩余大小MB
                        info.free = nAvailaBlock * nBlocSize;
                        return info;
                    } catch (IllegalArgumentException e) {
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取系统内存信息
     *
     * @return
     */
    public static FoxBaseSDCardInfo getSystemSpaceInfo() {
        FoxBaseSDCardInfo info = new FoxBaseSDCardInfo();
        try {
            File path = Environment.getDataDirectory();
            StatFs stat = new StatFs(path.getPath());
            long blockSize = stat.getBlockSize();
            long totalBlocks = stat.getBlockCount();
            long availableBlocks = stat.getAvailableBlocks();
            long totalSize = blockSize * totalBlocks;
            long availSize = availableBlocks * blockSize;
            info.total = totalSize;
            info.free = availSize;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }

    /**
     * getCellInfo
     * MCC，Mobile Country Code，移动国家代码（中国的为460）；
     * MNC，Mobile Network Code，移动网络号码（中国移动为0，中国联通为1，中国电信为2）； 
     * LAC，Location Area Code， 位置区域码；
     * CID，Cell Identity，基站编号；
     */
    public static String getLacInfo() {
        String mLac = "";
        try {
            // 获取邻区基站信息
            if (ActivityCompat.checkSelfPermission(FoxBaseUtils.getApp(), Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                return mLac;
            }
            TelephonyManager mTelephonyManager = (TelephonyManager) FoxBaseUtils.getApp().getSystemService(Context.TELEPHONY_SERVICE);
            if (null == mTelephonyManager) {
                return mLac;
            }
            // 返回值MCC + MNC
//            String operator = mTelephonyManager.getNetworkOperator();
//            int mcc = Integer.parseInt(operator.substring(0, 3));
//            int mnc = Integer.parseInt(operator.substring(3));
            // 中国移动和中国联通获取LAC、CID的方式
            if (mTelephonyManager.getPhoneType() == TelephonyManager.PHONE_TYPE_CDMA) {
                CdmaCellLocation location1 = (CdmaCellLocation) mTelephonyManager.getCellLocation();
                if (null != location1) mLac = String.valueOf(location1.getNetworkId());
            } else {
                GsmCellLocation location = (GsmCellLocation) mTelephonyManager.getCellLocation();
                if (null != location) mLac = String.valueOf(location.getLac());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return mLac;
    }

    public static String getWifiInfo() {
        String wifiId = "-1";
        try {
            if (getNetworkType() == NetworkType.NETWORK_WIFI) {
                WifiManager wifiMgr = (WifiManager) FoxBaseUtils.getApp().getApplicationContext().getSystemService(WIFI_SERVICE);
                WifiInfo info = wifiMgr.getConnectionInfo();
                wifiId = info != null ? info.getSSID() : "-1";
            } else {
                wifiId = "1";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return wifiId;
    }

    /**
     * get wifilist
     *
     * @return2
     */
    public static List<FoxBaseWifiInfoBean> getWifiList() {
        List<FoxBaseWifiInfoBean> wifiList = new ArrayList<>();
        try {
            WifiManager wifiManager = (WifiManager) FoxBaseUtils.getApp().getApplicationContext()
                    .getSystemService(WIFI_SERVICE);
            List<ScanResult> scanWifiList = wifiManager.getScanResults();
            if (scanWifiList != null && scanWifiList.size() > 0) {
                HashMap<String, Integer> signalStrength = new HashMap<String, Integer>();
                for (int i = 0; i < scanWifiList.size(); i++) {
                    ScanResult scanResult = scanWifiList.get(i);
                    if (!scanResult.SSID.isEmpty()) {
                        String key = scanResult.SSID + "---" + scanResult.capabilities;
                        if (!signalStrength.containsKey(key)) {
                            signalStrength.put(key, i);
                            wifiList.add(new FoxBaseWifiInfoBean(scanResult.SSID, scanResult.BSSID, scanResult.capabilities, scanResult.level));
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return wifiList;
    }


    /**
     * Return whether device is rooted.
     *
     * @return {@code true}: yes<br>{@code false}: no
     */
    public static boolean isDeviceRooted() {
        try {
            String su = "su";
            String[] locations = {"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/",
                    "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/",
                    "/system/sbin/", "/usr/bin/", "/vendor/bin/"};
            for (String location : locations) {
                if (new File(location + su).exists()) {
                    return true;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }


    /**
     * 可用于 确定唯一设备   32 位 (该设备号有可能有一定几率重复，但是概率很小)
     *
     * @param context
     * @return 32位字符串（大写）
     */
    public static String getPesudoDeviceId(Context context) {
        String deviceId = "";
        if (FoxBaseCommonUtils.isEmpty(deviceId)) {
            String m_szLongID = getPesudoIMEI() + getAndroidId(context);
            MessageDigest m = null;
            try {
                m = MessageDigest.getInstance("MD5");
            } catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            m.update(m_szLongID.getBytes(), 0, m_szLongID.length());
            byte p_md5Data[] = m.digest();
            String m_szUniqueID = new String();
            for (int i = 0; i < p_md5Data.length; i++) {
                int b = (0xFF & p_md5Data[i]);
                if (b <= 0xF)
                    m_szUniqueID += "0";
                m_szUniqueID += Integer.toHexString(b);
            }
            deviceId = m_szUniqueID.toUpperCase(Locale.getDefault());
        } else {

        }
        return deviceId;
    }

    /**
     * 判断列表是否为空
     *
     * @param list
     * @return
     */
    public static <T> boolean isEmpty(List<T> list) {
        if (list != null && list.size() > 0) {
            return false;
        }
        return true;
    }

    /**
     * 判断字符串是否为空
     *
     * @param s
     * @return
     */
    public static boolean isEmpty(String s) {
        return TextUtils.isEmpty(s);
    }

    public static String getDefaultSaveRootPath() {
        if (FoxBaseSDK.getContext().getExternalCacheDir() == null) {
            return Environment.getDownloadCacheDirectory().getAbsolutePath();
        } else {
            //noinspection ConstantConditions
            return FoxBaseSDK.getContext().getExternalCacheDir().getAbsolutePath();
        }
    }


    /**
     * 获取缓存路径
     *
     * @return
     */
    public static String getDownLoadPath(String appPackageName) {
        if (!TextUtils.isEmpty(appPackageName)) {
            return getDefaultSaveRootPath() + File.separator + "magic" + File.separator + "tmpdir" + File.separator + appPackageName + File.separator;
        } else {
            return getDefaultSaveRootPath() + File.separator + "magic" + File.separator + "tmpdir" + File.separator;
        }
    }


    /**
     * Return the applications' information.
     *
     * @return the applications' information
     */
    public static List<FoxBaseAppInfo> getAppsInfo() {
        List<FoxBaseAppInfo> list = new ArrayList<>();
        try {
            PackageManager pm = FoxBaseSDK.getContext().getPackageManager();
            List<PackageInfo> installedPackages = pm.getInstalledPackages(0);
            for (PackageInfo pi : installedPackages) {
                if (pi != null) {
                    boolean isSystem = (ApplicationInfo.FLAG_SYSTEM & pi.applicationInfo.flags) != 0;
                    if (!isSystem) {
                        FoxBaseAppInfo ai = getBean(pm, pi);
                        if (ai == null) {
                            continue;
                        }
                        list.add(ai);
                    }
                }
            }
        } catch (Exception e) {
        }
        return list;
    }

    private static FoxBaseAppInfo getBean(final PackageManager pm, final PackageInfo pi) {
        try {
            if (pm == null || pi == null) {
                return null;
            }
            ApplicationInfo ai = pi.applicationInfo;
            String packageName = pi.packageName;
            String name = ai.loadLabel(pm).toString();
            String packagePath = ai.sourceDir;
            String versionName = pi.versionName;
            int versionCode = pi.versionCode;
            boolean isSystem = (ApplicationInfo.FLAG_SYSTEM & ai.flags) != 0;
            return new FoxBaseAppInfo(packageName, name, packagePath, versionName, versionCode, isSystem);
        } catch (Exception e) {
        }
        return null;
    }

    /**
     * Return the android id of device.
     *
     * @return the android id of device
     */
    @SuppressLint("HardwareIds")
    public static String getAndroidID() {
        String id = "";
        try {
            id = Settings.Secure.getString(
                    FoxBaseSDK.getContext().getContentResolver(),
                    Settings.Secure.ANDROID_ID
            );
        } catch (Exception e) {
            e.printStackTrace();
        }
        if ("9774d56d682e549c".equals(id)) return "";
        return id == null ? "" : id;
    }

    /**
     * Return the application's name.
     *
     * @return the application's name
     */
    public static String getAppName() {
        String appName = "";
        try {
            appName = getAppName(FoxBaseSDK.getContext().getPackageName());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return appName;
    }

    /**
     * Return the application's name.
     *
     * @param packageName The name of the package.
     * @return the application's name
     */
    public static String getAppName(final String packageName) {
        if (isSpace(packageName)) return "";
        try {
            PackageManager pm = FoxBaseSDK.getContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadLabel(pm).toString();
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static boolean isSpace(final String s) {
        if (s == null) return true;
        for (int i = 0, len = s.length(); i < len; ++i) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
        }
        return true;
    }

    /**
     * 获取系统应用列表的包名
     * 并将包名按照字典顺序排列，用英文逗号","隔开
     *
     * @return String
     */
    public static String getAppList() {
        String strWithDComma = "";
        try {
            StringBuilder sb = new StringBuilder();
            final List<FoxBaseAppInfo> appsInfo = getAppsInfo();
            for (FoxBaseAppInfo appInfo :
                    appsInfo) {
                if (!appInfo.isSystem()) {
                    sb.append(appInfo.getPackageName());
                    sb.append(",");
                }
            }
            strWithDComma = sb.toString();
            if (strWithDComma.endsWith(",")) {
                return strWithDComma.substring(0, strWithDComma.lastIndexOf(","));
            }
        } catch (Exception e) {
        }
        return strWithDComma;
    }


    /**
     * 检测下载文件存在与否
     *
     * @return
     */
    public static File checkFileExit(String packageName, String appName) {
        File file = null;
        try {
            if (!TextUtils.isEmpty(packageName)) {
                final List<File> files = FoxBaseCommonUtils.listFileSortByModifyTime(FoxBaseCommonUtils.getDownLoadPath(packageName));
                if (files != null && files.size() != 0) {
                    for (File f : files) {
                        if ((appName.equals(f.getName()))) {
                            file = f;
                        }
                    }
                }
            }
        } catch (Exception e) {
        }
        return file;
    }


    /**
     * 获取目录下所有文件(按时间排序)
     *
     * @param path
     * @return
     */
    public static List<File> listFileSortByModifyTime(String path) {
        List<File> list = getFiles(path, new ArrayList<File>());
        if (list != null && list.size() > 0) {
            Collections.sort(list, new Comparator<File>() {
                @Override
                public int compare(File file, File newFile) {
                    if (file.lastModified() < newFile.lastModified()) {
                        return -1;
                    } else if (file.lastModified() == newFile.lastModified()) {
                        return 0;
                    } else {
                        return 1;
                    }
                }
            });
        }
        return list;
    }

    /**
     * 获取目录下所有文件
     *
     * @param realpath
     * @param files
     * @return
     */
    public static List<File> getFiles(String realpath, List<File> files) {
        File realFile = new File(realpath);
        if (realFile.isDirectory()) {
            File[] subfiles = realFile.listFiles();
            for (File file : subfiles) {
                if (file.isDirectory()) {
                    getFiles(file.getAbsolutePath(), files);
                } else {
                    files.add(file);
                }
            }
        }
        return files;

    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        if (context == null) {
            return null;
        }
        WindowManager windowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        if (windowManager != null) {
            DisplayMetrics outMetrics = new DisplayMetrics();
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                windowManager.getDefaultDisplay().getRealMetrics(outMetrics);
                return outMetrics;
            } else {
                return null;
            }
//            int widthPixels = outMetrics.widthPixels;
//            int heightPixels = outMetrics.heightPixels;
//            int densityDpi = outMetrics.densityDpi;
//            float density = outMetrics.density;
//            float scaledDensity = outMetrics.scaledDensity;
            //可用显示大小的绝对宽度（以像素为单位）。
            //可用显示大小的绝对高度（以像素为单位）。
            //屏幕密度表示为每英寸点数。
            //显示器的逻辑密度。
            //显示屏上显示的字体缩放系数。
        }
        return null;
    }

    /**
     * 获取屏幕真实像素
     *
     * @param context
     * @return
     */
    public static String getPixels(Context context) {
        String pixels = "";
        try{
            DisplayMetrics displayMetrics = getDisplayMetrics(context);
            if (displayMetrics != null) {
                pixels = displayMetrics.widthPixels + "*" + displayMetrics.heightPixels;
            }
        } catch (Exception e){
            e.printStackTrace();
        }
        return pixels;
    }

    /**
     * 获取屏幕密度
     *
     * @param context
     * @return
     */
    public static String getScreenDensityDpi(Context context) {
        String densityDpi = "";
        try {
            DisplayMetrics displayMetrics = getDisplayMetrics(context);
            if (displayMetrics != null) {
                densityDpi = String.valueOf(displayMetrics.densityDpi);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return densityDpi;
    }

    /**
     * 获取CPU核心数
     *
     * @return
     */
    public static int getCPUCoreCount() {
        int cpuCount = 0;
        try {
            cpuCount = Runtime.getRuntime().availableProcessors();
        }catch (Exception e){
            e.printStackTrace();
        }
        return cpuCount;
    }

    /**
     * 获取当前手机系统语言。
     *
     * @return 返回当前系统语言。例如：当前设置的是“中文-中国”，则返回“zh-CN”
     */
    public static String getSystemLanguage() {
        String language = "";
        try {
            language = Locale.getDefault().getLanguage();
        }catch (Exception e){
            e.printStackTrace();
        }
        return language;
    }

    /**
     * 获取CPU最大频率
     *
     * @return
     */
    public static String getMaxCPU() {
        String MaxPath = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq";//保存CPU可运行最大频率
        String result = "";
        try {
            float frequency = 0;
            FileReader fr = null;
            BufferedReader br = null;
            try {
                fr = new FileReader(MaxPath);
                br = new BufferedReader(fr);
                String text = br.readLine();
                frequency = Float.parseFloat(text.trim());
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (fr != null)
                    try {
                        fr.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                if (br != null)
                    try {
                        br.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
            }
            if (frequency != 0) {
                result = frequency / (1000000.0) + "GHz";
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        return result;
    }

    /**
     * 获取网络子类型
     *
     * @return
     */
    public static String getNetWorkSubType() {
        if (isEthernet()) {
            return "ETHERNET";
        }
        if (ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.ACCESS_NETWORK_STATE) == PackageManager.PERMISSION_GRANTED) {
            NetworkInfo info = getActiveNetworkInfo();
            if (info != null && info.isAvailable()) {
                if (info.getType() == ConnectivityManager.TYPE_WIFI) {
                    return "WIFI";
                } else if (info.getType() == ConnectivityManager.TYPE_MOBILE) {
                    switch (info.getSubtype()) {
                        case TelephonyManager.NETWORK_TYPE_GSM:
                            return "GSM";
                        case TelephonyManager.NETWORK_TYPE_GPRS:
                            return "GPRS";
                        case TelephonyManager.NETWORK_TYPE_CDMA:
                            return "CDMA";
                        case TelephonyManager.NETWORK_TYPE_EDGE:
                            return "EDGE";
                        case TelephonyManager.NETWORK_TYPE_1xRTT:
                            return "1xRTT";
                        case TelephonyManager.NETWORK_TYPE_IDEN:
                            return "IDEN";
                        case TelephonyManager.NETWORK_TYPE_TD_SCDMA:
                            return "TD_SCDMA";
                        case TelephonyManager.NETWORK_TYPE_EVDO_A:
                            return "EVDO_A";
                        case TelephonyManager.NETWORK_TYPE_UMTS:
                            return "UMTS";
                        case TelephonyManager.NETWORK_TYPE_EVDO_0:
                            return "EVDO_0";
                        case TelephonyManager.NETWORK_TYPE_HSDPA:
                            return "HSDPA";
                        case TelephonyManager.NETWORK_TYPE_HSUPA:
                            return "HSUPA";
                        case TelephonyManager.NETWORK_TYPE_HSPA:
                            return "HSPA";
                        case TelephonyManager.NETWORK_TYPE_EVDO_B:
                            return "EVDO_B";
                        case TelephonyManager.NETWORK_TYPE_EHRPD:
                            return "EHRPD";
                        case TelephonyManager.NETWORK_TYPE_HSPAP:
                            return "HSPAP";
                        case TelephonyManager.NETWORK_TYPE_IWLAN:
                            return "IWLAN";
                        case TelephonyManager.NETWORK_TYPE_LTE:
                            return "LTE";

                        default:
                            String subtypeName = info.getSubtypeName();
                            return isEmpty(subtypeName) ? "UNKNOW" : subtypeName;
                    }
                }
            }
        }
        return "UNKNOW";
    }

    /**
     * 获取截止目前的上传数据总量（单位：KB）
     *
     * @return
     */
    public static long getTotalUploadBytes() {
        long totalTxBytes = 0l;
        try {
            totalTxBytes = TrafficStats.getTotalTxBytes() / 1024;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return totalTxBytes;
    }

    /**
     * 获取截止目前的下载数据总量（单位：KB）
     *
     * @return
     */
    public static long getTotalDownloadBytes() {
        long totalRxBytes = 0l;
        try {
            totalRxBytes = TrafficStats.getTotalRxBytes() / 1024;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return totalRxBytes;
    }

    /**
     * 获取应用版本名
     *
     * @return
     */
    public static String getAppVersionName() {
        String versionName = "";
        try {
            PackageManager pm = FoxBaseSDK.getContext().getPackageManager();
            versionName = pm.getPackageInfo(FoxBaseSDK.getContext().getPackageName(), 0).versionName;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return versionName;
    }

    /**
     * 获取应用版本号
     *
     * @return
     */
    public static String getAppVersionCode() {
        String versionCode = "";
        try {
            PackageManager pm = FoxBaseSDK.getContext().getPackageManager();
            versionCode = String.valueOf(pm.getPackageInfo(FoxBaseSDK.getContext().getPackageName(), 0).versionCode);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return versionCode;
    }

    /**
     * 获取应用安装路径
     *
     * @return
     */
    public static String getAppInstallPath() {
        String path = "";
        try {
            path = FoxBaseSDK.getContext().getPackageResourcePath();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    /**
     * 获取设备产品名
     *
     * @return
     */
    public static String getCPU_ABI() {
        return Build.CPU_ABI;
    }

    /**
     * 获取系统ROM名
     *
     * @return
     */
    public static String getSystemRomName() {
        return Build.FINGERPRINT;
    }

    /**
     * 获取系统用户名
     *
     * @return
     */
    public static String getSystemUserName() {
        return Build.USER;
    }

    public static void supplyPlusInfo(Context context, FoxBaseCollectBean foxBaseCollectBean, String unCollect) {
        if (foxBaseCollectBean == null) {
            return;
        }
        if (unCollect == null) {
            unCollect = "";
        }
        try {
            if (!unCollect.contains("screen_resolution")) {
                //屏幕分辨率
                try {
                    foxBaseCollectBean.setScreen_resolution(FoxBaseCommonUtils.getPixels(context));
                } catch (Exception e) {
                    foxBaseCollectBean.setScreen_resolution("");
                }
            }
            if (!unCollect.contains("screen_ppi")) {
                //屏幕密度
                try {
                    foxBaseCollectBean.setScreen_ppi(FoxBaseCommonUtils.getScreenDensityDpi(context));
                } catch (Exception e) {
                    foxBaseCollectBean.setScreen_ppi("");
                }
            }
            if (!unCollect.contains("cpu_core_number")) {
                //CPU核心数
                try {
                    foxBaseCollectBean.setCpu_core_number(String.valueOf(FoxBaseCommonUtils.getCPUCoreCount()));
                } catch (Exception e) {
                    foxBaseCollectBean.setCpu_core_number("");
                }
            }
            if (!unCollect.contains("cpu_frequency")) {
                //CPU频率
                try {
                    foxBaseCollectBean.setCpu_frequency(FoxBaseCommonUtils.getMaxCPU());
                } catch (Exception e) {
                    foxBaseCollectBean.setCpu_frequency("");
                }
            }
            if (!unCollect.contains("imsi")) {
                try {
                    foxBaseCollectBean.setImsi(FoxBaseCommonUtils.getIMSI());
                } catch (Exception e) {
                    foxBaseCollectBean.setImsi("");
                }
            }
            if (!unCollect.contains("device_name")) {
                //设备产品名
                try {
                    foxBaseCollectBean.setDevice_name(FoxBaseCommonUtils.getCPU_ABI());
                } catch (Exception e) {
                    foxBaseCollectBean.setDevice_name("");
                }
            }
            if (!unCollect.contains("system_rom_name")) {
                //系统ROM名
                try {
                    foxBaseCollectBean.setSystem_rom_name(FoxBaseCommonUtils.getSystemRomName());
                } catch (Exception e) {
                    foxBaseCollectBean.setSystem_rom_name("");
                }
            }
            if (!unCollect.contains("system_user_name")) {
                //系统用户名
                try {
                    foxBaseCollectBean.setSystem_user_name(FoxBaseCommonUtils.getSystemUserName());
                } catch (Exception e) {
                    foxBaseCollectBean.setSystem_user_name("");
                }
            }
            if (!unCollect.contains("net_subtype")) {
                //网络子类型
                try {
                    foxBaseCollectBean.setNet_subtype(FoxBaseCommonUtils.getNetWorkSubType());
                } catch (Exception e) {
                    foxBaseCollectBean.setNet_subtype("");
                }
            }
            if (!unCollect.contains("system_language")) {
                //语言设置
                try {
                    foxBaseCollectBean.setSystem_language(FoxBaseCommonUtils.getSystemLanguage());
                } catch (Exception e) {
                    foxBaseCollectBean.setSystem_language("");
                }
            }
            if (!unCollect.contains("app_path")) {
                //应用安装路径
                try {
                    foxBaseCollectBean.setApp_path(FoxBaseCommonUtils.getAppInstallPath());
                } catch (Exception e) {
                    foxBaseCollectBean.setApp_path("");
                }
            }
            if (!unCollect.contains("android_id")) {
                //AndroidId
                try {
                    foxBaseCollectBean.setAndroid_id(FoxBaseCommonUtils.getAndroidID());
                } catch (Exception e) {
                    foxBaseCollectBean.setAndroid_id("");
                }
            }
            if (!unCollect.contains("app_version_name")) {
                //应用版本名称
                try {
                    foxBaseCollectBean.setApp_version_name(FoxBaseCommonUtils.getAppVersionName());
                } catch (Exception e) {
                    foxBaseCollectBean.setApp_version_name("");
                }
            }
            if (!unCollect.contains("app_version_code")) {
                //应用版本号
                try {
                    foxBaseCollectBean.setApp_version_code(FoxBaseCommonUtils.getAppVersionCode());
                } catch (Exception e) {
                    foxBaseCollectBean.setApp_version_code("");
                }
            }
            if (!unCollect.contains("app_name")) {
                //应用名称
                try {
                    foxBaseCollectBean.setApp_name(FoxBaseCommonUtils.getAppName());
                } catch (Exception e) {
                    foxBaseCollectBean.setApp_name("");
                }
            }
            if (!unCollect.contains("net_up_flow") || !unCollect.contains("net_down_flow")) {
                long upload = FoxBaseCommonUtils.getTotalUploadBytes();
                long download = FoxBaseCommonUtils.getTotalDownloadBytes();
                try {
                    Thread.sleep(999);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!unCollect.contains("net_up_flow")) {
                    //最新上传流量
                    foxBaseCollectBean.setNet_up_flow((FoxBaseCommonUtils.getTotalUploadBytes() - upload) + "KB/s");
                }
                if (!unCollect.contains("net_down_flow")) {
                    //最新下载流量
                    foxBaseCollectBean.setNet_down_flow((FoxBaseCommonUtils.getTotalDownloadBytes() - download) + "KB/s");
                }
            }
            if (!unCollect.contains("is_emulator")) {
                try {
                    String is_emulator = FoxBaseCommonUtils.isEmulator(FoxBaseSDK.getContext()) ? "1," : "0,";
                    is_emulator += FoxBaseCommonUtils.isXposedExists() ? "2" : "";
                    foxBaseCollectBean.setIs_emulator(is_emulator);
                } catch (Exception e) {
                    foxBaseCollectBean.setIs_emulator("");
                }
            }
            if (!unCollect.contains("is_empower")) {
                try {
                    boolean is_empower = false;
                    try {
                        is_empower = ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED;
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    foxBaseCollectBean.setIs_empower(is_empower ? "1" : "0");
                } catch (Exception e) {
                    foxBaseCollectBean.setIs_empower("");
                }
            }
        }catch (Exception ignored){}

    }

    public static String listToString(List<String> arr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.size(); i++) {
            if (i == arr.size() - 1) {
                sb.append(arr.get(i));
            } else {
                sb.append(arr.get(i) + ",");
            }
        }
        return sb.toString();
    }

    /**
     * 判断当前进程是否在后台
     *
     * @param context
     * @return
     */
    public static boolean isBackground(Context context) {
        if (context == null) {
            return true;
        }
        try {
            ActivityManager activityManager = (ActivityManager) context
                    .getSystemService(Context.ACTIVITY_SERVICE);
            List<ActivityManager.RunningAppProcessInfo> appProcesses = activityManager
                    .getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                if (appProcess.processName.equals(context.getPackageName())) {
                    /*
                    BACKGROUND=400 EMPTY=500 FOREGROUND=100
                    GONE=1000 PERCEPTIBLE=130 SERVICE=300 ISIBLE=200
                     */
                    if (appProcess.importance != ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND) {
                        //在后台
                        return true;
                    } else {
                        //在前台
                        return false;
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    /**
     * 获取AppKey
     *
     * @return
     */
    public static String getAppKey() {
        String appKey = null;
        try {
            ApplicationInfo info = FoxBaseSDK.getApplicationInfo();
            appKey = "";
            if (info == null) {
                try {
                    info = FoxBaseSDK.getContext().getPackageManager().getApplicationInfo(FoxBaseSDK.getContext().getPackageName(), PackageManager.GET_META_DATA);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (info != null && info.metaData != null) {
                appKey = info.metaData.getString(FoxBaseConstants.KEY_TUIA_APPKEY, "").trim();
                if (isEmpty(appKey)) {
                    appKey = info.metaData.getString(FoxBaseConstants.KEY_PRO_APPKEY, "").trim();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return appKey;
    }

    /**
     * 获取AppSecret
     *
     * @return
     */
    public static String getAppSecret() {
        String appSecret = null;
        try {
            ApplicationInfo info = FoxBaseSDK.getApplicationInfo();
            appSecret = "";
            if (info == null) {
                try {
                    info = FoxBaseSDK.getContext().getPackageManager().getApplicationInfo(FoxBaseSDK.getContext().getPackageName(), PackageManager.GET_META_DATA);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (info != null && info.metaData != null) {
                appSecret = info.metaData.getString(FoxBaseConstants.KEY_TUIA_APPSECRET, "").trim();
                if (isEmpty(appSecret)) {
                    appSecret = info.metaData.getString(FoxBaseConstants.KEY_PRO_APPSECRET, "").trim();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return appSecret;
    }

    public static String getABTestType() {
        String testType = "def";
        try {
            final String configData = FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_CONFIG, "");
            FoxBaseSDKConfigBean.DataBean sdkConfigBean = FoxBaseGsonUtil.GsonToBean(configData, FoxBaseSDKConfigBean.DataBean.class);
            if (null != sdkConfigBean) {
                if (sdkConfigBean.getShowType() == 1) {
                    testType = "a";
                } else if (sdkConfigBean.getShowType() == 2) {
                    testType = "b";
                }
            }
        } catch (Exception ignored) {
        }
        return testType;
    }

    /**
     * 是否有光线传感器
     *
     * @param context
     * @return
     */
    public static Boolean isLightSensorManager(Context context) {
        SensorManager sensorManager = (SensorManager) context.getSystemService(SENSOR_SERVICE);
        Sensor sensor8 = sensorManager.getDefaultSensor(Sensor.TYPE_LIGHT); //光
        if (null == sensor8) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * 是否是模拟器
     *
     * @return
     */
    public static boolean isEmulator(Context context) {
        boolean isEmulator = false;
        try {
            isEmulator = Build.FINGERPRINT.startsWith("generic")
                    || Build.FINGERPRINT.toLowerCase().contains("vbox")
                    || Build.FINGERPRINT.toLowerCase().contains("test-keys")
                    || Build.MODEL.contains("google_sdk")
                    || Build.MODEL.contains("Emulator")
                    || Build.MODEL.contains("Android SDK built for x86")
                    || Build.MANUFACTURER.contains("Genymotion")
                    || (Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic"))
                    || "google_sdk".equals(Build.PRODUCT)
                    || ((TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE))
                    .getNetworkOperatorName().toLowerCase().equals("android")
                    || ((TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE))
                    .getNetworkOperatorName().toLowerCase().contains("china")
                    || ((TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE))
                    .getNetworkOperatorName().toLowerCase().contains("cmcc")
                    || !isLightSensorManager(context);
        } catch (Exception ignored) {
        }

        return isEmulator;
    }

    private static final String XPOSED_HELPERS = "de.robv.android.xposed.XposedHelpers";
    private static final String XPOSED_BRIDGE = "de.robv.android.xposed.XposedBridge";

    //手动抛出异常，检查堆栈信息是否有xp框架包
    public static boolean isEposedExistByThrow() {
        try {
            throw new Exception("gg");
        } catch (Exception e) {
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                if (stackTraceElement.getClassName().contains(XPOSED_BRIDGE)) return true;
            }
            return false;
        }
    }

    //检查xposed包是否存在
    public static boolean isXposedExists() {
        try {
            Object xpHelperObj = ClassLoader
                    .getSystemClassLoader()
                    .loadClass(XPOSED_HELPERS)
                    .newInstance();
        } catch (InstantiationException e) {
            return true;
        } catch (IllegalAccessException e) {
            //实测debug跑到这里报异常
            return true;
        } catch (ClassNotFoundException e) {
            return false;
        } catch (Exception e) {
            return false;
        }

        try {
            Object xpBridgeObj = ClassLoader
                    .getSystemClassLoader()
                    .loadClass(XPOSED_BRIDGE)
                    .newInstance();
        } catch (InstantiationException e) {
            return true;
        } catch (IllegalAccessException e) {
            //实测debug跑到这里报异常
            return true;
        } catch (ClassNotFoundException e) {
            return false;
        } catch (Exception e) {
            return false;
        }
        return true;
    }


    public static void skipToWechat(String wechat,String desc){
        try {
            ClipboardManager cmb = (ClipboardManager)FoxBaseSDK.getContext().getSystemService(Context.CLIPBOARD_SERVICE);
            //跳转微信
            Intent intent = new Intent(Intent.ACTION_MAIN);
            ComponentName cmp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.LauncherUI");
            intent.addCategory(Intent.CATEGORY_LAUNCHER);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.setComponent(cmp);
            FoxBaseSDK.getContext().startActivity(intent);

            //设置剪切板
            ClipData mClipData = ClipData.newPlainText("Label", wechat);
            cmb.setPrimaryClip(mClipData);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取tcid
     * v3.1.1.0修改：先从本地fox/config文件中读取，如果读取不到，再从sp中读取，如果sp中没有，生成新的tcid
     * @return tcid
     */
    public static String getTcid() {
        String tcid = getTcidFromLocal();
        if (TextUtils.isEmpty(tcid)) {
            tcid = FoxBaseSPUtils.getInstance().getString(FoxBaseDataUtils.TCID, "");
            if (TextUtils.isEmpty(tcid)) {
                tcid = FoxBaseDataUtils.getUUIDAndMd5(DeviceTypeEnum.IMEI.getDesc());
                FoxBaseSPUtils.getInstance().setString(FoxBaseDataUtils.TCID, tcid);
            }
            writeTcidToLocal(tcid);
        } else {
            // 本地读取到，覆盖SP中的tcid值，保证一致
            FoxBaseSPUtils.getInstance().setString(FoxBaseDataUtils.TCID, tcid);
        }

        FoxBaseLogUtils.d("tcid----->" + tcid);
        return tcid;
    }

    /**
     * 从/sdcard/fox/config文件中获取tcid
     * @return tcid 值
     */
    private static String getTcidFromLocal() {
        String tcid = "";
        // check permission
        if (FoxPermissionUtils.isGranted(Manifest.permission.READ_EXTERNAL_STORAGE)) {
            String directory = getSdcardPath() + File.separator + Constants.DIR_CONFIG;
            FoxBaseFileUtils.createOrExistsDir(directory);
            File configFile = new File(directory, "config");
            FoxBaseFileUtils.createOrExistsFile(configFile);
            List<String> configList = FoxFileIOUtils.readFile2List(configFile, 0, 0x7FFFFFFF, null);
            if (configList == null || configList.isEmpty()) {
                tcid = "";
            } else {
                tcid = configList.get(0).substring("tcid=".length());
            }
        } else {
            tcid = "";
        }
        return tcid;
    }

    /**
     * 将tcid 写入/sdcard/.fox/config文件中
     * @param tcid 要写入的tcid值
     */
    private static void writeTcidToLocal(String tcid) {
        if (FoxPermissionUtils.isGranted(Manifest.permission.WRITE_EXTERNAL_STORAGE)) {
            String directory = getSdcardPath() + File.separator + Constants.DIR_CONFIG;
            FoxBaseFileUtils.createOrExistsDir(directory);
            File configFile = new File(directory, "config");
            FoxBaseFileUtils.createOrExistsFile(configFile);
            String content = "tcid=" + tcid;
            FoxFileIOUtils.writeFileFromString(configFile, content, false);
        }
    }

    public static String getSdcardPath() {
        if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        return "/storage/emulated/0";
    }

    //获取联通手机号
    public static String getPhoneNumber(){
        String fox_n = "";

        try {
            if (getSimOperatorByMnc().equals("中国联通") && ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED){
                TelephonyManager tm = (TelephonyManager) FoxBaseSDK.getContext().getSystemService(Context.TELEPHONY_SERVICE);
                if(!isEmpty(tm.getLine1Number())) {
                    fox_n = encrypt(tm.getLine1Number(),FoxBaseConstants.KEY_SECRET);
                }
            }
        }catch (Exception ignore){

        }

        return fox_n;
    }

    /**
     * 判断网络是否可用
     * @return true：网络连接可用， false：网络连接不可用
     */
    public static boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) FoxBaseSDK.getContext().getSystemService(Context.CONNECTIVITY_SERVICE);
        if (cm != null) {
            NetworkInfo[] info = cm.getAllNetworkInfo();
            if (info != null) {
                for (int i = 0; i < info.length; i++) {
                    if (info[i].getState() == NetworkInfo.State.CONNECTED) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}
