package com.mediamain.android.base.util;

import android.text.TextUtils;

import com.mediamain.android.base.data.DeviceTypeEnum;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.util.UUID;

/**
 * Created by ZSY on 2020-06-16.
 */
public class FoxBaseDataUtils {

    public static final String TCID = "tcid";

    /**
     * 生成带时间错的uuid，tcid也采用当前策略
     * 1.时间戳
     * 2.带标志信息：设备类型
     * IMEI(1, "1010"),
     * IDFA(2, "1020"),
     * OAID(3, "1011"),
     * 合法的deviceId是md5小写32位的
     * DEVICE_ID(4, "1030"),
     * UUID(5, "1040"),
     * UNKNOWN(6, "1050");
     *
     * @return
     */
    public static String getUUIDAndMd5(String desc) {
        if (TextUtils.isEmpty(desc) || desc.length() > 4) {
            desc = DeviceTypeEnum.UNKNOWN.getDesc();
        }
        int length = desc.length();
        String uuid = "";
        try {
            uuid = UUID.randomUUID().toString() + System.currentTimeMillis();
            uuid = FoxDigestUtils.md5Hex(uuid);

            // 替换后的uuid
            uuid = desc + uuid.substring(length, uuid.length());
        }catch (Exception ignored){

        }
        return uuid;
    }

    public static String getUrlDomain(String url){
        String promoteUrl = "";
        try {

            if(!FoxBaseCommonUtils.isEmpty(url)) {
                promoteUrl = url;
                String[] strings = promoteUrl.split("&");
                promoteUrl = strings.length > 0 ? strings[0] : url;
            }
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }

        return promoteUrl;
    }

}
