package com.mediamain.android.base.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.StatusUtil;
import com.liulishuo.okdownload.core.cause.EndCause;
import com.liulishuo.okdownload.core.cause.ResumeFailedCause;
import com.liulishuo.okdownload.core.listener.DownloadListener1;
import com.liulishuo.okdownload.core.listener.assist.Listener1Assist;
import com.mediamain.android.base.data.FoxBaseNewDownloadBean;
import com.mediamain.android.base.download.broadcast.DownloadBroadCast;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.base.util.xpopup.impl.FullScreenPopupView;
import com.mediamain.android.R;

import java.io.File;
import java.util.Locale;

import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_DOWNLOAD_END_EXPOSURE;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_DOWNLOAD_ERROR_EXPOSURE;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_DOWNLOAD_START_EXPOSURE;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_INSTALL_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_INSTALL_EXPOSURE;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_OPEN_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_OPEN_EXPOSURE;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_POP_CLOSE_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.ANDROID_APK_EVENT_POP_EXPOSED;
import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_DOWNLOAD_START;
import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_DOWNLOAD_SUCCESSED;
import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_INSTALL_START;
import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_OPEN_SUCCESS;
import static com.mediamain.android.base.config.FoxBaseConstants.OPERATETYPE_CLICK;
import static com.mediamain.android.base.config.FoxBaseConstants.OPERATETYPE_EXPOSED;

/**
 * 信息流/原生插屏 下载器
 */
@SuppressLint("ViewConstructor")
public class FoxBaseDownloadDialog extends FullScreenPopupView {

    private static final String TAG = "AdDownloadDialog";

    private Activity mActivity;
    private FoxBaseNewDownloadBean mNewDownloadBean;

    private TextView tvAppTitle;
    private ImageView ivAppIcon;
    private TextView tvAppName;
    private TextView tvAppDesc;
    private TextView tvAppDownloadBar;
    private FoxBaseDownloadBar foxDownloadBar;
    private RelativeLayout reDownloadClose;
    /**
     * 下载链接
     */
    private String mUrl;
    /**
     * 下载中
     */
    public static final int TYPE_DOWNLOAD_PROGRESS = 1;
    /**
     * 下载完成
     */
    public static final int TYPE_DOWNLOAD_COMPLETE = 2;
    /**
     * 安装
     */
    public static final int TYPE_INSTALL = 3;
    /**
     * 打开
     */
    public static final int TYPE_OPEN = 4;
    /**
     * 下载错误
     */
    public static final int TYPE_DOWNLOAD_ERROR = 5;

    /**
     * 普通下载任务
     */
    public DownloadTask commonTask;

    /**
     * 点击类型处理
     */
    private int mType = 0;

    /**
     * 场景
     */
    private int mScenes;

    public FoxBaseDownloadDialog(@NonNull Activity activity, String url,int apkDownScenes, FoxBaseNewDownloadBean newDownloadBean) {
        super(activity);
        mActivity = activity;
        mUrl = url;
        mScenes = apkDownScenes;
        mNewDownloadBean = newDownloadBean;
    }

    @Override
    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == VISIBLE) {
//            if (FoxBaseAppUtil.isAppInstall(FoxBaseUtils.getApp(), KEY_CHECK_PACKAGE_NEME)) {
//                FoxBaseCommonUtils.postDataCheck(KEY_CHECK_INSTALL_SUCCESSED,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
//            }
            if (toOpenApp(false)) {
                setUI(TYPE_OPEN, "");
            } else if (toInstallApp(false)) {
                setUI(TYPE_INSTALL, "");
            } else {
//                dealDownload();
                if (foxDownloadBar != null) {
                    foxDownloadBar.reset();
                }
            }
        }
    }

    @Override
    protected int getImplLayoutId() {
        return R.layout.fox_base_new_download;
    }

    private void initView() {
        tvAppTitle = findViewById(R.id.tvAppTitle);
        reDownloadClose = findViewById(R.id.reDownloadClose);
        ivAppIcon = findViewById(R.id.ivAppIcon);
        tvAppName = findViewById(R.id.tvAppName);
        tvAppDesc = findViewById(R.id.tvAppDesc);
        tvAppDownloadBar = findViewById(R.id.tvAppDownloadBar);
        foxDownloadBar = findViewById(R.id.foxDownloadBar);
        tvAppDownloadBar.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    if (mType == TYPE_DOWNLOAD_ERROR) {
                        if (foxDownloadBar != null) {
                            foxDownloadBar.reset();
                        }
                    }
                    if (toOpenApp(true)) {
                        //已经安装
                        setUI(TYPE_OPEN, "");
                        return;
                    } else if (toInstallApp(true)) {
                        //已经下载未安装
                        setUI(TYPE_INSTALL, "");
                        return;
                    } else {
                        //未下载
                        dealDownload();
                    }
                } catch (Exception e) {
                    FoxBaseCrashUtils.reportErrorData(e);
                    e.printStackTrace();
                }
            }
        });
        reDownloadClose.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (isShow()) {
                    postDownload(ANDROID_APK_EVENT_POP_CLOSE_CLICK,OPERATETYPE_CLICK);
                    dismiss();
                }
            }
        });
        if(null == mNewDownloadBean){
            return;
        }
        //安装应用广播注册
        DownloadBroadCast downloadBroadCast = FoxBaseCommonUtils.registerDownloadBroadCast();
        if(null != downloadBroadCast) {
            downloadBroadCast.setData(mNewDownloadBean.getPackageName(), mNewDownloadBean.getAppIconUri());
        }

        if (!FoxBaseCommonUtils.isEmpty(mUrl)) {
            if (toOpenApp(true)) {
                //已经安装
                setUI(TYPE_OPEN, "");
                return;
            } else if (toInstallApp(true)) {
                //已经下载未安装
                setUI(TYPE_INSTALL, "");
                return;
            } else {
                //未下载
                dealDownload();
            }
        }
    }

    public static final int TYPE = 157;

    /**
     * 处理下载行为
     */
    private void dealDownload() {
        try {
            if (mNewDownloadBean == null || FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getUrl())) {
                return;
            }
            FoxBaseCommonUtils.postDataCheck(KEY_CHECK_DOWNLOAD_START,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
            mUrl = mNewDownloadBean.getUrl();
            if (!FoxBaseCommonUtils.isEmpty(mUrl)) {
                if (toInstallApp(true)) {
                    setUI(TYPE_INSTALL, "");
                    return;
                }
                commonTask = new DownloadTask.Builder(mUrl,
                        FoxBaseCommonUtils.getDownLoadPath("tm"),
                        FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + ".apk")
                        // the minimal interval millisecond for callback fox_progress
                        .setMinIntervalMillisCallbackProcess(30)
                        // do re-download even if the task has already been completed in the past.
                        .setPassIfAlreadyCompleted(false)
                        .setAutoCallbackToUIThread(true)
                        .setConnectionCount(3)
                        .setMinIntervalMillisCallbackProcess(300)
                        .build();
                commonTask.addTag(1, FoxBaseEncryptUtils.encryptMD5ToString(mUrl));
                FoxBaseDownloadUtils.getListenerManager().addAutoRemoveListenersWhenTaskEnd(commonTask.getId());
                StatusUtil.Status status = StatusUtil.getStatus(commonTask);
                if (status != StatusUtil.Status.RUNNING) {
                    FoxBaseDownloadUtils.getListenerManager().attachListener(commonTask, downloadListener1);
                    FoxBaseDownloadUtils.getListenerManager().enqueueTaskWithUnifiedListener(commonTask, downloadListener1);
                } else {
                    FoxBaseDownloadUtils.getListenerManager().attachListener(commonTask, downloadListener1);
                    FoxBaseToastUtils.showShort("下载中...");
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }


    //埋点上传
    private void postDownload(String dpm,int operateType) {
        if (mNewDownloadBean == null) {
            return;
        }
        FoxBaseMaidianUtil.build(TYPE)
                .set("dpm", "" + dpm)
                .set("apk_down_scenes", "" + mScenes)
                .set("promote_url", "" + mUrl)
                .set("operateType", "" + operateType)
                .postScmLog(mNewDownloadBean.getSdkDsmLogRspBean());
    }

    private DownloadListener1 downloadListener1 = new DownloadListener1() {
        @Override
        public void taskStart(@NonNull DownloadTask task, @NonNull Listener1Assist.Listener1Model model) {
            postDownload(ANDROID_APK_EVENT_DOWNLOAD_START_EXPOSURE,OPERATETYPE_EXPOSED);
            if (mActivity == null || mActivity.isFinishing() || !isShow()) {
                return;
            }
            setUI(TYPE_DOWNLOAD_PROGRESS, "0");
        }

        @Override
        public void retry(@NonNull DownloadTask task, @NonNull ResumeFailedCause cause) {

        }

        @Override
        public void connected(@NonNull DownloadTask task, int blockCount, long currentOffset, long totalLength) {

        }

        @Override
        public void progress(@NonNull DownloadTask task, long currentOffset, long totalLength) {
            try {
                if (mActivity == null || mActivity.isFinishing() || !isShow()) {
                    return;
                }
                if (totalLength > 0) {
                    String format = String.format(Locale.CHINA, "%.0f", (float) currentOffset * 100 / totalLength);
                    setUI(TYPE_DOWNLOAD_PROGRESS, format);
                    if (mNewDownloadBean != null && mNewDownloadBean.getStyleControl() != 0) {
                        FoxBaseCommonUtils.showChannelNewNotification(FoxBaseUtils.getApp(),"1",mNewDownloadBean, (int) (currentOffset * 100 / totalLength),
                                null, R.drawable.fox_notification_download,"正在下载");
                    }
                }
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }

        @Override
        public void taskEnd(@NonNull DownloadTask task, @NonNull EndCause cause, @Nullable Exception realCause, @NonNull Listener1Assist.Listener1Model model) {
            try {
                if (task != null) {
                    task.cancel();
                }
                FoxBaseCommonUtils.cancelNotify(FoxBaseUtils.getApp(), "1");
                if (cause != null) {
                    if (cause.name().contains(EndCause.ERROR.name())) {
                        if (commonTask != null) {
                            commonTask.cancel();
                        }
                        postDownload(ANDROID_APK_EVENT_DOWNLOAD_ERROR_EXPOSURE,OPERATETYPE_EXPOSED);
                        setUI(TYPE_DOWNLOAD_ERROR, "");
                        final File file1 = FoxBaseCommonUtils.checkFileExit("tm"
                                , FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + ".apk");
                        if (file1 != null && file1.exists()) {
                            FoxBaseFileUtils.delete(file1);
                        }
                    } else if (cause.name().contains(EndCause.COMPLETED.name())) {
                        FoxBaseCommonUtils.postDataCheck(KEY_CHECK_DOWNLOAD_SUCCESSED,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
                        postDownload(ANDROID_APK_EVENT_DOWNLOAD_END_EXPOSURE,OPERATETYPE_EXPOSED);
                        setUI(TYPE_DOWNLOAD_COMPLETE, "");
                        final File file1 = FoxBaseCommonUtils.checkFileExit("tm"
                                , FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + ".apk");
                        if (file1 != null && file1.exists()) {
                            final boolean rename = FoxBaseFileUtils.rename(file1, FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + "tm.apk");
                            if (rename) {
                                final File file2 = FoxBaseCommonUtils.checkFileExit("tm"
                                        , FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + "tm.apk");
                                if (file2 != null && file2.exists()) {
                                    setUI(TYPE_INSTALL, "");
                                    FoxBaseCommonUtils.postDataCheck(KEY_CHECK_INSTALL_START,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
                                    FoxBaseAppUtil.openFile(FoxBaseUtils.getApp(), file2);
                                    if (mNewDownloadBean != null && mNewDownloadBean.getStyleControl() != 0) {
                                        FoxBaseCommonUtils.showChannelNewNotification(FoxBaseUtils.getApp(),"0",mNewDownloadBean, 100,
                                                file2, R.drawable.fox_notification_install,"仅差一步:安装即可领取奖励");
                                    }
                                }
                            } else {
                                setUI(TYPE_INSTALL, "");
                                FoxBaseCommonUtils.postDataCheck(KEY_CHECK_INSTALL_START,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
                                FoxBaseAppUtil.openFile(FoxBaseUtils.getApp(), file1);
                                if (mNewDownloadBean != null && mNewDownloadBean.getStyleControl() != 0) {
                                    FoxBaseCommonUtils.showChannelNewNotification(FoxBaseUtils.getApp(),"0",mNewDownloadBean, 100,
                                            file1, R.drawable.fox_notification_install,"仅差一步:安装即可领取奖励");
                                }
                            }
                        }
                    }
                }
            } catch (Exception e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
        }
    };

    /**
     * 处理app安装
     */
    private boolean toInstallApp(boolean isInstall) {
        try {
            if (FoxBaseUtils.getApp() != null) {
                if (!FoxBaseCommonUtils.isEmpty(mUrl)) {
                    final File file2 = FoxBaseCommonUtils.checkFileExit("tm"
                            , FoxBaseEncryptUtils.encryptMD5ToString(mUrl) + "tm.apk");
                    if (file2 != null && file2.exists()) {
                        if (mNewDownloadBean != null && mNewDownloadBean.getStyleControl() != 0) {
                            FoxBaseCommonUtils.showChannelNewNotification(FoxBaseUtils.getApp(),"0",mNewDownloadBean, 100,
                                    file2, R.drawable.fox_notification_install, "仅差一步,安装即可领取奖励");
                        }
                        if (isInstall) {
                            FoxBaseAppUtil.openFile(FoxBaseUtils.getApp(), file2);
                            FoxBaseCommonUtils.postDataCheck(KEY_CHECK_INSTALL_START,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
                            postDownload(ANDROID_APK_EVENT_INSTALL_CLICK,OPERATETYPE_CLICK);
                        }else {
                            postDownload(ANDROID_APK_EVENT_INSTALL_EXPOSURE,OPERATETYPE_EXPOSED);
                        }
                        return true;
                    }
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return false;
    }


    /**
     * 处理app打开行为
     *
     * @return
     */
    private boolean toOpenApp(boolean isOpen) {
        try {
            if (FoxBaseUtils.getApp() != null) {
                if (mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getPackageName())
                        && FoxBaseAppUtil.isAppInstall(FoxBaseUtils.getApp(), mNewDownloadBean.getPackageName())) {
                    if (mNewDownloadBean != null
                            && mNewDownloadBean.getStyleControl() != 0
                            && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getPackageName())) {
                        FoxBaseCommonUtils.showChannelNewNotification(FoxBaseUtils.getApp(),"0",mNewDownloadBean, 100,
                                null, R.drawable.fox_notification_open, "应用已安装完毕,快打开领奖吧!");
                    }
                    if (isOpen) {
                        postDownload(ANDROID_APK_EVENT_OPEN_CLICK,OPERATETYPE_CLICK);
                        FoxBaseCommonUtils.postDataCheck(KEY_CHECK_OPEN_SUCCESS,mNewDownloadBean!=null?mNewDownloadBean.getSlotId():"",mNewDownloadBean);
                        FoxBaseAppUtil.openOtherApp(FoxBaseUtils.getApp(), mNewDownloadBean.getPackageName());
                    }else {
                        postDownload(ANDROID_APK_EVENT_OPEN_EXPOSURE,OPERATETYPE_EXPOSED);
                    }
                    return true;
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 更新弹窗UI
     *
     * @param type
     */
    private void setUI(final int type, final String format) {
        try {
            mType = type;
            if (mActivity == null || mActivity.isFinishing() || !isShow()) {
                return;
            }
            mActivity.runOnUiThread(new Runnable() {

                @Override
                public void run() {
                    switch (type) {
                        case TYPE_DOWNLOAD_PROGRESS:
                            //下载中
                            if (tvAppTitle != null) {
                                if (mNewDownloadBean != null) {
                                    tvAppTitle.setText("安装并打开即可获得奖励");
                                } else {
                                    tvAppTitle.setText("务必使用本下载包安装,快速领取奖励！");
                                }
                            }
//                            if (ivAppIcon != null && mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getAppIconUri())) {
//                                ivAppIcon.setBackgroundDrawable(null);
//                                if (!mNewDownloadBean.getAppIconUri().startsWith("http")) {
//                                    ivAppIcon.setImageUrl("http:" + mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
//                                } else {
//                                    ivAppIcon.setImageUrl(mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
//                                }
//                            }

                            if (tvAppName != null) {
                                if (mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getApplicationName())) {
                                    tvAppName.setText(mNewDownloadBean.getApplicationName());
                                } else {
                                    tvAppName.setText("奖励即将到账");
                                }
                            }

                            if (tvAppDesc != null) {
                                if (mNewDownloadBean != null) {
                                    tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                } else {
                                    tvAppDesc.setText("下载中");
                                }
                            }
                            if (tvAppDownloadBar != null) {
                                tvAppDownloadBar.setVisibility(View.GONE);
                            }
                            if (foxDownloadBar != null && !FoxBaseCommonUtils.isEmpty(format)) {
                                foxDownloadBar.setVisibility(View.VISIBLE);
                                foxDownloadBar.setProgress(Integer.valueOf(format));
                            }
                            break;
                        case TYPE_DOWNLOAD_COMPLETE:
                            //下载完成
                            if (tvAppTitle != null) {
                                if (mNewDownloadBean != null) {
                                    tvAppTitle.setText("安装并打开即可获得奖励");
                                } else {
                                    tvAppTitle.setText("务必使用本下载包安装,快速领取奖励!");
                                }
                            }

//                            if (ivAppIcon != null && mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getAppIconUri())) {
//                                ivAppIcon.setBackgroundDrawable(null);
////                                if (!mNewDownloadBean.getAppIconUri().startsWith("http")) {
////                                    ivAppIcon.setImageUrl("http:" + mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
////                                } else {
////                                    ivAppIcon.setImageUrl(mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
////                                }
//                            }
                            if (tvAppName != null) {
                                if (mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getApplicationName())) {
                                    tvAppName.setText(mNewDownloadBean.getApplicationName());
                                } else {
                                    tvAppName.setText("奖励即将到账");
                                }
                            }

                            if (tvAppDesc != null) {
                                if (mNewDownloadBean != null) {
                                    tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                } else {
                                    tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                }
                            }

                            if (tvAppDownloadBar != null) {
                                tvAppDownloadBar.setVisibility(View.GONE);
                            }
                            if (foxDownloadBar != null && !FoxBaseCommonUtils.isEmpty(format)) {
                                foxDownloadBar.setVisibility(View.VISIBLE);
                                foxDownloadBar.setProgress(100);
                            }
                            break;
                        case TYPE_DOWNLOAD_ERROR:
                            //下载异常
                            if (tvAppTitle != null) {
                                if (mNewDownloadBean != null) {
                                    tvAppTitle.setText("安装并打开即可获得奖励");
                                } else {
                                    tvAppTitle.setText("务必使用本下载包安装,快速领取奖励!");
                                }
                            }

//                            if (ivAppIcon != null && mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getAppIconUri())) {
//                                ivAppIcon.setBackgroundDrawable(null);
////                                if (!mNewDownloadBean.getAppIconUri().startsWith("http")) {
////                                    ivAppIcon.setImageUrl("http:" + mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
////                                } else {
////                                    ivAppIcon.setImageUrl(mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
////                                }
//                            }

                            if (tvAppName != null) {
                                if (mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getApplicationName())) {
                                    tvAppName.setText(mNewDownloadBean.getApplicationName());
                                } else {
                                    tvAppName.setText("奖励即将到账");
                                }
                            }

                            if (tvAppDesc != null) {
                                if (mNewDownloadBean != null) {
                                    tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                } else {
                                    tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                }
                            }

                            if (foxDownloadBar != null) {
                                foxDownloadBar.setVisibility(View.GONE);
                            }
                            if (tvAppDownloadBar != null) {
                                tvAppDownloadBar.setVisibility(View.VISIBLE);
                                tvAppDownloadBar.setText("下载失败请点击重试");
                            }
                            break;
                        case TYPE_INSTALL:
                            //安装
                            if (tvAppTitle != null) {
                                if (mNewDownloadBean != null) {
                                    tvAppTitle.setText("安装并打开即可获得奖励");
                                } else {
                                    tvAppTitle.setText("务必使用本下载包安装,快速领取奖励!");
                                }
                            }


//                            if (ivAppIcon != null && mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getAppIconUri())) {
//                                ivAppIcon.setBackgroundDrawable(null);
////                                if (!mNewDownloadBean.getAppIconUri().startsWith("http")) {
////                                    ivAppIcon.setImageUrl("http:" + mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
////                                } else {
////                                    ivAppIcon.setImageUrl(mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
////                                }
//                            }

                            if (tvAppName != null) {
                                if (mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getApplicationName())) {
                                    tvAppName.setText(mNewDownloadBean.getApplicationName());
                                } else {
                                    tvAppName.setText("奖励即将到账");
                                }
                            }

                            if (tvAppDesc != null) {
                                if (mNewDownloadBean != null) {
                                    tvAppDesc.setText("请务必使用下载的安装包安装应用");
                                } else {
                                    tvAppDesc.setText("立即安装");
                                }
                            }

                            if (foxDownloadBar != null) {
                                foxDownloadBar.setVisibility(View.GONE);
                            }
                            if (tvAppDownloadBar != null) {
                                tvAppDownloadBar.setVisibility(View.VISIBLE);
                                tvAppDownloadBar.setText("立即安装");
                            }
                            break;
                        case TYPE_OPEN:
                            //打开
                            if (tvAppTitle != null) {
                                if (mNewDownloadBean != null) {
                                    tvAppTitle.setText("就差一步：打开即可领奖");
                                } else {
                                    tvAppTitle.setText("务必使用本下载包安装,快速领取奖励！");
                                }
                            }

//                            if (ivAppIcon != null && mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getAppIconUri())) {
//                                ivAppIcon.setBackgroundDrawable(null);
//                                if (!mNewDownloadBean.getAppIconUri().startsWith("http")) {
//                                    ivAppIcon.setImageUrl("http:" + mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
//                                } else {
//                                    ivAppIcon.setImageUrl(mNewDownloadBean.getAppIconUri(), R.drawable.fox_app_iocn_default);
//                                }
//                            }
                            if (tvAppName != null) {
                                if (tvAppName != null && mNewDownloadBean != null && !FoxBaseCommonUtils.isEmpty(mNewDownloadBean.getApplicationName())) {
                                    tvAppName.setText(mNewDownloadBean.getApplicationName());
                                } else {
                                    tvAppName.setText("奖励即将到账");
                                }
                            }

                            if (tvAppDesc != null) {
                                if (mNewDownloadBean != null) {
                                    tvAppDesc.setText("点击下方按钮,前往领取奖励");
                                } else {
                                    tvAppDesc.setText("打开应用领奖");
                                }
                            }

                            if (foxDownloadBar != null) {
                                foxDownloadBar.setVisibility(View.GONE);
                            }

                            if (tvAppDownloadBar != null) {
                                tvAppDownloadBar.setVisibility(View.VISIBLE);
                                tvAppDownloadBar.setText("打开领取奖励");
                            }
                            break;
                        default:
                            break;
                    }
                }
            });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }


    @Override
    protected void onShow() {
        super.onShow();
        postDownload(ANDROID_APK_EVENT_POP_EXPOSED,OPERATETYPE_EXPOSED);
        initView();
    }

    @Override
    protected void onDismiss() {
        super.onDismiss();
    }


    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            if (isShow()) {
                dismiss();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }
}

