package com.mediamain.android.base.util;

import android.annotation.SuppressLint;
import android.os.Build;
import android.text.TextUtils;

import com.mediamain.android.BuildConfig;
import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.Constants;
import com.mediamain.android.base.config.FoxBaseConstants;
import com.mediamain.android.base.config.FoxBaseUrl;
import com.mediamain.android.base.data.FoxBaseSdkDsmLogRspBean;
import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.nativead.Ad;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * ================================================
 * 作    者：jint（金台）
 * 版    本：1.0
 * 创建日期：2018/8/5-15:16
 * 描    述：埋点工具类
 * 修订历史：
 * ================================================
 */
public class FoxBaseMaidianUtil {

    private String TAG = "FoxBaseMaidianUtil";
    private String mCode = "0";
    private String mEvent = "";
    private JSONObject mJSONObject;
    private Ad mAd;
    private int type = 1;
    private Map<String, String> mMap;
    public static final int SHOW = 1;
    public static final int CLICK = 2;

    public static FoxBaseMaidianUtil build(int type) {
        return new FoxBaseMaidianUtil(type);
    }
    public static FoxBaseMaidianUtil build(String event, Ad ad) {
        return new FoxBaseMaidianUtil(event, ad);
    }

    private FoxBaseMaidianUtil(String event, Ad ad) {
        this.mEvent = event;
        this.mAd = ad;
    }

    private FoxBaseMaidianUtil(int type) {
        this.type = type;
    }

    public static FoxBaseMaidianUtil build(String code, int type) {
        return new FoxBaseMaidianUtil(code,type);
    }

    private FoxBaseMaidianUtil(String code, int type) {
        this.mCode = code;
        this.type = type;
    }

    public FoxBaseMaidianUtil set(String key, String value) {
        try {
            if (mJSONObject == null) {
                mJSONObject = new JSONObject();
            }
            mJSONObject.put(key, value);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }

        return this;
    }

    public FoxBaseMaidianUtil set(Map<String, String> params) {
        if (mMap == null) {
            mMap = new HashMap<>();
        }
        mMap.putAll(params);
        return this;
    }

    /**
     * post 通知栏点击埋点
     */
    @SuppressLint("CheckResult")
    public void post() {
        if (mMap == null) {
            mMap = new HashMap<>();
        }
        try {

            if (mJSONObject == null) {
                mJSONObject = new JSONObject();
            }

            if (mMap != null && mMap.size() != 0) {
                for (Map.Entry<String, String> entry : mMap.entrySet()) {
                    mJSONObject.put(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            //公共参数
            mJSONObject.put("version", BuildConfig.VERSION_NAME);
            mJSONObject.put("device_id", FoxBaseCommonUtils.getIMEI());
            mJSONObject.put("device_type", "" + FoxBaseCommonUtils.getPhoneType());
            mJSONObject.put("connection_type", "" + FoxBaseCommonUtils.getNetworkType());
            mJSONObject.put("os_type", "Android");
            mJSONObject.put("os_version", ""+Build.VERSION.RELEASE);
            mJSONObject.put("brand_name",Build.MANUFACTURER);
            mJSONObject.put("ua",FoxBaseCommonUtils.getUserAgent());
            mJSONObject.put("oaid", "" + FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_APP_OAID, "") );
            mJSONObject.put("imei", FoxBaseCommonUtils.getIMEI());
            mJSONObject.put("tcid", FoxBaseCommonUtils.getTcid());
            mJSONObject.put("json",mJSONObject);
            mJSONObject.put("type",type);
            mJSONObject.put("group","1");
            OkGo.<String>post(FoxBaseUrl.BASE_SDK_ENGINE_LOG)
                    .upJson(mJSONObject)
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(com.mediamain.android.base.okgo.model.Response<String> response) {

                        }

                        @Override
                        public void onError(com.mediamain.android.base.okgo.model.Response<String> response) {
                            super.onError(response);

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 下载埋点
     */
    @SuppressLint("CheckResult")
    public void postCheck() {
        if (mMap == null) {
            mMap = new HashMap<>();
        }
        try {
            if (mJSONObject == null) {
                mJSONObject = new JSONObject();
            }
            if (mMap != null && mMap.size() != 0) {
                for (Map.Entry<String, String> entry : mMap.entrySet()) {
                    mJSONObject.put(entry.getKey(), "" + entry.getValue());
                }
            }
            mMap.clear();
            mJSONObject.put("version", BuildConfig.VERSION_NAME);
            mJSONObject.put("device_id", FoxBaseCommonUtils.getIMEI());
            mJSONObject.put("device_type", Integer.toString(FoxBaseCommonUtils.getPhoneType()));
            mJSONObject.put("connection_type", "" + FoxBaseCommonUtils.getNetworkType());
            mJSONObject.put("os_type", "Android");
            mJSONObject.put("os_version", ""+Build.VERSION.RELEASE);
            mJSONObject.put("brand_name",Build.MANUFACTURER);
            mJSONObject.put("ua",FoxBaseCommonUtils.getUserAgent());
            mJSONObject.put("app_key", FoxBaseCommonUtils.getAppKey());
            mJSONObject.put("oaid", FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_APP_OAID, "") );
            mJSONObject.put("imei", FoxBaseCommonUtils.getIMEI());
            mJSONObject.put("tcid", FoxBaseCommonUtils.getTcid());
            //特殊处理
            try {
                String businessType = mJSONObject.isNull("businessType") ? "" :mJSONObject.getString("businessType");
                if(!FoxBaseCommonUtils.isEmpty(businessType) && "4".equals(businessType)){
                    mJSONObject.put("sub_type", Constants.SUB_TYPE_INSTALL);
                }
                if(mJSONObject.isNull("tuia_id")){
                    mJSONObject.put("tuia_id","");
                }
            }catch (Exception ignored){}

            JSONObject jsonObject = new JSONObject();
            jsonObject.put("json",mJSONObject); //后端只能接收对象
            jsonObject.put("group","1");//1： 广告平台业务
            jsonObject.put("type",type);

            OkGo.<String>post(FoxBaseUrl.BASE_SDK_TEST_LOG)
                    .upJson(jsonObject)
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(com.mediamain.android.base.okgo.model.Response<String> response) {

                        }

                        @Override
                        public void onError(com.mediamain.android.base.okgo.model.Response<String> response) {
                            super.onError(response);

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * post 请求
     *
     */
    @SuppressLint("CheckResult")
    public void postScmLog(FoxBaseSdkDsmLogRspBean sdkDsmLogRspBean) {
        if (mMap == null) {
            mMap = new HashMap<>();
        }
        try {
            if (mJSONObject == null) {
                mJSONObject = new JSONObject();
            }
            if (mMap != null && mMap.size() != 0) {
                for (Map.Entry<String, String> entry : mMap.entrySet()) {
                    mJSONObject.put(entry.getKey(), "" + entry.getValue());
                }
            }
            if (sdkDsmLogRspBean!=null){
                mJSONObject.put("dsm", sdkDsmLogRspBean.getDsm());
                mJSONObject.put("consumer_id", sdkDsmLogRspBean.getConsumerId());
                mJSONObject.put("activity_id", sdkDsmLogRspBean.getActivityId());
                mJSONObject.put("app_id", sdkDsmLogRspBean.getAppId());
                mJSONObject.put("order_id", sdkDsmLogRspBean.getOrderId());
                mJSONObject.put("slot_id", sdkDsmLogRspBean.getSlotId());
            }
            mJSONObject.put("device_id", "" + FoxBaseCommonUtils.getIMEI());
            mJSONObject.put("imei", "" + FoxBaseCommonUtils.getIMEI());
            mJSONObject.put("app_key", "" + FoxBaseCommonUtils.getAppKey());
            mJSONObject.put("oaid", "" + FoxBaseOAUtils.getOAID(FoxBaseSDK.getContext()));
            mJSONObject.put("sdk_version", BuildConfig.VERSION_NAME); //兼容老数据
            mJSONObject.put("os_type", "Android");
            mJSONObject.put("os_version", ""+Build.VERSION.RELEASE);
            mJSONObject.put("type", type);
            mJSONObject.put("tcid", FoxBaseCommonUtils.getTcid());
            mJSONObject.put("brand_name",Build.MANUFACTURER);
            OkGo.<String>post(FoxBaseUrl.BASE_SDK_SCMLOG)
                    .upJson(mJSONObject)
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(com.mediamain.android.base.okgo.model.Response<String> response) {

                        }

                        @Override
                        public void onError(com.mediamain.android.base.okgo.model.Response<String> response) {
                            super.onError(response);

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     *  Post 请求日志
     * @param mapParam
     */
    public void postScmLog(Map<String,String> mapParam, String strParam) {
        if (mapParam == null) {
            mapParam = new HashMap<>();
        }
        try {
            StringBuilder sbUrl = new StringBuilder(FoxBaseUrl.BASE_SDK_SCMLOG);
            sbUrl.append(strParam);
            for (String key:mapParam.keySet()){
                sbUrl.append("&"+key+"="+mapParam.get(key));
            }

            OkGo.<String>post(sbUrl.toString())
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(com.mediamain.android.base.okgo.model.Response<String> response) {

                        }

                        @Override
                        public void onError(com.mediamain.android.base.okgo.model.Response<String> response) {
                            super.onError(response);

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postDeepLinkStartLog() {
        try {
            if (mJSONObject == null) {
                mJSONObject = new JSONObject();
            }
            if (mMap != null && mMap.size() != 0) {
                for (Map.Entry<String, String> entry : mMap.entrySet()) {
                    mJSONObject.put(entry.getKey(), "" + entry.getValue());
                }
            }
            mJSONObject.put("imei", "" + FoxBaseCommonUtils.getIMEI());
            mJSONObject.put("oaid", "" + FoxBaseOAUtils.getOAID(FoxBaseSDK.getContext()));
            mJSONObject.put("sdk_version", BuildConfig.VERSION_NAME);
            mJSONObject.put("type", type);
            mJSONObject.put("operateType", "102");
            mJSONObject.put("act_url", "");
            OkGo.<String>post(FoxBaseUrl.BASE_SDK_SCMLOG)
                    .upJson(mJSONObject)
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(com.mediamain.android.base.okgo.model.Response<String> response) {

                        }

                        @Override
                        public void onError(com.mediamain.android.base.okgo.model.Response<String> response) {
                            super.onError(response);

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postNativeAd() {
        try {
            if (mAd == null) {
                FoxBaseLogUtils.vTag(TAG, "mAd IS NULL");
                return;
            }
            if (TextUtils.isEmpty(mEvent)) {
                FoxBaseLogUtils.vTag(TAG, "CODE IS NULL");
                return;
            }
            if (mJSONObject == null) {
                mJSONObject = new JSONObject();
            }
            mJSONObject.put("event", "" + mEvent);
            mJSONObject.put("sdkVersion", "" + BuildConfig.VERSION_NAME);
            mJSONObject.put("appName", "" + FoxBaseCommonUtils.getAppName());
            mJSONObject.put("manufacturer", "" + Build.MANUFACTURER);
            mJSONObject.put("model", "" + FoxBaseCommonUtils.getModel());
            mJSONObject.put("androidId", "" + FoxBaseCommonUtils.getAndroidID());
            // mJSONObject.put("imei", "" + PhoneUtils.getIMEI());
            mJSONObject.put("osVersion", "" + FoxBaseCommonUtils.getSDKVersionName());
            mJSONObject.put("appKey", mAd == null ? "" : "" + mAd.getAppKey());
            mJSONObject.put("slotId", mAd == null ? "" : "" + mAd.getSlotId());
            mJSONObject.put("deviceId", mAd == null ? "" : "" + mAd.getDeviceId());
            mJSONObject.put("userId", mAd == null ? "" : "" + mAd.getUserId());
            mJSONObject.put("timestamp", "" + System.currentTimeMillis());
            mJSONObject.put("sdkType", "android");
            //原生GG类型
            mJSONObject.put("type", mAd.getAdWrap() == null ? "pop" : "insert");
            String url;
            if (!BuildConfig.Release) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    url = "https://activity.tuiapre.cn/native/sdk/event/log";
                } else {
                    url = "http://activity.tuiapre.cn/native/sdk/event/log";
                }
            } else {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    url = "https://activity.tuia.cn/native/sdk/event/log";
                } else {
                    url = "http://activity.tuia.cn/native/sdk/event/log";
                }
            }
            OkGo.<String>post(url)
                    .tag(this)
                    .upJson(mJSONObject.toString())
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(Response<String> response) {
                            if (!BuildConfig.Release) {
                                FoxBaseLogUtils.vTag(TAG, "log===>" + response.body());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
