package com.mediamain.android.base.util;

import android.content.Context;
import android.text.TextUtils;

import com.mediamain.android.base.config.FoxBaseConstants;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class FoxBaseOAUtils {

    private static String IIdentifierListener = "com.bun.miitmdid.core.IIdentifierListener";
    private static String IdSupplier = "com.bun.miitmdid.supplier.IdSupplier";

    private static final String TAG = "FoxBaseOAUtils";
    private static String oaid = "";
    private static CountDownLatch countDownLatch;

    /**
     * 获取 OAID 接口
     * 该接口是同步接口，可能会导致线程阻塞，建议在子线程中使用
     *
     * @param context Context
     * @return OAID
     */
    public static String getOAID(final Context context) {
        try {
            countDownLatch = new CountDownLatch(1);
            if (TextUtils.isEmpty(oaid)) {
                oaid = FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_APP_OAID, "");
                if(TextUtils.isEmpty(oaid)) {
                    getOAIDReflect(context, 3);
                }else{
                    return oaid;
                }
            } else {
                return oaid;
            }
            try {
                countDownLatch.await(1500, TimeUnit.MILLISECONDS);
            } catch (Exception ignored) {
                FoxBaseCrashUtils.reportErrorData(ignored);
            }
            return oaid;
        } catch (Exception ex) {
        }
        return "";
    }

    /**
     * 通过反射获取 OAID
     * 结果返回的 ErrorCode 如下：
     * 1008611：不支持的设备厂商
     * 1008612：不支持的设备
     * 1008613：加载配置文件出错
     * 1008614：获取接口是异步的，结果会在回调中返回，回调执行的回调可能在工作线程
     * 1008615：反射调用出错
     * @param context Context
     * @param retryCount 重试次数
     */
    private static void getOAIDReflect(Context context, int retryCount) {
        try {
            if (retryCount <= 0) {
                return;
            }
            final int INIT_ERROR_RESULT_DELAY = 1008614;
            // 初始化 Library
            if( !IdSupplier.equals("com.bun.miitmdid.interfaces.IdSupplier")) { //兼容1.0.22版本
                Class<?> jLibrary = Class.forName("com.bun.miitmdid.core.JLibrary");
                Method initEntry = jLibrary.getDeclaredMethod("InitEntry", Context.class);
                initEntry.invoke(null, context);
            }

            Class identifyListener = Class.forName(IIdentifierListener);
            // 创建 OAID 获取实例
            IdentifyListenerHandler handler = new IdentifyListenerHandler();
            Object iIdentifierListener = Proxy.newProxyInstance(context.getClassLoader(), new Class[]{identifyListener}, handler);
            // 初始化 SDK
            Class<?> midSDKHelper = Class.forName("com.bun.miitmdid.core.MdidSdkHelper");
            Method initSDK = midSDKHelper.getDeclaredMethod("InitSdk", Context.class, boolean.class, identifyListener);
            int errCode = (int) initSDK.invoke(null, context, true, iIdentifierListener);
            if (errCode != INIT_ERROR_RESULT_DELAY) {
                getOAIDReflect(context, --retryCount);
                if (retryCount == 0) {
                    countDownLatch.countDown();
                }
            }

            /*
             * 此处是为了适配三星部分手机，根据 MSA 工作人员反馈，对于三星部分机型的支持有 bug，导致
             * 返回 1008614 错误码，但是不会触发回调。所以此处的逻辑是，两秒之后主动放弃阻塞。
             */
            FoxBaseThreadUtils.getCachedPool().execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        Thread.sleep(1500);
                    } catch (InterruptedException e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                    }
                    countDownLatch.countDown();
                }
            });
        } catch (Exception ex) {
            //解决1.0.12和1.0.13的包名重构问题com.bun.miitmdid.interfaces.IIdentifierListener
            IIdentifierListener = "com.bun.supplier.IIdentifierListener";
            IdSupplier = "com.bun.supplier.IdSupplier";
            if( retryCount == 1 ){ //兼容1.0.22版本
                IIdentifierListener = "com.bun.miitmdid.interfaces.IIdentifierListener";
                IdSupplier = "com.bun.miitmdid.interfaces.IdSupplier";
            }
            getOAIDReflect(context, --retryCount);
            if (retryCount == 0) {// 对于没有集成 jar 包，尝试后为 0
                countDownLatch.countDown();
            }
        }
    }

    static class IdentifyListenerHandler implements InvocationHandler {

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if ("OnSupport".equals(method.getName())) {
                    if ((Boolean) args[0]) {
                        Class<?> idSupplier = Class.forName(IdSupplier);
                        Method getOAID = idSupplier.getDeclaredMethod("getOAID");
                        oaid = (String) getOAID.invoke(args[1]);
                        //Log.d(TAG, "oaid:" + oaid);
                        if (!FoxBaseCommonUtils.isEmpty(oaid)){
                            FoxBaseSPUtils.getInstance().setString(FoxBaseConstants.KEY_TUIA_SDK_APP_OAID, oaid);
                        }
                    }

                    countDownLatch.countDown();
                }
            } catch (Exception ex) {
                countDownLatch.countDown();
            }
            return null;
        }
    }
}
