package com.mediamain.android.base.util;

import android.content.Context;
import android.content.SharedPreferences;

import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

/**
 * SharedPreferences 工具类
 * Created by Administrator on 2017/5/27.
 */
public class FoxBaseSPUtils {

    private static volatile FoxBaseSPUtils mInstance;

    private SharedPreferences mSp;

    public static FoxBaseSPUtils getInstance() {
        try {
            if (null == mInstance) {
                synchronized (FoxBaseSPUtils.class) {
                    if (null == mInstance) {
                        mInstance = new FoxBaseSPUtils();
                        mInstance.mSp = FoxBaseSDK.getContext().getSharedPreferences("tui_base", Context.MODE_PRIVATE);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return mInstance;
    }

    public String getString(String key, String value) {
        try {
            if (this.mSp!=null){
                return this.mSp.getString(key, value);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * sputils
     *
     * @param key   读取时的键值
     * @param value 默认值
     * @return
     */
    public FoxBaseSPUtils setString(String key, String value) {
        try {
            SharedPreferences.Editor editor = this.mSp.edit();
            editor.putString(key, value);
            editor.apply();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }


    /**
     * sputils
     *
     * @param key   读取时的键值
     * @param value 默认值
     * @return
     */
    public boolean getBoolean(String key, boolean value) {
        try {
            if (this.mSp!=null) {
                return this.mSp.getBoolean(key, value);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * @param key
     * @param value 要写入的值
     * @return
     */
    public FoxBaseSPUtils setBoolean(String key, boolean value) {
        try {
            SharedPreferences.Editor editor = this.mSp.edit();
            editor.putBoolean(key, value);
            editor.apply();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }


    public long getLong(String key, long value) {
        try {
            if (this.mSp!=null) {
                return this.mSp.getLong(key, value);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return 0L;
    }

    /**
     * sputils
     *
     * @param key   读取时的键值
     * @param value 默认值
     * @return
     */
    public FoxBaseSPUtils setLong(String key, long value) {
        try {
            SharedPreferences.Editor editor = this.mSp.edit();
            editor.putLong(key, value);
            editor.apply();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return this;
    }

    public int getInt(String key, int value) {
        try {
            if (this.mSp!=null) {
                return this.mSp.getInt(key, value);
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return 0;
    }

    /**
     * sputils
     *
     * @param key   读取时的键值
     * @param value 默认值
     * @return
     */
    public FoxBaseSPUtils setInt(String key, int value) {
        try {
            SharedPreferences.Editor editor = this.mSp.edit();
            editor.putInt(key, value);
            editor.apply();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public boolean containsKey(String key){
        try {
            if (this.mSp == null) {
                return false;
            }

            return mSp.contains(key);
        }catch (Exception e){
            FoxBaseCrashUtils.reportErrorData(e);
        }

        return false;
    }

    public void remove(String key){
        try {
            SharedPreferences.Editor editor = this.mSp.edit();
            editor.remove(key);
            editor.apply();
        }catch (Exception e){
            FoxBaseCrashUtils.reportErrorData(e);
        }
    }
}
