package com.mediamain.android.base.util;

import com.mediamain.android.base.config.FoxBaseConstants;
import com.mediamain.android.base.data.FoxBaseSDKConfigBean;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.util.Map;

/**
 * Created by ZSY on 2020-08-15.
 */

public class FoxBaseTestUtils {

    /**
     * 获取AB测试分流（支持广告位分流）
     * @param slotId
     * @return
     */
    public static String getABTest(String slotId){
        String abTestType = "0";

        if(FoxBaseCommonUtils.isEmpty(slotId)){
            return abTestType;
        }

        try {
            final String configData = FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_CONFIG, "");
            FoxBaseSDKConfigBean.DataBean sdkConfigBean = FoxBaseGsonUtil.GsonToBean(configData, FoxBaseSDKConfigBean.DataBean.class);
            if (null == sdkConfigBean){
                return abTestType;
            }

            Map<String, Integer> showTypeMap = sdkConfigBean.getShowTypeSlotMap();
            if (null == showTypeMap || showTypeMap.isEmpty()) {
                if (sdkConfigBean.getShowType() == 1) {
                    abTestType = "a";
                } else if (sdkConfigBean.getShowType() == 2) {
                    abTestType = "b";
                } else {
                    abTestType = "0";
                }
            } else {
                //广告位维度分流
                if (showTypeMap.containsKey(slotId)) {
                    Integer showType = showTypeMap.get(slotId);
                    if (showType == null) {
                        abTestType = "0";
                        return abTestType;
                    }
                    if (showType == 1) {
                        abTestType = "a";
                    } else if (showType == 2) {
                        abTestType = "b";
                    } else {
                        abTestType = "0";
                    }
                } else {
                    //兜底（全局分流）
                    if (sdkConfigBean.getShowType() == 1) {
                        abTestType = "a";
                    } else if (sdkConfigBean.getShowType() == 2) {
                        abTestType = "b";
                    } else {
                        abTestType = "0";
                    }
                }
            }
        } catch (Exception e){
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
            abTestType = "0";
        }
        return abTestType;
    }
}
