package com.mediamain.android.base.util;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorManager;

import com.mediamain.android.BuildConfig;
import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.FoxBaseConstants;
import com.mediamain.android.base.config.FoxBaseUrl;
import com.mediamain.android.base.data.FoxBaseFileBean;
import com.mediamain.android.base.data.FoxBaseSensorBean;
import com.mediamain.android.base.data.FoxBaseUsageStatsBean;
import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.callback.StringCallback;
import com.mediamain.android.base.okgo.model.Response;
import com.mediamain.android.base.okgo.request.PostRequest;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * Created by ZSY on 2020-03-26.
 */
public class FoxCycleReportTask {

    public static final String UPLOAD_PERIOD = "upload_period";
    private static final int DELAY_MILLISECOND = 60 ; //延迟(单位：秒)
    private static int INTERVAL_MILLISECOND = 60; //间隔(单位：秒)
    private static Context mContext;

    private ScheduledExecutorService mSES;
    private Runnable mTask;
    private int mDataFrom;
    private String mConfigData;
    private String mAppKey;
    private String mAppSecret;
    private String appList = null;
    private List<FoxBaseSensorBean> sensorList;
    private List<FoxBaseFileBean> appCacheData = new ArrayList<>();
    private List<FoxBaseUsageStatsBean> usageList = new ArrayList<>();

    public FoxCycleReportTask(Context context, Runnable task, ScheduledExecutorService sService,
                              int dataFrom, String configData, int uploadInterval){


        try {
            mContext = context;
            this.mTask = task;
            this.mSES = sService;

            this.mDataFrom = dataFrom;
            this.mConfigData = configData;

            if(uploadInterval > INTERVAL_MILLISECOND){
                INTERVAL_MILLISECOND = uploadInterval;
            }
            //初始化任务
            if (mTask == null) {
                mTask = new Runnable() {
                    @Override
                    public void run() {
                        execCheckTask();
                    }
                };
            }
            if (mSES == null) {
                mSES = Executors.newSingleThreadScheduledExecutor();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUploadInterval(int uploadInterval){
        INTERVAL_MILLISECOND = 60;
        if(uploadInterval > INTERVAL_MILLISECOND){
            INTERVAL_MILLISECOND = uploadInterval;
        }
    }

    public void setmDataFrom(int mDataFrom) {
        this.mDataFrom = mDataFrom;
    }

    public void setmConfigData(String mConfigData) {
        this.mConfigData = mConfigData;
    }

    public void startCycleReportTask(){
        startCycleReportTask(true);
    }

    public void startCycleReportTask(boolean only){
        try {
            if(only){
                mSES.schedule(mTask,3,TimeUnit.SECONDS);
            }else {
                mSES.scheduleWithFixedDelay(mTask, DELAY_MILLISECOND, INTERVAL_MILLISECOND, TimeUnit.SECONDS);
            }
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

    /**
     * 定时上报
     */
    private void execCheckTask(){
        try {
            //获取应用列表
            if (!FoxBaseSDK.mUnCollects.contains("app_list")) {
                appList = FoxBaseCommonUtils.getAppList();
            }

            if (!FoxBaseSDK.mUnCollects.contains("app_active_list")) {
                //获取应用活跃信息
                if (FoxBaseCommonUtils.checkAppUsagePermission()) {
                    usageList = FoxBaseCommonUtils.getUsageList(FoxBaseSDK.getContext());
                }
            }
            if (!FoxBaseSDK.mUnCollects.contains("oaid")) {
                if (FoxBaseCommonUtils.isEmpty(FoxBaseSPUtils.getInstance().getString(FoxBaseConstants.KEY_TUIA_SDK_APP_OAID, ""))) {
                    final String oaid = FoxBaseOAUtils.getOAID(FoxBaseSDK.getContext());
                    if (!FoxBaseCommonUtils.isEmpty(oaid)) {
                        FoxBaseSPUtils.getInstance().setString(FoxBaseConstants.KEY_TUIA_SDK_APP_OAID, oaid);
                    }
                }
            }
            if (!FoxBaseSDK.mUnCollects.contains("sensor_info")) {
                //采集传感器信息
                SensorManager sm = (SensorManager) FoxBaseSDK.getContext().getSystemService(Context.SENSOR_SERVICE);
                List<Sensor> allSensors = sm.getSensorList(Sensor.TYPE_ALL);
                if (!FoxBaseCommonUtils.isEmpty(allSensors)) {
                    sensorList = new ArrayList<>();
                    for (Sensor sensor : allSensors) {
                        if (sensor != null) {
                            if (sensor.getType() == Sensor.TYPE_GYROSCOPE || sensor.getType() == Sensor.TYPE_MOTION_DETECT) {
                                // v3.1.2.0:只收集陀螺仪或运动传感器类型的传感器信息
                                sensorList.add(new FoxBaseSensorBean(sensor.getName(), sensor.getType(), sensor.getVendor(),
                                        sensor.getVersion(), sensor.getResolution(), sensor.getMaximumRange(), sensor.getPower()));
                            }
                        }
                    }
                }
            }
            reportData(appList, appCacheData, usageList, sensorList);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 日志上报
     * @param appList
     * @param usageList
     * @param sensorList
     */
    private void reportData(String appList, List<FoxBaseFileBean> appCacheData, List<FoxBaseUsageStatsBean> usageList, List<FoxBaseSensorBean> sensorList) {
        try {
            if (FoxBaseSDK.getContext() == null) {
                return;
            }
            mAppKey = FoxBaseCommonUtils.getAppKey();
            mAppSecret = FoxBaseCommonUtils.getAppSecret();
            if (FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
                return;
            }
            long time = System.currentTimeMillis();
            String md = FoxBaseCommonUtils.getCollectData(FoxBaseSDK.getContext(), mDataFrom, mConfigData, mAppKey, appList, appCacheData, usageList, sensorList,FoxBaseSDK.mUnCollects);
            int nonce = (int) ((Math.random() * 9 + 1) * 100000);
            String signature = FoxBaseCommonUtils.sha1("appSecret=" + mAppSecret + "&md=" + md + "&nonce=" + nonce + "&timestamp=" + time);
            HashMap<String, Object> hashMap = new HashMap<>();
            hashMap.put("time", time);
            hashMap.put("appKey", mAppKey);
            hashMap.put("nonce", nonce);
            hashMap.put("signature", signature);
            hashMap.put("md", md);
            final String sign = FoxBaseCommonUtils.encrypt(FoxBaseGsonUtil.GsonString(hashMap), FoxBaseConstants.KEY_SECRET);
            JSONObject mJSONObject = new JSONObject();
            mJSONObject.put("sign", sign);
            mJSONObject.put("app_name", FoxBaseCommonUtils.getAppName());
            mJSONObject.put("app_key", FoxBaseCommonUtils.getAppKey());
            mJSONObject.put("sdk_version", BuildConfig.VERSION_NAME);
            mJSONObject.put("package_name", FoxBaseUtils.getApp().getPackageName());
            hashMap.put("sign", sign);
            final PostRequest<String> stringGetRequest = OkGo.<String>post(FoxBaseUrl.BASE_SDK_REPORTCOLLECT);
            stringGetRequest
                    .upJson(mJSONObject.toString())
                    .execute(new StringCallback() {
                        @Override
                        public void onSuccess(Response<String> response) {

                        }

                        @Override
                        public void onError(Response<String> response) {
                            super.onError(response);
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
