package com.mediamain.android.base.util;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomManager;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.SparseIntArray;

import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.lang.reflect.Method;
import java.util.List;

import static android.content.Context.TELEPHONY_SERVICE;

/**
 * Created by ZSY on 2020-04-10.
 */
public class FoxPhoneStateUtil {

    private static final String TAG = "SimUtil";
    private static final int MASTER_CARD_TYPE_FIRST = 0; // 卡1是主卡
    private static final int MASTER_CARD_TYPE_SECOND = 1; // 卡2是主卡
    private static final int MASTER_CARD_TYPE_NONE = -1; // 无卡

    // imei
    public static String getDeviced(int soltId) {
        String deviceId = "";
        Object o = getPhoneInfo(soltId, "getDeviceId");
        if (null != o) {
            deviceId = String.valueOf(o);
        }
        return deviceId;
    }

    // imei（部分单imei机型在soltId为1的时候会返回null）
    public static String getImei(int soltId) {
        String deviceId = "";
        Object o = getPhoneInfo(soltId, "getImei");
        if (null != o) {
            deviceId = String.valueOf(o);
        }
        return deviceId;
    }

    // imsi
    public static String getSubscriberId(int subId) {
        String deviceId = "";
        Object o = getPhoneInfo(subId, "getSubscriberId");
        if (null != o) {
            deviceId = String.valueOf(o);
        }
        return deviceId;
    }

    /**
     * 插槽是否已经插满
     *
     * @return
     */
    public static boolean isMultiSim() {
        int simCount = 0;
        SparseIntArray mActiveSubIds = getActiveSubscriptionIds(getContext());
        if (mActiveSubIds != null) {
            simCount = mActiveSubIds.size();
        }
        return simCount > 1;
    }

    /**
     * 已经插入卡的数量
     * <p>
     * 版本：Android5.1及以上有效
     * 权限：android.permission.READ_PHONE_STATE
     *
     * @return
     */
    public static String getUsedSimCount() {
        String usedCount = "";
        try {
            if (ActivityCompat.checkSelfPermission(getContext(), Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
                    int count = SubscriptionManager.from(getContext()).getActiveSubscriptionInfoCount();
                    usedCount = count <= 0  ? "" : String.valueOf(count);
                }
            }
        } catch (Exception ignored) {
        }

        return usedCount;
    }

    /**
     * 获取Sim卡槽数量
     * <p>
     * 版本：Android6.0及以上有效
     *
     * @return
     */
    public static String getSimCount() {
        String simCount = "";
        try {
            TelephonyManager tm = (TelephonyManager) getContext().getSystemService(TELEPHONY_SERVICE);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                simCount = String.valueOf(tm.getPhoneCount());
            }
        } catch (Exception ignored) {
        }
        return simCount;
    }

    /**
     * 获取当前主卡Id
     * <p>
     * 版本：Android6.0及以上有效
     *
     * @return
     */
    public static int getMasterSimId() {
        // 获取主卡的 SubId
        int mDefaultSubId = -1;
        int masterSimId = -1;
        try {

            PhoneAccountHandle defAccount = null;
            TelecomManager telecomManager = null;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                telecomManager = (TelecomManager) getContext().getSystemService(Context.TELECOM_SERVICE);
            }
            Method m = telecomManager.getClass().getDeclaredMethod("getUserSelectedOutgoingPhoneAccount");
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                defAccount = (PhoneAccountHandle) m.invoke(telecomManager);
            }
            if (defAccount != null) {
                try {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                        mDefaultSubId = Integer.parseInt(defAccount.getId());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            int simCount = 0;
            int defaultSlotIndex = -1;

            SparseIntArray mActiveSubIds = getActiveSubscriptionIds(getContext());
            if (mActiveSubIds != null) {
                simCount = mActiveSubIds.size();
                // 获取主卡的 SlotId
                defaultSlotIndex = getSlotIndexBySubId(mDefaultSubId, getContext());
            }


            // 双卡，使用 defaultSlotId 来判断谁是主卡
            if (simCount == 2) {
                if (defaultSlotIndex == 1) {
                    masterSimId = MASTER_CARD_TYPE_SECOND;
                } else {
                    masterSimId = MASTER_CARD_TYPE_FIRST;
                }
            } else if (simCount == 1) { // 单卡，哪个卡能用，哪个就是主卡
                if (defaultSlotIndex == -1 && mActiveSubIds.size() > 0) {
                    int size = mActiveSubIds.size();
                    for (int i = 0; i < size; i++) {
                        defaultSlotIndex = mActiveSubIds.valueAt(i);
                    }
                }
                if (defaultSlotIndex == 0) {
                    masterSimId = MASTER_CARD_TYPE_FIRST;
                } else {
                    masterSimId = MASTER_CARD_TYPE_SECOND;
                }
            } else if (simCount == 0) { // 无卡，没有主卡
                masterSimId = MASTER_CARD_TYPE_NONE;
            }
        } catch (Exception ignored) {}
        return masterSimId;
    }

//------------------------------------------------------------Private----------------------------------------------------------------------

    //获取Sim卡信息集合
    private static SparseIntArray getActiveSubscriptionIds(Context context) {
        // 获取可用的 sim 卡
        List<SubscriptionInfo> list = null;
        if (ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
                list = SubscriptionManager.from(context).getActiveSubscriptionInfoList();
            }
        }
        return convertSubscriptionIds(list);
    }

    private static SparseIntArray convertSubscriptionIds(List<SubscriptionInfo> list) {
        SparseIntArray result = new SparseIntArray();
        if (list != null) {
            for (SubscriptionInfo item : list) {
                if (item == null) {
                    continue;
                }

                int subId = 0;
                int slotIndex = 0;
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
                    subId = item.getSubscriptionId();
                    slotIndex = item.getSimSlotIndex();
                }
                result.put(subId, slotIndex);
            }
        }
        return result.size() > 0 ? result : null;
    }

    // 通过对应关系用 SubId 获取 SlotId
    private static int getSlotIndexBySubId(int subId, Context context) {
        SparseIntArray map = getActiveSubscriptionIds(context);
        return getSlotIndexBySubId(map, subId);
    }

    private static int getSlotIndexBySubId(SparseIntArray map, int subId) {
        if (map != null) {
            return map.get(subId, -1);
        }
        return -1;
    }

    private static Class[] getMethodParamTypes(String methodName) {
        Class[] params = null;
        try {
            Method[] methods = TelephonyManager.class.getDeclaredMethods();
            for (int i = 0; i < methods.length; i++) {
                if (methodName.equals(methods[i].getName())) {
                    params = methods[i].getParameterTypes();
                    if (params.length >= 1) {
                        break;
                    }
                }
            }
        } catch (Exception e) {
        }
        return params;
    }

    private static Object getPhoneInfo(int subId, String methodName) {
        Object value = null;
        try {
            if (ActivityCompat.checkSelfPermission(FoxBaseSDK.getContext(), Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
                TelephonyManager tm = (TelephonyManager) getContext().getSystemService(TELEPHONY_SERVICE);
                if (Build.VERSION.SDK_INT >= 21) {
                    Method method = tm.getClass().getMethod(methodName, getMethodParamTypes(methodName));
                    if (subId >= 0) {
                        value = method.invoke(tm, subId);
                    }
                } else {
                    String deviceId = tm.getDeviceId();
                    if (deviceId != null && deviceId.length() == 15) {
                        value = deviceId;
                    }
                }
            }
        } catch (Exception e) {
        }
        return value;
    }

    private static Context getContext() {
        return FoxBaseSDK.getContext();
    }

}
