package com.mediamain.android.base.util;

import android.content.Context;

import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * Created by ZSY on 2020-03-26.
 */
public class FoxTimeRecordTask {

    public static final String LAST_ON_TIME = "last_on_time";
    public static final String LAST_OFF_TIME = "last_off_time";
    private static final int TIME_RECORD_INTERVAL = 5 ; //记录时间间隔（单位：秒）

    private ScheduledExecutorService mTimeService;
    private Runnable mTimeTask;

    private Context mContext;

    public FoxTimeRecordTask(Context context, Runnable timeTask, ScheduledExecutorService timeService){
        try {
            mContext = context;
            mTimeTask = timeTask;
            mTimeService = timeService;
            FoxBaseSPUtils.getInstance().setString(LAST_ON_TIME,String.valueOf(System.currentTimeMillis()));
            if (mTimeTask == null) {
                mTimeTask = new Runnable() {
                    @Override
                    public void run() {
                        startRecord();
                    }
                };
            }
            if (mTimeService == null) {
                mTimeService = Executors.newSingleThreadScheduledExecutor();
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    public void startRecordTask(){
        try {
            mTimeService.scheduleWithFixedDelay(mTimeTask,0,TIME_RECORD_INTERVAL, TimeUnit.SECONDS);
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }

    /**
     * 记录最后时间
     */
    private void startRecord(){
        FoxBaseSPUtils.getInstance().setString(LAST_OFF_TIME,String.valueOf(System.currentTimeMillis()));
    }

    public void destroy(){
        if(mTimeService != null){
            mTimeService.shutdown();
        }
    }
}
