package com.mediamain.android.base.util;

import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;

public class Hex {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};


    public static byte[] decodeHex(char[] data) throws Exception {
        int len = data.length;

        if ((len & 0x1) != 0) {
            throw new Exception("Odd number of characters.");
        }

        byte[] out = new byte[len >> 1];


        for (int i = 0, j = 0; j < len; i++) {
            int f = toDigit(data[j], j) << 4;
            j++;
            f |= toDigit(data[j], j);
            j++;
            out[i] = (byte) (f & 0xFF);
        }

        return out;
    }


    protected static int toDigit(char ch, int index) throws Exception {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new Exception("Illegal hexadecimal charcter " + ch + " at index " + index);
        }
        return digit;
    }


    public static char[] encodeHex(byte[] data) {
        int l = data.length;

        char[] out = new char[l << 1];


        for (int i = 0, j = 0; i < l; i++) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }

        return out;
    }


    public byte[] decode(byte[] array) throws Exception {
        return decodeHex((new String(array)).toCharArray());
    }


    public Object decode(Object object) throws Exception {
        try {
            char[] charArray = (object instanceof String) ? ((String) object).toCharArray() : (char[]) object;
            return decodeHex(charArray);
        } catch (ClassCastException e) {
            FoxBaseCrashUtils.reportErrorData(e);
            throw new Exception(e.getMessage());
        }
    }


    public byte[] encode(byte[] array) {
        return (new String(encodeHex(array))).getBytes();
    }


    public Object encode(Object object) throws Exception {
        try {
            byte[] byteArray = (object instanceof String) ? ((String) object).getBytes() : (byte[]) object;
            return encodeHex(byteArray);
        } catch (ClassCastException e) {
            FoxBaseCrashUtils.reportErrorData(e);
            throw new Exception(e.getMessage());
        }
    }
}
