package com.mediamain.android.hotfix;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.liulishuo.okdownload.DownloadListener;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.StatusUtil;
import com.liulishuo.okdownload.core.breakpoint.BreakpointInfo;
import com.liulishuo.okdownload.core.cause.EndCause;
import com.liulishuo.okdownload.core.cause.ResumeFailedCause;
import com.mediamain.android.PatchManipulateImp;
import com.mediamain.android.base.data.FoxBaseSDKConfigBean;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseConvertUtils;
import com.mediamain.android.base.util.FoxBaseEncryptUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.hotfix.util.FoxCommonUtils;
import com.meituan.robust.Patch;
import com.meituan.robust.PatchExecutor;
import com.meituan.robust.RobustCallBack;
import com.meituan.robust.patch.annotaion.Modify;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FoxSdkPatch {

    public static final String LOCAL_PATCH_CODE = "local_patch_code";
    public static final String LOCAL_PATCH_VERSION = "local_patch_version";
    public static final String LOCAL_PATCH_URL = "local_patch_url";
    public static final String LOAD_PATCH_TYPE = "load_patch_type";//下载：1 加载本地：0
    public static final String REAL_LOAD_PATCH_TYPE = "real_load_patch_type";//下载：1 加载本地：0

    public static long patchCode = 0;
    public static String patchVersion = "";
    private static ExecutorService mFixedThreadPool;
    private static DownloadTask mDownloadTask;
    private static PatchExecutor mPatchExecutor;
    private static int patchLogEnable;//是否打印热更新的补打日志
    private static String mTrackId = "";

    /**
     * 补丁初始化处理
     *
     * @param context
     * @param dataBean
     */
    public static void init(Context context, FoxBaseSDKConfigBean.DataBean dataBean) {
        if (null == dataBean) {
            return;
        }
        patchLogEnable = dataBean.getPatchLogEnable();//日志开关
        mTrackId = dataBean.getTrackId();//日志唯一标识
        patchCode = FoxBaseConvertUtils.String2Long(dataBean.getLastPatchCode());
        patchVersion = dataBean.getLastPatchVersion();
        //打印初始化日志
        FoxCommonUtils.fixAddPatchLogUpload(10, "1", patchLogEnable, "", dataBean.getTrackId());

        if (FoxBaseCommonUtils.isEmpty(dataBean.getLastPatchUrl()) || dataBean.getPatchEnable() == 0) {
            //关闭补丁
            return;
        }
        //记录补丁地址
        try {
            initFix(context);

            FoxBaseSPUtils.getInstance().setString(LOCAL_PATCH_URL, dataBean.getLastPatchUrl());
            long localPatchCode = FoxBaseSPUtils.getInstance().getLong(LOCAL_PATCH_CODE, 0);
            String localatchVersion = FoxBaseSPUtils.getInstance().getString(LOCAL_PATCH_VERSION, "");

            int isRollback = dataBean.getRollbackEnable();
            File patchFile = new File(FoxCommonUtils.getPatchLocalPath(context), "fox.jar");

            if (patchCode > localPatchCode || isRollback == 1 || !patchFile.exists()) {
                //下载远程 = 1
                FoxBaseSPUtils.getInstance().setInt(LOAD_PATCH_TYPE, 1);
                downloadPatch(context);
            } else {
                //加载本地 = 0
                FoxBaseSPUtils.getInstance().setInt(LOAD_PATCH_TYPE, 0);
                startFix();
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }

    }

    /**
     * 初始化修复
     *
     * @param context
     */
    private static void initFix(Context context) {
        //  创建1个固定线程的线程池，用于串行进行本地补丁的加载和网络请求补丁然后加载的逻辑
        mFixedThreadPool = Executors.newFixedThreadPool(1);

        // 创建网络请求补丁然后加载的线程
        mPatchExecutor = new PatchExecutor(context.getApplicationContext(), new PatchManipulateImp(), new RobustCallBack() {
            @Override
            public void onPatchListFetched(boolean result, boolean isNet, List<Patch> patches) {
                StringBuilder sb = null;
                if (patches != null) {
                    sb = new StringBuilder(patches.size());
                    for (Patch p : patches) {
                        sb.append(p.getName()).append(",");
                    }
                }
                FoxBaseLogUtils.eTag("PatchExecutor", "获取补丁列表后，回调此方法: " + "result=" + result + ";isNet=" + isNet + ";patches=" + (sb == null ? "null" : sb.toString()));
            }

            @Override
            public void onPatchFetched(boolean result, boolean isNet, Patch patch) {
                FoxBaseLogUtils.eTag("PatchExecutor", "在获取补丁后，回调此方法: " + "result=" + result + ";isNet=" + isNet + ";patch=" + (patch == null ? "null" : patch.getName()));
            }

            @Override
            public void onPatchApplied(boolean result, Patch patch) {
                FoxBaseLogUtils.eTag("PatchExecutor", "在补丁应用后，回调此方法: " + "result=" + result + ";patch=" + (patch == null ? "null" : patch.getName()));
                //埋点
                FoxCommonUtils.fixPatchLogUpload(2, result ? "1" : "2", mTrackId);
            }

            @Override
            public void logNotify(String log, String where) {
                FoxBaseLogUtils.eTag("App", "RobustCallBack提示log: " + "log=" + log + ";where=" + where);
            }

            @Override
            public void exceptionNotify(Throwable throwable, String where) {
                FoxBaseLogUtils.eTag("PatchExecutor", "RobustCallBack提示异常: " + "throwable=" + throwable.getMessage() + ";where=" + where);
            }
        });
    }

    /**
     * 开始修复
     */
    private static void startFix() {
        if (null != mFixedThreadPool && null != mPatchExecutor) {
            FoxBaseLogUtils.eTag("fixfix", "开始修复");
            mFixedThreadPool.execute(mPatchExecutor);
        }
    }

    /**
     * 下载补丁
     *
     * @param context
     */
    private static void downloadPatch(Context context) {
        final String url = FoxBaseSPUtils.getInstance().getString(LOCAL_PATCH_URL, "");
        FoxBaseLogUtils.eTag("fixfix", "补丁下载链接 ===" + url);
        if (FoxBaseCommonUtils.isEmpty(url)) {
            return;
        }

        final String localPath = FoxCommonUtils.getPatchLocalPath(context);
        mDownloadTask = new DownloadTask.Builder(url, localPath, "fox.jar")
                // the minimal interval millisecond for callback fox_progress
                .setMinIntervalMillisCallbackProcess(30)
                // do re-download even if the task has already been completed in the past.
                .setPassIfAlreadyCompleted(false)
                .setAutoCallbackToUIThread(true)
                .setConnectionCount(3)
                .setMinIntervalMillisCallbackProcess(300)
                .build();
        mDownloadTask.addTag(1, FoxBaseEncryptUtils.encryptMD5ToString(url));
        StatusUtil.Status status = StatusUtil.getStatus(mDownloadTask);
        if (status != StatusUtil.Status.RUNNING) {
            mDownloadTask.enqueue(new DownloadListener() {

                @Override
                public void taskStart(@NonNull DownloadTask task) {
                    //开始下载
                    FoxBaseLogUtils.eTag("fixfix", "开始下载");
                    FoxCommonUtils.fixAddPatchLogUpload(11, "1", patchLogEnable, "", mTrackId);
                }

                @Override
                public void connectTrialStart(@NonNull DownloadTask task, @NonNull Map<String, List<String>> requestHeaderFields) {
                    FoxBaseLogUtils.eTag("fixfix", "connectTrialStart ===");
                }

                @Override
                public void connectTrialEnd(@NonNull DownloadTask task, int responseCode, @NonNull Map<String, List<String>> responseHeaderFields) {
                    FoxBaseLogUtils.eTag("fixfix", "connectTrialEnd ===");
                }

                @Override
                public void downloadFromBeginning(@NonNull DownloadTask task, @NonNull BreakpointInfo info, @NonNull ResumeFailedCause cause) {
                    FoxBaseLogUtils.eTag("fixfix", "downloadFromBeginning ===");
                }

                @Override
                public void downloadFromBreakpoint(@NonNull DownloadTask task, @NonNull BreakpointInfo info) {
                    FoxBaseLogUtils.eTag("fixfix", "downloadFromBreakpoint ===");
                }

                @Override
                public void connectStart(@NonNull DownloadTask task, int blockIndex, @NonNull Map<String, List<String>> requestHeaderFields) {
                    FoxBaseLogUtils.eTag("fixfix", "connectStart ===");
                }

                @Override
                public void connectEnd(@NonNull DownloadTask task, int blockIndex, int responseCode, @NonNull Map<String, List<String>> responseHeaderFields) {
                    FoxBaseLogUtils.eTag("fixfix", "connectEnd ===");
                }

                @Override
                public void fetchStart(@NonNull DownloadTask task, int blockIndex, long contentLength) {
                    FoxBaseLogUtils.eTag("fixfix", "fetchStart ===");
                    FoxCommonUtils.fixAddPatchLogUpload(12, "1", patchLogEnable, "", mTrackId);
                }

                @Override
                public void fetchProgress(@NonNull DownloadTask task, int blockIndex, long mincreaseBytes) {
                    //下载中
                    FoxBaseLogUtils.eTag("fixfix", "fetchProgress ===");
                }

                @Override
                public void fetchEnd(@NonNull DownloadTask task, int blockIndex, long contentLength) {
                    FoxBaseLogUtils.eTag("fixfix", "fetchEnd ===");
                    FoxCommonUtils.fixAddPatchLogUpload(13, "1", patchLogEnable, "", mTrackId);
                }

                @Override
                public void taskEnd(@NonNull DownloadTask task, @NonNull EndCause cause, @Nullable Exception realCause) {
                    try {
                        FoxCommonUtils.fixAddPatchLogUpload(14, "1", patchLogEnable, null != cause ? cause.name() : "", mTrackId);
                        FoxBaseLogUtils.eTag("fixfix", "下载结束 =");
                        if (task != null) {
                            task.cancel();
                        }
                        if (cause != null) {
                            FoxBaseLogUtils.eTag("fixfix", "下载完成cause.name() =" + cause.name());
                            if (cause.name().contains(EndCause.ERROR.name())) {
                                //下载异常(埋点)
                                FoxCommonUtils.fixPatchLogUpload(FoxSdkPatch.patchVersion, 1, "2", mTrackId);
                                FoxCommonUtils.fixPatchLogUpload(FoxSdkPatch.patchVersion, 2, "2", mTrackId);

                                //加载本地 = 0
                                FoxBaseSPUtils.getInstance().setInt(REAL_LOAD_PATCH_TYPE, 0);
                            } else if (cause.name().contains(EndCause.COMPLETED.name())) {
                                //记录本地最新的补丁版本
                                FoxBaseSPUtils.getInstance().setLong(LOCAL_PATCH_CODE, FoxSdkPatch.patchCode);
                                FoxBaseSPUtils.getInstance().setString(LOCAL_PATCH_VERSION, FoxSdkPatch.patchVersion);
                                //下载远程 = 1
                                FoxBaseSPUtils.getInstance().setInt(REAL_LOAD_PATCH_TYPE, 1);
                                //下载完成(埋点)
                                FoxCommonUtils.fixPatchLogUpload(1, "1", mTrackId);

                            }
                        }
                        //开始修复
                        startFix();
                    } catch (Exception e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                        e.printStackTrace();
                    } finally {
                        FoxBaseLogUtils.eTag("fixfix", "下载完成 finally");
                    }
                }
            });
        }

    }


    @Modify
    public static void callBugMethod(Context context) {

//        String strFromCPlus = NdkHelper.getStrFromCPlus();
//
//        Logger.e(strFromCPlus);
//        int i = Integer.parseInt("sadad");
        try {
            int i = Integer.parseInt("sasasasa");
        } catch (NumberFormatException e) {
            e.printStackTrace();
//            Log.e("fixfix","我是第一个补丁");
//            Toast.makeText(context, "3323补丁测试", Toast.LENGTH_SHORT).show();
//            MyClass.call();
//            MyClass.call2abc();
//            addMethod();
//            addMethod(context);
        }
//        MyClass.call();

    }

//    @Modify
//    public static void addMethod(){
//    }

//    @Add
//    public static class MyClass {
//        public static void call() {
//            Toast.makeText(FoxBaseSDK.getContext(), "3100新增了一个静态内部类", Toast.LENGTH_SHORT).show();
//        }
//    }

}
