package com.mediamain.android.hotfix.util;

import android.content.Context;

import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.FoxBaseSPUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.hotfix.FoxSdkPatch;

import java.io.File;
import java.util.HashMap;

import static com.mediamain.android.hotfix.FoxSdkPatch.LOCAL_PATCH_CODE;
import static com.mediamain.android.hotfix.FoxSdkPatch.LOCAL_PATCH_VERSION;

/**
 * Created by ZSY on 2020-08-13.
 */

public class FoxCommonUtils {

    public static String getPatchLocalPath(Context context){
        String path = "";
        try {
            path = context.getFilesDir() + File.separator +"foxes";
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return path;
    }

    /**
     * 热修复埋点上传
     * @param type 1:下载 2：补丁是否生效
     * @param status 1：成功 2：失败
     */
    public static void fixPatchLogUpload(int type, String status,String trackId){
        try {
            FoxBaseMaidianUtil foxBaseMaidianUtil = FoxBaseMaidianUtil.build(type);
            HashMap<String,String> hashMap = new HashMap<>();
            hashMap.put("patch_version", FoxBaseSPUtils.getInstance().getString(LOCAL_PATCH_VERSION,""));
            hashMap.put("status", status);
            hashMap.put("operateType", "3"); // 热修复类型：3
            hashMap.put("track_id", trackId);
            hashMap.put("remote_version", FoxSdkPatch.patchVersion);
            if(null != hashMap) {
                foxBaseMaidianUtil.set(hashMap);
            }
            foxBaseMaidianUtil.postScmLog(null);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 热修复埋点上传(补丁号)
     * @param patch_version 补丁版本
     * @param type 1:下载 2：补丁是否生效
     * @param status 1：成功 2：失败
     */
    public static void fixPatchLogUpload(String patch_version, int type, String status,String trackId){
        try {
            FoxBaseMaidianUtil foxBaseMaidianUtil = FoxBaseMaidianUtil.build(type);
            HashMap<String,String> hashMap = new HashMap<>();
            hashMap.put("patch_version", patch_version);
            hashMap.put("status", status);
            hashMap.put("operateType", "3"); // 热修复类型：3
            hashMap.put("track_id", trackId);
            hashMap.put("remote_version", FoxSdkPatch.patchVersion);
            if(null != hashMap) {
                foxBaseMaidianUtil.set(hashMap);
            }
            foxBaseMaidianUtil.postScmLog(null);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 热修复埋点上传（补打）
     * @param type 1:下载 2：补丁是否生效
     * @param status 1：成功 2：失败
     */
    public static void fixAddPatchLogUpload(int type, String status, int patchEnable, String otherReMark,String trackId){
        try {
            String remark = "";
            if(patchEnable != 1){
                return;
            }
            try {
                remark = String.format("LocalPatchCode = %d OtherReMark = %s patchEnable=%d",FoxBaseSPUtils.getInstance().getLong(LOCAL_PATCH_CODE,0),otherReMark,patchEnable);
            } catch (Exception ignored){
                FoxBaseCrashUtils.reportErrorData(ignored);
            }
            FoxBaseMaidianUtil foxBaseMaidianUtil = FoxBaseMaidianUtil.build(type);
            HashMap<String,String> hashMap = new HashMap<>();
            hashMap.put("patch_version", FoxBaseSPUtils.getInstance().getString(LOCAL_PATCH_VERSION,""));
            hashMap.put("status", status);
            hashMap.put("operateType", "3"); // 热修复类型：3
            hashMap.put("remark", remark);
            hashMap.put("track_id", trackId);
            hashMap.put("remote_version", FoxSdkPatch.patchVersion);
            if(null != hashMap) {
                foxBaseMaidianUtil.set(hashMap);
            }
            foxBaseMaidianUtil.postScmLog(null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
