package com.mediamain.android.nativead;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.webkit.WebBackForwardList;
import android.webkit.WebHistoryItem;
import android.webkit.WebView;
import android.widget.FrameLayout;

import com.mediamain.android.BuildConfig;
import com.mediamain.android.base.config.FoxSDKError;
import com.mediamain.android.base.config.AutoConfig;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.okgo.OkGo;
import com.mediamain.android.base.okgo.request.PostRequest;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseKeyboardUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.FoxBaseScreenUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.base.util.xpopup.XPopup;
import com.mediamain.android.base.util.xpopup.core.BasePopupView;
import com.mediamain.android.base.util.xpopup.interfaces.XPopupCallback;
import com.mediamain.android.nativead.jsbridge.BridgeHandler;
import com.mediamain.android.nativead.jsbridge.CallBackFunction;
import com.mediamain.android.nativead.jsbridgeimpl.BaseJsBridgeWebView;
import com.mediamain.android.nativead.jsbridgeimpl.impl.DefaultCallBackFunction;
import com.mediamain.android.nativead.util.TuiaUtil;
import com.mediamain.android.view.interfaces.ServingCallback;
import com.mediamain.android.view.util.FoxViewMaidianUtils;
import com.mediamain.android.view.bean.FoxResponseBean;

import org.json.JSONObject;

import java.util.UUID;

public class Ad {
    /**
     * webview 空白也url
     */
    protected static final String BLANK_URL = "about:blank";
    protected String mActivityHost;
    /**
     * 活动类型
     */
    protected static final int DIALOG_AD_TYPE_ACTIVITY = 100;
    /**
     * 奖励类型
     */
    protected static final int DIALOG_AD_TYPE_REWARD = 200;
    /**
     * 普通的引擎链接地址
     */
    protected static final String ROOT_AD_PATH_COMM = AutoConfig.getConfigHostComm();
    /**
     * 更多福利的引擎链接地址
     */
    protected static final String ROOT_AD_PATH_MORE = AutoConfig.getConfigHostMore();
    /**
     * 老版引擎链接地址
     */
    protected static final String ROOT_AD_PATH_COMM_OLD = AutoConfig.getConfigHostOldComm();
    protected static final String ROOT_AD_PATH_MORE_OLD = AutoConfig.getConfigHostOldMore();
    private static final String TAG = "FoxNewNativeAd";
    /**
     * 展示活动的activity
     */
    private Activity mActivity;

    /**
     * 暴露给媒体的回调
     */
    private AdCallBack mAdCallBack;

    /**
     * 嵌入式GG容器
     */
    private FrameLayout mAdWrap;
    private int mUseLoading = AD_NEW_LOADING_SHOW;
    private String mSlotId;
    private String mDeviceId;
    private String mUserId;
    private String mAppKey;
    private String mAppSecret;
    private String md;
    private int nonce;
    private long timestamp;
    private String signature;
    private String imei;
    /**
     * GG结果
     */
    private FoxResponseBean.DataBean mData;

    private boolean isRewadShow;
    private boolean isLandPageShow;

    public String getAppKey() {
        return mAppKey;
    }

    public String getSlotId() {
        return mSlotId;
    }

    public String getDeviceId() {
        return mDeviceId;
    }

    public String getUserId() {
        return mUserId;
    }

    public FrameLayout getAdWrap() {
        return mAdWrap;
    }

    /**
     * 下载dialog
     */
    private BasePopupView mDownloadDialog;
    /**
     * 活动dialog
     */
    private BasePopupView mActivityDialog;
    /**
     * 奖励dialog
     */
    private BasePopupView mRewardDialog;
    /**
     * 我的奖品页dialog。。。
     */
    private BasePopupView mMyPrizeDialog;
    /**
     * 活动webView
     */
    private AdWebView mActivityWebView;
    /**
     * 奖励或者我的奖品页webView
     */
    private AdWebView mRewardWebView;
    /**
     * 嵌入式webView
     */
    private AdWebView mInsertWebView;


    protected AdWebView getActivityWebView() {
        return mActivityWebView;
    }

    protected BasePopupView getMyPrizeDialog() {
        return mMyPrizeDialog;
    }

    protected AdWebView getRewardWebView() {
        return mRewardWebView;
    }

    protected AdWebView getInsertWebView() {
        return mInsertWebView;
    }

    protected AdCallBack getAdCallBack() {
        return mAdCallBack;
    }

    protected BasePopupView getActivityDialog() {
        return mActivityDialog;
    }

    protected BasePopupView getRewardDialog() {
        return mRewardDialog;
    }

    public FoxResponseBean.DataBean getData() {
        return mData;
    }

    public String getActivityHost() {
        return mActivityHost;
    }

    public void setActivityHost(String mActivityHost) {
        this.mActivityHost = mActivityHost;
    }

    protected Activity getActivity() {
        return mActivity;
    }

    public boolean isRewadShow() {
        return isRewadShow;
    }

    public void setRewadShow(boolean rewadShow) {
        isRewadShow = rewadShow;
    }

    public boolean isLandPageShow() {
        return isLandPageShow;
    }

    public void setLandPageShow(boolean landPageShow) {
        isLandPageShow = landPageShow;
    }

    /**
     * 普通
     */
    private String mCommEngineUrl;
    /**
     * 更多
     */
    private String mMoreEngineUrl;

    /**
     * 是否点击
     */
    private boolean is_clicked = false;
    /**
     * 是否曝光
     */
    private boolean is_exposure = false;

    public static final int AD_URL_OLD = 1;
    public static final int AD_URL_NEW = 2;

    public static final int AD_NEW_LOADING_HIDE = 0;
    public static final int AD_NEW_LOADING_SHOW = 1;

    private int ad_type = AD_URL_NEW;

    protected String getCommEngineUrl() {
        return mCommEngineUrl;
    }

    protected String getMoreEngineUrl() {
        return mMoreEngineUrl;
    }

    public int getAd_type() {
        return ad_type;
    }

    public Ad(String appKey, String slotId) {
        this(appKey, slotId, "", "",AD_NEW_LOADING_SHOW);
    }

    public Ad(String appKey, String slotId, String userId) {
        this(appKey, slotId, userId, "",AD_NEW_LOADING_SHOW);
    }

    public Ad(String appKey, String slotId, String userId,String deviceId) {
        this(appKey, slotId, userId, deviceId,AD_NEW_LOADING_SHOW);
    }

    public Ad(String appKey, String slotId, String userId, String deviceId,int useLoading) {
        mAppKey = FoxBaseCommonUtils.getAppKey();
        mAppSecret = FoxBaseCommonUtils.getAppSecret();
        TuiaAdConfig.setAppKey(mAppKey);
        TuiaAdConfig.setAppSecret(mAppSecret);
        this.mSlotId = slotId;
        this.mUserId = userId;
        this.mDeviceId = deviceId;
        this.mUseLoading = useLoading;
    }

    /**
     * 手动调用配置
     *
     * @param appKey
     * @param appSecret
     */
    public void setConfigInfo(String appKey, String appSecret) {
        if (!FoxBaseCommonUtils.isEmpty(appKey) && !FoxBaseCommonUtils.isEmpty(appSecret)){
            this.mAppKey = appKey;
            this.mAppSecret = appSecret;
            TuiaAdConfig.setAppKey(appKey);
            TuiaAdConfig.setAppSecret(appSecret);
        }
    }

    public void init(Activity activity, FrameLayout adWrap, int ad_type, AdCallBack adCallBack) {
        this.mActivity = activity;
        this.mAdWrap = adWrap;
        this.mAdCallBack = adCallBack;
        this.ad_type = ad_type;
        if (TextUtils.isEmpty(mDeviceId)) {
            mDeviceId = TuiaUtil.getPhoneSign(activity);
        }
        if (!BuildConfig.Release) {
            mDeviceId = "tuia" + UUID.randomUUID().toString();
        }
        if (TextUtils.isEmpty(mUserId)) {
            mUserId = mDeviceId;
        }
        FoxBaseLogUtils.vTag(TAG, "deviceId====>" + mDeviceId);
        initUrl();

        FoxBaseLogUtils.vTag(TAG, "mCommEngineUrl====>" + mCommEngineUrl);
        initWebView();
        if (mAdWrap == null) {
            initDialogAd(DIALOG_AD_TYPE_ACTIVITY);
            initDialogAd(DIALOG_AD_TYPE_REWARD);
            initMyPrizeDialog();
        } else {
            initDialogAd(DIALOG_AD_TYPE_REWARD);
            initInsertAd();
            initMyPrizeDialog();
        }
        setWebviewClient();
        FoxBaseMaidianUtil.build("init", this).postNativeAd();
        registerSoftInput(activity);
    }

    private void initUrl() {
        switch (ad_type) {
            case AD_URL_OLD:
                mCommEngineUrl = String.format(ROOT_AD_PATH_COMM_OLD, BuildConfig.VERSION_NAME, BuildConfig.VERSION_CODE, mAppKey, mSlotId, mUserId,
                        mDeviceId,mUseLoading);
                mMoreEngineUrl = String.format(ROOT_AD_PATH_MORE_OLD, BuildConfig.VERSION_NAME, BuildConfig.VERSION_CODE, mAppKey, mSlotId, mUserId,
                        mDeviceId,mUseLoading);
                break;
            case AD_URL_NEW:
                mCommEngineUrl = String.format(ROOT_AD_PATH_COMM, BuildConfig.VERSION_NAME, BuildConfig.VERSION_CODE, mAppKey, mSlotId, mUserId,
                        mDeviceId,mUseLoading, getAdWrap() != null);
                mMoreEngineUrl = String.format(ROOT_AD_PATH_MORE, BuildConfig.VERSION_NAME, BuildConfig.VERSION_CODE, mAppKey, mSlotId, mUserId,
                        mDeviceId,mUseLoading, getAdWrap() != null);
                break;
            default:
                break;
        }
    }

    /**
     * 请求GG
     */
    public void loadAd(Activity activity, final boolean isCache) {
        try {
            FoxBaseLogUtils.dTag(TAG, "——>loadAdRequest->start");
            if (FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
                mAppKey = FoxBaseCommonUtils.getAppKey();
                mAppSecret = FoxBaseCommonUtils.getAppSecret();
            }
            if (FoxBaseCommonUtils.isEmpty(mSlotId) || FoxBaseCommonUtils.isEmpty(mAppKey) || FoxBaseCommonUtils.isEmpty(mAppSecret)) {
                if (mAdCallBack != null) {
                    mAdCallBack.onFailedToReceiveAd(FoxSDKError.INVALID_PARAM.getCode(), FoxSDKError.INVALID_PARAM.getMessage());
                }
                return;
            }
            TuiaAdConfig.setAppKey(mAppKey);
            TuiaAdConfig.setAppSecret(mAppSecret);
            FoxBaseLogUtils.dTag(TAG, "——>loadAdRequest");
            md = FoxBaseCommonUtils.getMD(mSlotId);
            nonce = (int) ((Math.random() * 9 + 1) * 100000);
            timestamp = System.currentTimeMillis();
            signature = FoxBaseCommonUtils.sha1("appSecret=" + mAppSecret + "&md=" + md + "&nonce=" + nonce + "&timestamp=" + timestamp);
            imei = FoxBaseCommonUtils.getIMEI();
            final PostRequest<String> stringGetRequest = OkGo.<String>post(AutoConfig.getConfigHostUrl());
            stringGetRequest.params("adslotId", mSlotId)
                    .params("appKey", mAppKey)
                    .params("md", md)
                    .params("timestamp", timestamp)
                    .params("nonce", nonce)
                    .params("signature", signature)
                    .params("sourceType", "1")
                    .params("isimageUrl", "1")
                    .params("device_id", imei + "")
                    .params("slotAccessType", 2)
                    .params("slotSceneType", Integer.toString(FoxSDKType.NATIVE_AD.getCode()));
            if (!FoxBaseCommonUtils.isEmpty(mUserId)) {
                stringGetRequest.params("userId", mUserId);
            }
            // isCache为true：使用素材，false：直接展示活动页
            // 使用素材就需要判断imgUrl或imageUrlList
            stringGetRequest.execute(new ServingCallback(isCache) {
                @Override
                public void onServingDataCorrect(FoxResponseBean.DataBean data) {
                    mData = data;
                    if (!FoxBaseCommonUtils.isEmpty(mUserId)) {
                        if (data.getActivityUrl().contains("?")) {
                            mData.setActivityUrl(data.getActivityUrl() + "&userId=" + mUserId);
                        } else {
                            mData.setActivityUrl(data.getActivityUrl() + "?userId=" + mUserId);
                        }
                    }
                    is_exposure = false;
                    is_clicked = false;
                    if (mAdCallBack != null) {
                        mAdCallBack.onReceiveAd();
                        if (mAdCallBack instanceof  DefaultAdCallBack){
                            ((DefaultAdCallBack)mAdCallBack).onReceiveAd(mData);
                        }
                    }
                    if (!isCache) {
                        show();
                    }
                }

                @Override
                public void onServingDataError(int code, String message) {
                    if (mAdCallBack != null) {
                        mAdCallBack.onFailedToReceiveAd(code, message);
                    }
                }
            });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            if (mAdCallBack != null) {
                mAdCallBack.onFailedToReceiveAd(FoxSDKError.UNKNOWN.getCode(), FoxSDKError.UNKNOWN.getMessage());
            }
        }
    }


    /**
     * GG曝光上报
     */
    public void adExposed() {
        if (!is_exposure) {
            doResponse(0);
            is_exposure = true;
        }
    }

    /**
     * GG点击上报
     */
    private void adClicked() {
        if (!is_clicked) {
            doResponse(1);
            is_clicked = true;
        }
    }

    /**
     * 上报接口
     *
     * @param logType 0 曝光
     *                1 点击
     */
    private void doResponse(int logType) {
        try {
            ArrayMap<String, String> params = new ArrayMap<>();
            params.put("slotAccessType", "2");
            FoxViewMaidianUtils.doResponse(logType, mData, params);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }


    /**
     * 重置广告位Id 重置以后必须重新调用show方法
     *
     * @param slotId
     */
    public void resetSlotId(String slotId) {
        this.mSlotId = slotId;
        initUrl();
    }

    /**
     * 展示互动GG
     */
    public void show() {
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
        if (mAdWrap == null) {
            // 弹窗式GG
            if (mActivityWebViewClient != null) {
                mActivityWebViewClient.setNeedClearHistory(true);
            }
            if (mActivityWebView!=null){
                if (mData != null && !FoxBaseCommonUtils.isEmpty(mData.getActivityUrl())){
                    adClicked();
                    mActivityWebView.loadUrl(mData.getActivityUrl());
                }else {
                    mActivityWebView.loadUrl(mCommEngineUrl);
                }
                mActivityDialog.show();
            }
        } else {
            // 嵌入式GG
            if (mInsertWebView != null) {
                if (mData != null && !FoxBaseCommonUtils.isEmpty(mData.getActivityUrl())){
                    adClicked();
                    mInsertWebView.loadUrl(mData.getActivityUrl());
                }else {
                    mInsertWebView.loadUrl(mCommEngineUrl);
                }
            }
        }
        FoxBaseMaidianUtil.build("show", this).postNativeAd();
        FoxBaseLogUtils.dTag(TAG,  "——>show()");
    }


    /**
     * 隐藏互动GG
     */
    public void hide() {
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
        if (mRewardDialog != null && mRewardDialog.isShow()) {
            mRewardDialog.dismiss();
        }
        if (mActivityDialog != null && mActivityDialog.isShow()) {
            mActivityDialog.dismiss();
        }

        if (mMyPrizeDialog != null && mMyPrizeDialog.isShow()) {
            mMyPrizeDialog.dismiss();
        }
        FoxBaseMaidianUtil.build("hide", this).postNativeAd();
        FoxBaseLogUtils.dTag(TAG, "——>hide()");
    }

    /**
     * 注册软键盘回调 解决虚拟奖品和落地页软键盘挡住输入框的问题
     */
    private void registerSoftInput(Activity activity) {
        try {
            FoxBaseKeyboardUtils.fixAndroidBug5497(activity);
            FoxBaseKeyboardUtils.registerSoftInputChangedListener(activity, new FoxBaseKeyboardUtils.OnSoftInputChangedListener() {
                @RequiresApi(api = Build.VERSION_CODES.ICE_CREAM_SANDWICH)
                @Override
                public void onSoftInputChanged(int height) {
                    try {
                        //嵌入式我的奖品页视图上移
                        if (mActivityDialog == null && mMyPrizeDialog != null && mMyPrizeDialog.isShow()) {
                            AdMyPrizeDialog myPrizeDialog = (AdMyPrizeDialog) mMyPrizeDialog;
                            WebView webView = myPrizeDialog.getAdWebView();
                            if (webView != null && webView.getParent() != null && webView.getParent() instanceof FrameLayout) {
                                FrameLayout webViewWrap = (FrameLayout) webView.getParent();
                                webViewWrap.animate()
                                        .translationY(-(height / 2))
                                        .setDuration(200)
                                        .setInterpolator(new OvershootInterpolator(0))
                                        .start();

                            }
                        }

                        //奖励弹窗视图上移
                        if (mRewardWebView != null && mRewardWebView.getParent() != null && mRewardWebView.getParent() instanceof FrameLayout) {
                            FrameLayout webViewWrap = (FrameLayout) mRewardWebView.getParent();
                            webViewWrap.animate().translationY(-(height / 2))
                                    .setDuration(200)
                                    .setInterpolator(new OvershootInterpolator(0))
                                    .start();
                        }
                        //我的奖品页视图上移
                        if (mRewardDialog != null && mRewardDialog.isDismiss()) {
                            if (mActivityWebView != null && mActivityWebView.getParent() != null && mActivityWebView.getParent() instanceof FrameLayout) {
                                FrameLayout webViewWrap = (FrameLayout) mActivityWebView.getParent();
                                webViewWrap.animate().translationY(-(height / 2))
                                        .setDuration(200)
                                        .setInterpolator(new OvershootInterpolator(0))
                                        .start();
                            }
                        }
                    } catch (Exception e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 初始化webview
     */
    @RequiresApi(api = Build.VERSION_CODES.CUPCAKE)
    private void initWebView() {
        try {
            if (mAdWrap == null) {
                mActivityWebView = new AdWebView(mActivity,this, BaseJsBridgeWebView.WEBVIEW_TYPE_ACTIVITY);
                //水平不显示
                mActivityWebView.setHorizontalScrollBarEnabled(false);
                //垂直不显示
                mActivityWebView.setVerticalScrollBarEnabled(false);
                mActivityWebView.setScrollContainer(false);
                //解决webview抢占焦点的问题
//        mActivityWebView.setFocusable(false);
//        mActivityWebView.setFocusableInTouchMode(false);
//        mActivityWebView.setBackgroundColor(ContextCompat.getColor(mActivity, R.color.color_00ff00));
            } else {
                mInsertWebView = new AdWebView(mActivity,this, BaseJsBridgeWebView.WEBVIEW_TYPE_INSERT);
                //水平不显示
                mInsertWebView.setHorizontalScrollBarEnabled(false);
                //垂直不显示
                mInsertWebView.setVerticalScrollBarEnabled(false);
                mInsertWebView.setScrollContainer(false);
                //解决webview抢占焦点的问题
//        mInsertWebView.setFocusable(false);
//        mInsertWebView.setFocusableInTouchMode(false);
            }

            mRewardWebView = new AdWebView(mActivity,this, BaseJsBridgeWebView.WEBVIEW_TYPE_REWARD);
            //水平不显示
            mRewardWebView.setHorizontalScrollBarEnabled(false);
            //垂直不显示
            mRewardWebView.setVerticalScrollBarEnabled(false);
            mRewardWebView.setScrollContainer(false);

            mRewardWebView.registerHandler("rewardClose", new BridgeHandler() {
                @Override
                public void handler(String data, CallBackFunction function) {
                    if (mRewardDialog != null)
                        mRewardDialog.dismiss();
                }
            });
            //解决webview抢占焦点的问题
//        mRewardWebView.setFocusable(false);
//        mRewardWebView.setFocusableInTouchMode(false);
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }

    }

    private AdWebViewClient mActivityWebViewClient;
    private AdWebViewClient mRewardWebViewClient;

    protected AdWebViewClient getActivityWebViewClient() {
        return mActivityWebViewClient;
    }

    protected AdWebViewClient getRewardWebViewClient() {
        return mRewardWebViewClient;
    }

    /**
     * 设置GG的webviewClient
     */
    private void setWebviewClient() {
        if (mActivityWebView != null) {
            mActivityWebView.setWebChromeClient(new AdWebChromeClient(this));
            H5CallBackImpl activityH5CallBack = new H5CallBackImpl(this);
            WebViewCallBackImpl activityWebViewCallBack = new WebViewCallBackImpl(this);
            mActivityWebViewClient = new AdWebViewClient(this, mActivityWebView, activityWebViewCallBack, activityH5CallBack);
            mActivityWebView.setWebViewClient(mActivityWebViewClient);
        }
        if (mRewardWebView != null) {
            mRewardWebView.setWebChromeClient(new AdWebChromeClient(this));
            H5CallBackImpl rewardH5CallBack = new H5CallBackImpl(this);
            WebViewCallBackImpl rewardWebViewCallBack = new WebViewCallBackImpl(this);
            mRewardWebViewClient = new AdWebViewClient(this, mRewardWebView, rewardWebViewCallBack, rewardH5CallBack);
            mRewardWebView.setWebViewClient(mRewardWebViewClient);
        }
    }

    AdWebViewClient mInsertAdWebViewClient;

    protected AdWebViewClient getInsertAdWebViewClient() {
        return mInsertAdWebViewClient;
    }

    /**
     * 初始化嵌入式GG
     */
    private void initInsertAd() {
        H5CallBackImpl insertH5CallBackImpl = new H5CallBackImpl(this);
        WebViewCallBackImpl insertWebViewCallBackImpl = new WebViewCallBackImpl(this);
        mInsertWebView.setWebChromeClient(new AdWebChromeClient(this));
        mInsertAdWebViewClient = new AdWebViewClient(this, mInsertWebView, insertWebViewCallBackImpl, insertH5CallBackImpl);
        mInsertWebView.setWebViewClient(mInsertAdWebViewClient);
        if (mInsertWebView.getParent() != null) {
            ((ViewGroup) mInsertWebView.getParent()).removeAllViews();
        }
        mAdWrap.addView(mInsertWebView);

        FrameLayout.LayoutParams param = (FrameLayout.LayoutParams) mInsertWebView.getLayoutParams();
        param.width = ViewGroup.LayoutParams.MATCH_PARENT;
        param.height = ViewGroup.LayoutParams.MATCH_PARENT;
        param.gravity = Gravity.CENTER;
        mInsertWebView.setLayoutParams(param);
    }

    /**
     * 初始化活动弹窗GG类型
     */
    private void initDialogAd(int dialogAdType) {
        AdWebView adWebView;
        if (dialogAdType == DIALOG_AD_TYPE_ACTIVITY) {
            adWebView = mActivityWebView;
        } else {
            adWebView = mRewardWebView;
        }
        try {
            if (dialogAdType == DIALOG_AD_TYPE_ACTIVITY) {
                mActivityDialog = new XPopup.Builder(mActivity)
                        .dismissOnBackPressed(false)
                        .dismissOnTouchOutside(false)
                        .autoDismiss(false)
                        .enableDrag(false)
                        .hasShadowBg(true)
                        .setPopupCallback(new XPopupCallback() {
                            @Override
                            public void onShow() {
                                //解决横竖屏切换时 dialog不能铺满屏幕的问题
                                try {
                                    FrameLayout.LayoutParams dialogParams = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT);
                                    if (null != mActivityDialog) {
                                        mActivityDialog.setLayoutParams(dialogParams);
                                    }
//                                    resetWebViewSize(DIALOG_AD_TYPE_ACTIVITY);
                                } catch (Exception ignored) {
                                    FoxBaseCrashUtils.reportErrorData(ignored);
                                }
                                if (mAdCallBack != null) {
                                    mAdCallBack.onActivityShow();
                                }
                            }

                            @Override
                            public void onDismiss() {
                                if (mAdCallBack != null) {
                                    mAdCallBack.onActivityClose();
                                }
                            }
                        })
                        .asCustom(new AdActivityDialog(mActivity, mSlotId, adWebView));

                resetDialogSize(DIALOG_AD_TYPE_ACTIVITY);
            } else {
                mRewardDialog = new XPopup.Builder(mActivity)
                        .dismissOnBackPressed(false)
                        .dismissOnTouchOutside(false)
                        .autoDismiss(false)
                        .enableDrag(false)
                        .hasShadowBg(false)
                        .isRequestFocus(true)
                        .autoOpenSoftInput(false)
                        .moveUpToKeyboard(false)
                        .setPopupCallback(new XPopupCallback() {
                            @Override
                            public void onShow() {
                                //解决横竖屏切换时 dialog不能铺满屏幕的问题
                                try {
                                    FrameLayout.LayoutParams dialogParams = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT);
                                    if(null != mRewardDialog) {
                                        mRewardDialog.setLayoutParams(dialogParams);
                                    }
//                                    resetWebViewSize(DIALOG_AD_TYPE_REWARD);
                                } catch (Exception ignored) {
                                    FoxBaseCrashUtils.reportErrorData(ignored);
                                }

                                if (mAdCallBack != null) {
                                    mAdCallBack.onRewardShow();
                                }
                            }

                            @Override
                            public void onDismiss() {
                                FoxBaseLogUtils.vTag(TAG, "mRewardDialog  onDismiss");
                                if (mRewardDialog != null && mRewardDialog instanceof AdRewardDialog) {
                                    if (((AdRewardDialog) mRewardDialog).getBack() != null) {
                                        ((AdRewardDialog) mRewardDialog).getBack().setVisibility(View.GONE);
                                    }
                                }

                                //弹窗关闭 调用h5显示更多福利
                                //调用活动webview的更多活动jsbridge
                                if (mActivityWebView != null) {
                                    mActivityWebView.callHandler("moreBenefits", new JSONObject().toString(), new DefaultCallBackFunction());
                                }

                                if (mInsertWebView != null) {
                                    mInsertWebView.callHandler("moreBenefits", new JSONObject().toString(), new DefaultCallBackFunction());
                                    mInsertWebView.callHandler("closeH5Modal", null, null);
                                }

                                // 当奖励弹窗消失时 让活动弹窗重新获取焦点
                                if (mActivityDialog != null) {
                                    mActivityDialog.setFocusableInTouchMode(true);
                                    mActivityDialog.requestFocus();
                                }

                                if (mAdCallBack != null) {
                                    mAdCallBack.onRewardClose();
                                }
                                // 设置显示弹窗标志位为false
                                if (mRewardDialog != null) {
                                    ((AdRewardDialog) mRewardDialog).setPrepareShow(false);
                                }

                            }
                        })
                        .asCustom(new AdRewardDialog(mActivity, adWebView));

                resetDialogSize(DIALOG_AD_TYPE_REWARD);
            }
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }
    }


    /**
     * 初始化我的奖品弹窗
     */
    private void initMyPrizeDialog() {
        mMyPrizeDialog = new XPopup.Builder(mActivity)
                .dismissOnBackPressed(false)
                .dismissOnTouchOutside(false)
                .autoDismiss(false)
                .enableDrag(false)
                .hasShadowBg(true)
                .setPopupCallback(new XPopupCallback() {
                    @Override
                    public void onShow() {
                        if (mAdCallBack != null) {
                            mAdCallBack.onPrizeShow();
                        }
                    }

                    @Override
                    public void onDismiss() {
                        if (mAdCallBack != null) {
                            mAdCallBack.onPrizeClose();
                        }
                    }
                })
                .asCustom(new AdMyPrizeDialog(mActivity,this));
    }

    /**
     * 重置GG的大小 发生横竖屏切换时&不是嵌入式GG生效 ORIENTATION 保留api 暂未适配横屏活动
     */
    @Deprecated
    public void resetAdSize(int orientation) {
        if (mAdWrap != null) {
            return;
        }

        // 奖励弹窗
        if (mRewardDialog != null) {
            resetDialogSize(DIALOG_AD_TYPE_REWARD);
            resetWebViewSize(DIALOG_AD_TYPE_REWARD);
        }


        // 活动弹窗
        if (mActivityDialog != null) {
            resetDialogSize(DIALOG_AD_TYPE_ACTIVITY);
            resetWebViewSize(DIALOG_AD_TYPE_ACTIVITY);
        }
    }

    /**
     * 重置dialog的大小
     *
     * @param dialogAdType
     */
    private void resetDialogSize(int dialogAdType) {
        try {
            BasePopupView dialog;
            if (dialogAdType == DIALOG_AD_TYPE_ACTIVITY) {
                dialog = mActivityDialog;
            } else {
                dialog = mRewardDialog;
            }
            // dialog 的大小
            FrameLayout.LayoutParams dialogParams =
                    new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT);
            dialog.setLayoutParams(dialogParams);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) dialog.getPopupContentView().getLayoutParams();
            // 是否是竖屏
            if (FoxBaseScreenUtils.isPortrait()) {
                layoutParams.width = TuiaUtil.getScreenShortSide();
                layoutParams.height = TuiaUtil.getScreenLongSide();
            } else {
                layoutParams.width = TuiaUtil.getScreenLongSide();
                layoutParams.height = TuiaUtil.getScreenShortSide();
            }
            dialog.getPopupContentView().setLayoutParams(layoutParams);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 重置webview的大小
     *
     * @param dialogAdType
     */
    private void resetWebViewSize(int dialogAdType) {
//        try {
//            AdWebView adWebView;
//            if (dialogAdType == DIALOG_AD_TYPE_ACTIVITY) {
//                adWebView = mActivityDialog.findViewById(R.id.ad_webView);
//            } else {
//                adWebView = mRewardDialog.findViewById(R.id.ad_webView);
//            }
//            // 设置webView的大小
//            if (adWebView != null) {
//                FrameLayout.LayoutParams webViewParams = (FrameLayout.LayoutParams) adWebView.getLayoutParams();
//                if (FoxBaseScreenUtils.isPortrait()) {
//                    webViewParams.width = TuiaUtil.getScreenShortSide();
//                    int height;
//                    if (FoxBaseBarUtils.isSupportNavBar() && FoxBaseBarUtils.isNavBarVisible(mActivity)) {
//                        height = TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getStatusBarHeight() - FoxBaseBarUtils.getNavBarHeight();
//                    } else {
//                        height = TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getStatusBarHeight();
//                    }
//                    webViewParams.height = height;
//                    webViewParams.topMargin = FoxBaseBarUtils.getStatusBarHeight();
//                    webViewParams.gravity = Gravity.TOP;
//                } else {
//                    webViewParams.height = TuiaUtil.getScreenShortSide() - FoxBaseBarUtils.getStatusBarHeight();
//                    int width;
//                    float ratio;
//                    if (FoxBaseBarUtils.isSupportNavBar()) {
//                        ratio = (float) (TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getNavBarHeight()) / (float) TuiaUtil.getScreenShortSide();
//                        width = (int) ((TuiaUtil.getScreenShortSide() - FoxBaseBarUtils.getNavBarHeight()) / ratio);
//                    } else {
//                        ratio = (float) TuiaUtil.getScreenLongSide() / (float) TuiaUtil.getScreenShortSide();
//                        width = (int) (TuiaUtil.getScreenShortSide() / ratio);
//                    }
//
//                    webViewParams.width = width;
//                    webViewParams.topMargin = FoxBaseBarUtils.getStatusBarHeight();
//                    webViewParams.gravity = Gravity.CENTER_HORIZONTAL;
//                }
//
//                adWebView.setLayoutParams(webViewParams);
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
    }

    /**
     * 释放资源
     */
    public void destroy() {
        try {
            FoxBaseLogUtils.dTag(TAG,"——>destroy");
            FoxBaseMaidianUtil.build("destroy", this).postNativeAd();
            if (mActivityWebView != null) {
                mActivityWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
                mActivityWebView.clearHistory();
                if (mActivityWebView.getParent() != null) {
                    ((ViewGroup) mActivityWebView.getParent()).removeAllViews();
                }
                mActivityWebView.destroy();
                mActivityWebView = null;
            }

            if (mRewardWebView != null) {
                mRewardWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
                mRewardWebView.clearHistory();
                if (mRewardWebView.getParent() != null) {
                    ((ViewGroup) mRewardWebView.getParent()).removeAllViews();
                }
                mRewardWebView.destroy();
                mRewardWebView = null;
            }


            if (mInsertWebView != null) {
                mInsertWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
                mInsertWebView.clearHistory();
                if (mInsertWebView.getParent() != null) {
                    ((ViewGroup) mInsertWebView.getParent()).removeAllViews();
                }
                mInsertWebView.destroy();
                mInsertWebView = null;
            }

            if (mActivityDialog != null) {
                mActivityDialog.dismiss();
                mActivityDialog = null;
            }

            if (mRewardDialog != null) {
                mRewardDialog.dismiss();
                mRewardDialog = null;
            }

            if (mActivity != null) {
                FoxBaseKeyboardUtils.fixSoftInputLeaks(mActivity);
                mActivity = null;
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
    }

    /**
     * 拦截页面的返回按钮
     *
     * @param keyCode 返回按键
     * @param event
     * @return true 代表返回拦截事件已被处理 false 拦截事件未处理 需要开发者自己处理
     */
    public boolean onKeyBack(int keyCode, KeyEvent event) {
        try {
            if (keyCode == KeyEvent.KEYCODE_BACK) {
                // 判断我的奖品弹窗时候显示
                if (mMyPrizeDialog != null && mMyPrizeDialog.isShow()) {
                    WebView webView = ((AdMyPrizeDialog) mMyPrizeDialog).getAdWebView();
                    if (webView != null && webView.canGoBack()) {
                        webView.goBack();
                    } else {
                        mMyPrizeDialog.dismiss();
                        if (webView != null) {
                            webView.loadUrl(Ad.BLANK_URL);
                            // 清空webView的缓存
                            webView.clearHistory();
                        }
                    }
                    return true;
                }
                // 判断奖励弹窗是否消失
                if (mRewardDialog != null && mRewardDialog.isShow()) {
                    mRewardDialog.dismiss();
                    if (mRewardWebView != null) {
                        // 清空webView的缓存
                        mRewardWebView.clearHistory();
                    }
                    return true;
                }
                // 判断活动弹窗时候消失或者时候可以返回上一层
                if (mActivityDialog != null && mActivityDialog.isShow()) {
                    if (mAdWrap == null) {
                        if (isRewadShow && !isLandPageShow && getAd_type() == AD_URL_NEW) {
                            mActivityWebView.callHandler("closeH5Modal", null, null);
                            setRewadShow(false);
                            return true;
                        }
                    }
                    if (mActivityWebView != null && mActivityWebView.canGoBack()) {
                        String url = mActivityWebView.getUrl();
                        // LogUtils.vTag(TAG, "mActivityWebView.getUrl()===>" + mActivityWebView.getUrl());
                        if (url.startsWith("file://")) {
                            if (mActivityWebView != null) {
                                // 清空webView的缓存
                                mActivityWebView.loadUrl(BLANK_URL);
                                mActivityWebView.clearHistory();
                            }
                            mActivityDialog.dismiss();
                        } else {
                            String lastUrl = lastUrl(mActivityWebView);
                            if(FoxBaseCommonUtils.isEmpty(lastUrl) || BLANK_URL.equals(lastUrl)){
                                // 清空webView的缓存
                                mActivityWebView.loadUrl(BLANK_URL);
                                mActivityWebView.clearHistory();
                                mActivityDialog.dismiss();
                            }else {
                                mActivityWebView.back();
                            }
                        }
                        return true;
                    } else {
                        if (mActivityWebView != null) {
                            // 清空webView的缓存
                            mActivityWebView.loadUrl(BLANK_URL);
                            mActivityWebView.clearHistory();
                        }
                        mActivityDialog.dismiss();
                        return true;
                    }
                }
            }
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }
        return false;
    }

    private String lastUrl(WebView view){
        String backPageUrl = "";
        try {
            WebBackForwardList backForwardList = view.copyBackForwardList();
            if (backForwardList != null && backForwardList.getSize() != 0) {
                //当前页面在历史队列中的位置
                int currentIndex = backForwardList.getCurrentIndex();
                WebHistoryItem historyItem =
                        backForwardList.getItemAtIndex(currentIndex - 1);
                if (historyItem != null) {
                    backPageUrl = historyItem.getUrl();
                }
            }
        }catch (Exception ignored){
            FoxBaseCrashUtils.reportErrorData(ignored);
        }

        return backPageUrl;
    }

}
