package com.mediamain.android.nativead;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.xpopup.impl.FullScreenPopupView;
import com.mediamain.android.R;

import static com.mediamain.android.base.config.FoxBaseConstants.KEY_CHECK_ACTIVITY;

/**
 * ================================================
 * 作    者：jint（金台）
 * 版    本：1.0
 * 创建日期：2019-05-08-20:13
 * 描    述： 原生插屏活动Dialog
 * 修订历史：
 * ================================================
 */
class AdActivityDialog extends FullScreenPopupView  {

    private static final String TAG = "FullScreenPopupView";
    private AdWebView mAdWebView;
    public ImageView mIvBack;

    private Activity mActivity;
    private String mSlotId;

    public ImageView getIvBack() {
        return mIvBack;
    }

    protected AdActivityDialog(@NonNull Activity activity, String slotId,AdWebView adWebView) {
        super(activity);
        this.mAdWebView = adWebView;
        this.mActivity = activity;;
        this.mSlotId = slotId;;
        initView();
    }

    @Override
    protected int getImplLayoutId() {
        return R.layout.fox_tuia_ad_activity_dialog;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
    }


    private void initView() {
        mIvBack = findViewById(R.id.iv_back);
        mIvBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mAdWebView != null && mAdWebView.canGoBack()) {
                    mAdWebView.goBack();
                } else {
                    if (isShow()){
                        dismiss();
                    }
                }
            }
        });
        FrameLayout flAdWrap = findViewById(R.id.fl_ad_wrap);
        if(null != mAdWebView) {
            if (mAdWebView.getParent() != null) {
                ((ViewGroup) mAdWebView.getParent()).removeAllViews();
            }
            mAdWebView.setId(R.id.ad_webView);
            flAdWrap.addView(mAdWebView);
        }
//        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams) mAdWebView.getLayoutParams();
//        //是否是竖屏
//        if (FoxBaseScreenUtils.isPortrait()) {
//            params.width = TuiaUtil.getScreenShortSide();
//            int height;
//            if (FoxBaseBarUtils.isSupportNavBar() && FoxBaseBarUtils.isNavBarVisible((Activity) getContext())) {
//                height = TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getStatusBarHeight() - FoxBaseBarUtils.getNavBarHeight();
//            } else {
//                height = TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getStatusBarHeight();
//            }
//            params.height = height;
//            params.topMargin = FoxBaseBarUtils.getStatusBarHeight();
//            params.gravity = Gravity.TOP;
//        } else {
//            params.height = TuiaUtil.getScreenShortSide() - FoxBaseBarUtils.getStatusBarHeight();
//            int width;
//            float ratio;
//            if (FoxBaseBarUtils.isSupportNavBar()) {
//                ratio = (float) (TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getNavBarHeight()) / (float) TuiaUtil.getScreenShortSide();
//                width = (int) ((TuiaUtil.getScreenShortSide() - FoxBaseBarUtils.getNavBarHeight()) / ratio);
//            } else {
//                ratio = (float) TuiaUtil.getScreenLongSide() / (float) TuiaUtil.getScreenShortSide();
//                width = (int) (TuiaUtil.getScreenShortSide() / ratio);
//            }
//            params.width = width;
//            params.topMargin = FoxBaseBarUtils.getStatusBarHeight();
//            params.gravity = Gravity.CENTER_HORIZONTAL;
//
//        }
//        mAdWebView.setLayoutParams(params);
//        FoxBaseLogUtils.vTag(TAG, "======initView=======" + params.width + "   " + params.height);
    }

    @Override
    protected void onShow() {
        super.onShow();
        FoxBaseCommonUtils.postDataCheck(KEY_CHECK_ACTIVITY,mSlotId,null);
    }

}
