package com.mediamain.android.nativead;

import android.app.Activity;
import android.graphics.Color;
import android.net.http.SslError;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.webkit.DownloadListener;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;

import com.mediamain.android.base.util.xpopup.impl.FullScreenPopupView;
import com.mediamain.android.nativead.util.TuiaUtil;
import com.mediamain.android.BuildConfig;
import com.mediamain.android.R;

import static android.webkit.WebView.setWebContentsDebuggingEnabled;


/**
 * ================================================
 * 作    者：jint（金台）
 * 版    本：1.0
 * 创建日期：2019-05-08-20:13
 * 描    述：嵌入式我的奖品页和嵌入式其他的需要单独webview全屏显示的dialog
 * 修订历史：
 * ================================================
 */
class AdMyPrizeDialog extends FullScreenPopupView  {

    private static String TAG = "AdMyPrizeDialog";

    WebView mAdWebView;
    ImageView mBack;

    private Activity mActivity;
    private Ad mAd;

    protected AdMyPrizeDialog(@NonNull Activity activity,Ad ad) {
        super(activity);
        this.mActivity = activity;
        this.mAd = ad;
        initView();
    }

    @Override
    protected int getImplLayoutId() {
        return R.layout.fox_tuia_myprize_dialog;
    }

    /**
     * 加载链接
     *
     * @param url
     */
    public void loadUrl(String url) {
        if (mAdWebView != null) {
            mAdWebView.loadUrl(url);
        }
    }

    /**
     * 获取webview
     *
     * @return
     */
    public WebView getAdWebView() {
        return mAdWebView;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
    }

    private void initView() {
        mAdWebView = findViewById(R.id.ad_webView);
//        mAdWebView.setFocusable(false);
//        mAdWebView.setFocusableInTouchMode(false);
        mAdWebView.setWebChromeClient(new WebChromeClient());
        mAdWebView.setWebViewClient(new WebViewClient() {
            @Override
            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                handler.proceed();
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                if (url.equals(Ad.BLANK_URL)) {
                    dismiss();
                }
                //LogUtils.vTag(TAG, "url===>" + url);
                super.onPageFinished(view, url);
            }
        });
        initConfig(mAdWebView);
        mBack = findViewById(R.id.iv_back);
//        mBack.setVisibility(GONE);
        mBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mAdWebView.canGoBack()) {
                    back();
                } else {
                    dismiss();
                    mAdWebView.loadUrl(Ad.BLANK_URL);
                    //清空webView的缓存
                    mAdWebView.clearHistory();
                }
            }
        });

//        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams) mAdWebView.getLayoutParams();
//        //是否是竖屏
//        if (FoxBaseScreenUtils.isPortrait()) {
//            params.width = TuiaUtil.getScreenShortSide();
//            int height;
//            if (FoxBaseBarUtils.isSupportNavBar() && FoxBaseBarUtils.isNavBarVisible((Activity) getContext())) {
//                height = TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getStatusBarHeight() - FoxBaseBarUtils.getNavBarHeight();
//            } else {
//                height = TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getStatusBarHeight();
//            }
//            params.height = height;
//            params.topMargin = FoxBaseBarUtils.getStatusBarHeight();
//            params.gravity = Gravity.TOP;
//        } else {
//
//            params.height = TuiaUtil.getScreenShortSide() - FoxBaseBarUtils.getStatusBarHeight();
//            int width;
//            float ratio;
//            if (FoxBaseBarUtils.isSupportNavBar()) {
//                ratio = (float) (TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getNavBarHeight()) / (float) TuiaUtil.getScreenShortSide();
//                width = (int) ((TuiaUtil.getScreenShortSide() - FoxBaseBarUtils.getNavBarHeight()) / ratio);
//            } else {
//                ratio = (float) TuiaUtil.getScreenLongSide() / (float) TuiaUtil.getScreenShortSide();
//                width = (int) (TuiaUtil.getScreenShortSide() / ratio);
//            }
//
//            params.width = width;
//            params.topMargin = FoxBaseBarUtils.getStatusBarHeight();
//            params.gravity = Gravity.CENTER_HORIZONTAL;
//
//        }
//        mAdWebView.setLayoutParams(params);
    }

    /**
     * 初始化 webView 配置
     */
    public void initConfig(WebView webView) {
        if (Build.VERSION.SDK_INT >= 19) {
            setLayerType(View.LAYER_TYPE_HARDWARE, null);
        } else {
            setLayerType(View.LAYER_TYPE_SOFTWARE, null);
        }

        //设备webview背景色
        webView.setBackgroundColor(Color.TRANSPARENT);
        //clearCache(false);
        WebSettings webSetting = webView.getSettings();
        webSetting.setJavaScriptEnabled(true);
        // For API level below 18 (This method was deprecated in API level 18)
        webSetting.setRenderPriority(WebSettings.RenderPriority.HIGH);

        webSetting.setGeolocationEnabled(false);
        webSetting.setSupportZoom(false);
        webSetting.setLoadWithOverviewMode(true);
        // 设置出现缩放工具
        webSetting.setBuiltInZoomControls(false);
        //设置自适应手机屏幕
        webSetting.setUseWideViewPort(true);
        webSetting.setSupportMultipleWindows(true);
        webSetting.supportMultipleWindows();
        //自适应屏幕
        webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);


        //是否阻塞加载网络网络图像 先阻塞图片加载然后等页面加载完毕再去加载图片  提升这个页面的加载速度
        webSetting.setBlockNetworkImage(false);
        //先设置不加载图片资源
        webSetting.setLoadsImagesAutomatically(true);


        //设置可以访问文件
        webSetting.setAllowFileAccess(true);
        //视频相关设置
        webSetting.setPluginState(WebSettings.PluginState.ON);
        //控制webview是否可以弹窗
        webSetting.setJavaScriptCanOpenWindowsAutomatically(true);
        webSetting.setAllowContentAccess(true);
        webSetting.setTextZoom(100);
        webSetting.setDomStorageEnabled(true);
        //webView 缓存相关设置
        webSetting.setCacheMode(WebSettings.LOAD_NO_CACHE);
        webSetting.setDatabaseEnabled(true);
        webSetting.setDomStorageEnabled(true);
        //设置可以缓存 和缓存策略
        webSetting.setAppCacheEnabled(true);

        // 设置4.2以后版本支持autoPlay，非用户手势促发
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.JELLY_BEAN_MR1) {
            webSetting.setMediaPlaybackRequiresUserGesture(true);
        }


        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            webSetting.setMixedContentMode(WebSettings.MIXED_CONTENT_COMPATIBILITY_MODE);
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT && !BuildConfig.Release) {
            setWebContentsDebuggingEnabled(true);
        }
        //设置webview的下载监听
        webView.setDownloadListener(new DownloadListener() {
            @Override
            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                TuiaUtil.downloadAndInstall(mActivity,mAd!=null?mAd.getSlotId():"", url);
            }
        });
    }

    /**
     * 返回控制
     */
    private void back() {
        if (mAdWebView != null && mAdWebView.canGoBack()) {
            mAdWebView.goBack();
        }
    }

}
