package com.mediamain.android.nativead;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.mediamain.android.base.util.xpopup.impl.FullScreenPopupView;
import com.mediamain.android.R;

/**
 * ================================================
 * 作    者：jint（金台）
 * 版    本：1.0
 * 创建日期：2019-05-08-20:13
 * 描    述：
 * 修订历史：
 * ================================================
 */
class AdRewardDialog extends FullScreenPopupView {


    private Activity mActivity;
    AdWebView mAdWebView;
    ImageView mBack;

    /**
     * 是否准备好要显示AdRewardDialog弹窗
     * 避免落地页多次重定向导致dialog多次打开
     */
    private boolean isPrepareShow = true;

    public boolean isPrepareShow() {
        return isPrepareShow;
    }

    public void setPrepareShow(boolean prepareShow) {
        isPrepareShow = prepareShow;
    }

    protected ImageView getBack() {
        return mBack;
    }

    protected AdRewardDialog(@NonNull Activity activity, AdWebView adWebView) {
        super(activity);
        this.mActivity = activity;
        this.mAdWebView = adWebView;
        initView();
    }

    @Override
    protected int getImplLayoutId() {
        return R.layout.fox_tuia_ad_reward_dialog;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
    }

    private void initView() {
        FrameLayout flAdWrap = findViewById(R.id.fl_ad_wrap);
        mBack = findViewById(R.id.iv_back);
        mBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (mBack != null) {
                    mBack.setVisibility(View.GONE);
                }
            }
        });
        if (mAdWebView.getParent() != null) {
            ((ViewGroup) mAdWebView.getParent()).removeAllViews();
        }
        mAdWebView.setId(R.id.ad_webView);
        flAdWrap.addView(mAdWebView);
//        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams) mAdWebView.getLayoutParams();
//        //是否是竖屏
//        if (FoxBaseScreenUtils.isPortrait()) {
//            params.width = TuiaUtil.getScreenShortSide();
//            int height;
//            if (FoxBaseBarUtils.isSupportNavBar() && FoxBaseBarUtils.isNavBarVisible((Activity) getContext())) {
//                height = TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getStatusBarHeight() - FoxBaseBarUtils.getNavBarHeight();
//            } else {
//                height = TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getStatusBarHeight();
//            }
//            params.height = height;
//            params.topMargin = FoxBaseBarUtils.getStatusBarHeight();
//            params.gravity = Gravity.TOP;
//        } else {
//
//            params.height = TuiaUtil.getScreenShortSide() - FoxBaseBarUtils.getStatusBarHeight();
//            int width;
//            float ratio;
//            if (FoxBaseBarUtils.isSupportNavBar()) {
//                ratio = (float) (TuiaUtil.getScreenLongSide() - FoxBaseBarUtils.getNavBarHeight()) / (float) TuiaUtil.getScreenShortSide();
//                width = (int) ((TuiaUtil.getScreenShortSide() - FoxBaseBarUtils.getNavBarHeight()) / ratio);
//            } else {
//                ratio = (float) TuiaUtil.getScreenLongSide() / (float) TuiaUtil.getScreenShortSide();
//                width = (int) (TuiaUtil.getScreenShortSide() / ratio);
//            }
//
//            params.width = width;
//            params.topMargin = FoxBaseBarUtils.getStatusBarHeight();
//            params.gravity = Gravity.CENTER_HORIZONTAL;
//
//        }
//        //LogUtils.vTag("JsBridgeInject", "AdRewardDialog create");
//        mAdWebView.setLayoutParams(params);
        //mAdWebView.setBackgroundColor(Color.parseColor("#ff00ff"));
    }

}
