package com.mediamain.android.nativead;

import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ProgressBar;

import com.mediamain.android.base.util.FoxBaseBarUtils;
import com.mediamain.android.R;


public class AdWebChromeClient extends WebChromeClient {
    private static final String TAG = "AdWebChromeClient";
    private Ad mAd;
    private ProgressBar mProgressBar;

    public AdWebChromeClient(Ad ad) {
        this.mAd = ad;
        if (mAd != null && mAd.getRewardDialog() != null) {
            mProgressBar = mAd.getRewardDialog().findViewById(R.id.progressBar);
            if (mProgressBar != null) {
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams) mProgressBar.getLayoutParams();
                params.topMargin = FoxBaseBarUtils.getStatusBarHeight();
                mProgressBar.setLayoutParams(params);
            }
        }

    }

    @Override
    public void onProgressChanged(WebView webView, int newProgress) {
        super.onProgressChanged(webView, newProgress);
        if (mProgressBar != null) {
            mProgressBar.setProgress(newProgress);
            if (newProgress >= 0 && newProgress < 98) {
                mProgressBar.setVisibility(View.VISIBLE);
            }
            if (newProgress >= 98) {
                mProgressBar.setVisibility(View.GONE);
            }
        }
    }


}
