package com.mediamain.android.nativead;

import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.webkit.DownloadListener;
import android.webkit.WebSettings;

import com.mediamain.android.nativead.jsbridgeimpl.BaseJsBridgeWebView;
import com.mediamain.android.nativead.util.TuiaUtil;
import com.mediamain.android.BuildConfig;

public class AdWebView extends BaseJsBridgeWebView {

    private static final String TAG = "AdWebView";

    private Ad mAd;

    /**
     * webview上下文
     */
    public Activity mActivity;

    public AdWebView(Activity activity) {
        super(activity, BaseJsBridgeWebView.WEBVIEW_TYPE_ACTIVITY);
        mActivity = activity;
        initConfig();
    }

    public AdWebView(Activity activity, int webViewType) {
        super(activity, webViewType);
        mActivity = activity;
        initConfig();
    }

    protected AdWebView(Activity activity,Ad ad, int webViewType) {
        super(activity, webViewType);
        this.mActivity = activity;
        this.mAd = ad;
        initConfig();
    }

    /**
     * 初始化 webView 配置
     */
    protected void initConfig() {
        if (Build.VERSION.SDK_INT >= 19) {
            setLayerType(View.LAYER_TYPE_HARDWARE, null);
        } else {
            setLayerType(View.LAYER_TYPE_SOFTWARE, null);
        }

        //设备webview背景色
        setBackgroundColor(Color.TRANSPARENT);
        //clearCache(false);
        WebSettings webSetting = getSettings();
        webSetting.setJavaScriptEnabled(true);
        // For API level below 18 (This method was deprecated in API level 18)
        webSetting.setRenderPriority(WebSettings.RenderPriority.HIGH);

        webSetting.setGeolocationEnabled(false);
        webSetting.setSupportZoom(false);
        webSetting.setLoadWithOverviewMode(true);
        // 设置出现缩放工具
        webSetting.setBuiltInZoomControls(false);
        //设置自适应手机屏幕
        webSetting.setUseWideViewPort(true);

        webSetting.setSupportMultipleWindows(true);
        webSetting.supportMultipleWindows();
        //自适应屏幕
        webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);

        if (getWebViewType() == BaseJsBridgeWebView.WEBVIEW_TYPE_ACTIVITY) {
            //是否阻塞加载网络网络图像 先阻塞图片加载然后等页面加载完毕再去加载图片  提升这个页面的加载速度
            webSetting.setBlockNetworkImage(true);
            //先设置不加载图片资源
            webSetting.setLoadsImagesAutomatically(false);
        } else {
            //是否阻塞加载网络网络图像 先阻塞图片加载然后等页面加载完毕再去加载图片  提升这个页面的加载速度
            webSetting.setBlockNetworkImage(false);
            //先设置不加载图片资源
            webSetting.setLoadsImagesAutomatically(true);
        }

        //设置可以访问文件
        webSetting.setAllowFileAccess(true);
        //视频相关设置
        webSetting.setPluginState(WebSettings.PluginState.ON);
        webSetting.setJavaScriptCanOpenWindowsAutomatically(true);
        webSetting.setAllowContentAccess(true);
        webSetting.setTextZoom(100);
        webSetting.setDomStorageEnabled(true);
        //webView 缓存相关设置 不能一直用缓存
        webSetting.setCacheMode(WebSettings.LOAD_DEFAULT);
        webSetting.setDatabaseEnabled(true);
        webSetting.setDomStorageEnabled(true);
        //设置可以缓存 和缓存策略
        webSetting.setAppCacheEnabled(true);
        //解决webView加载乱码的问题
        webSetting.setDefaultTextEncodingName("UTF-8");

        // 设置4.2以后版本支持autoPlay，非用户手势促发
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.JELLY_BEAN_MR1) {
            webSetting.setMediaPlaybackRequiresUserGesture(true);
        }


        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            webSetting.setMixedContentMode(WebSettings.MIXED_CONTENT_COMPATIBILITY_MODE);
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT && !BuildConfig.Release) {
            setWebContentsDebuggingEnabled(true);
        }
        //设置UserAgent
        String ua = webSetting.getUserAgentString();
        webSetting.setUserAgentString(ua + "; duiba88");
        setInitialScale(1);
//        //设置webview的下载监听
        setDownloadListener(new DownloadListener() {
            @Override
            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                TuiaUtil.downloadAndInstall(mActivity,mAd!=null?mAd.getSlotId():"", url);
            }
        });
    }

    /**
     * 处理返回事件
     */
    public void back(){
        goBack();
    }
}
