package com.mediamain.android.nativead;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import android.widget.ImageView;

import com.mediamain.android.BuildConfig;
import com.mediamain.android.base.util.FoxBaseCommonUtils;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.FoxBaseScreenUtils;
import com.mediamain.android.base.util.FoxBaseUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.base.util.xpopup.core.BasePopupView;
import com.mediamain.android.nativead.jsbridge.BridgeWebViewClient;
import com.mediamain.android.nativead.jsbridgeimpl.BaseJsBridgeWebView;
import com.mediamain.android.nativead.jsbridgeimpl.JsBridgeInject;
import com.mediamain.android.nativead.jsbridgeimpl.interfaces.H5CallBack;
import com.mediamain.android.nativead.jsbridgeimpl.interfaces.WebViewCallBack;
import com.mediamain.android.nativead.util.TuiaUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class AdWebViewClient extends BridgeWebViewClient {
    /**
     * 清空历史缓存
     */
    private boolean needClearHistory;
    private WebViewCallBack mWebViewCallBack;
    private H5CallBack mJsBridgeCallBack;
    private static final String TAG = "AdWebViewClient";
    /**
     * 是否已经注册过本地jsbridge方法
     */
    private boolean hasWebViewInject = false;
    private Ad mAd;
    private String mSlotId;

    public void setNeedClearHistory(boolean needClearHistory) {
        this.needClearHistory = needClearHistory;
    }

    public AdWebViewClient(BaseJsBridgeWebView bridgeWebView, String slotId, WebViewCallBack webViewCallBack, H5CallBack jsBridgeCallback) {
        super(bridgeWebView);
        this.mWebViewCallBack = webViewCallBack;
        mSlotId = slotId;
        this.mJsBridgeCallBack = jsBridgeCallback;
        if (!hasWebViewInject) {
            new JsBridgeInject().inject(bridgeWebView, mJsBridgeCallBack);
            hasWebViewInject = true;
        }
    }

    public AdWebViewClient(Ad ad, BaseJsBridgeWebView bridgeWebView, WebViewCallBack webViewCallBack, H5CallBack jsBridgeCallBack) {
        super(bridgeWebView);
        this.mAd = ad;
        mSlotId = ad.getSlotId();
        this.mWebViewCallBack = webViewCallBack;
        this.mJsBridgeCallBack = jsBridgeCallBack;
        if (!hasWebViewInject) {
            new JsBridgeInject().inject(mAd,bridgeWebView, mJsBridgeCallBack);
            hasWebViewInject = true;
        }
        setActivityPath(ad);
    }

    private void setActivityPath(Ad ad) {
        int ad_type = ad.getAd_type();
        if (ad_type == Ad.AD_URL_NEW) {
            activityPath = "/native/interstitial";
        } else {
            activityPath = "/activity/index";
        }
    }

    private long pageStarted;

    @Override
    public void onPageStarted(WebView webView, String s, Bitmap bitmap) {
        super.onPageStarted(webView, s, bitmap);
        // Log.d(TAG, "=====onPageStarted======");
        pageStarted = System.currentTimeMillis();

    }

    @Override
    public void onReceivedError(WebView webView, int errorCode, String description, String failingUrl) {
        super.onReceivedError(webView, errorCode, description, failingUrl);
        Log.d(TAG, "=====onReceivedError=====errorCode=" + errorCode + "  description===》" + description);
        if (mWebViewCallBack != null && webView instanceof AdWebView) {
            mWebViewCallBack.onPageFinished(webView,((AdWebView) webView).getWebViewType());
        }
//        webView.loadUrl("file:///android_asset/fox_web_error.html");
        FoxBaseMaidianUtil.build("onReceivedError", mAd).set("url", failingUrl).postNativeAd();
    }

    @Override
    public void onLoadResource(WebView webView, String url) {
        super.onLoadResource(webView, url);
    }

    /**
     * 活动url的path
     */
    private String activityPath = "/native/nativeApi";

    @Override
    public void onPageFinished(final WebView webView, String url) {
        super.onPageFinished(webView, url);
        try {
            if (!BuildConfig.Release) {
                Log.d(TAG, "onPageFinished url====>" + url + "   page load time=====>" + (System.currentTimeMillis() - pageStarted));
            }
            if (url.equals(Ad.BLANK_URL) || TextUtils.isEmpty(url)) {
                return;
            }
            URL urlObj = new URL(url);
            String path = urlObj.getPath();
            FoxBaseLogUtils.vTag(TAG, "path====>" + path);
            // 如果是活动的地址则设置奖励弹窗域名为活动域名
            if (path.equals(activityPath)) {
                setActivityHost(url);
            }
            // 二维码扫描本地测试
            int port = urlObj.getPort();
            String endStr = "/entry.html";
            if ((port == 5555 && url.endsWith(endStr)) || url.contains("dui88debug=true")) {
                setActivityHost(url);
            }

            if (((AdWebView) webView).getWebViewType() == AdWebView.WEBVIEW_TYPE_ACTIVITY) {
                // 页面加载完毕后再加载图片资源
                webView.getSettings().setBlockNetworkImage(false);
                webView.getSettings().setLoadsImagesAutomatically(true);
                if (path.equals(activityPath)) {
                    setActivityHost(url);
                    setIvBackVisibility(View.GONE);
                }
//                else {
//                    ImageView ivBack = ((AdActivityDialog) mAd.getActivityDialog()).getIvBack();
//                    if (ivBack != null) {
//                        ivBack.setVisibility(View.VISIBLE);
//                    }
//                }
            }
            if (mWebViewCallBack != null && webView instanceof AdWebView) {
                mWebViewCallBack.onPageFinished(webView,((AdWebView) webView).getWebViewType());
            }

            if (!hasWebViewInject) {
                new JsBridgeInject().inject(mAd,(BaseJsBridgeWebView) webView, mJsBridgeCallBack);
                hasWebViewInject = true;
            }

            if (needClearHistory) {
                webView.clearHistory();
                needClearHistory = false;
            }
            if (mAd != null) {
                BasePopupView popupView = mAd.getRewardDialog();
                // 非奖励弹窗才出现返回按钮
                if (popupView != null && popupView.isShow()) {
                    if (((AdRewardDialog) popupView).getBack() != null) {
                        if (url.equals(mAd.getActivityHost())) {
                            ((AdRewardDialog) popupView).getBack().setVisibility(View.GONE);
                        } else {
                            ((AdRewardDialog) popupView).getBack().setVisibility(View.VISIBLE);
                        }
                    }
                }
            }

            // 隐藏出券进度条
            // if (mAd.getRewardLoadingDialog() != null && mAd.getRewardLoadingDialog().isShow()) {
            // mAd.getRewardLoadingDialog().dismiss();
            // }

            // 调用前端js方法 发送埋点

            callJsFunction((AdWebView) webView);

            FoxBaseMaidianUtil.build("onPageFinished", mAd).set("url", url).postNativeAd();
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
        }

    }

    private void setIvBackVisibility(int visible) {
        ImageView ivBack = ((AdActivityDialog) mAd.getActivityDialog()).getIvBack();
        if (ivBack != null) {
            ivBack.setVisibility(visible);
        }
    }

    private void setActivityHost(String url) {
        try {
            URL urlObj = new URL(url);
            String protocol = urlObj.getProtocol();
            String host = protocol + "://" + urlObj.getHost() + "/";
            FoxBaseLogUtils.vTag(TAG, "ActivityHost====>" + host);
            mAd.setActivityHost(host);
        } catch (Exception e) {
            FoxBaseCrashUtils.reportErrorData(e);
            mAd.setActivityHost("https://activity.tuia.cn/");
        }
    }

    /**
     * 调用前端jsbridge方法
     */
    private void callJsFunction(AdWebView adWebView) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sdkVersion", "" + BuildConfig.VERSION_NAME);
        jsonObject.put("appName", "" + FoxBaseCommonUtils.getAppName());
        jsonObject.put("manufacturer", "" + Build.MANUFACTURER);
        jsonObject.put("model", "" + FoxBaseCommonUtils.getModel());
        // jsonObject.put("imei", "" + PhoneUtils.getIMEI());
        jsonObject.put("androidId", "" + FoxBaseCommonUtils.getAndroidID());
        jsonObject.put("osVersion", "" + android.os.Build.VERSION.RELEASE);
        jsonObject.put("appKey", FoxBaseCommonUtils.getAppKey());
        if (mAd != null) {
            jsonObject.put("slotId", mAd.getSlotId());
        } else if (!TextUtils.isEmpty(mSlotId)) {
            jsonObject.put("slotId", mSlotId);
        } else {
            jsonObject.put("slotId", "");
        }
        jsonObject.put("os", "Android");
        String md = TuiaUtil.getMD(FoxBaseUtils.getApp());
        jsonObject.put("md", md);
        long timeStamp = System.currentTimeMillis();
        jsonObject.put("timestamp", timeStamp);
        int nonce = (int) ((Math.random() * 9 + 1) * 100000);
        jsonObject.put("nonce", nonce);
        String meDecod;
        try {
            meDecod = URLDecoder.decode(URLDecoder.decode(md, "UTF-8"), "UTF-8");
            FoxBaseLogUtils.dTag(null,"md  is  "+md,"  meDecod is  "+ meDecod);
        } catch (UnsupportedEncodingException e) {
            FoxBaseCrashUtils.reportErrorData(e);
            meDecod = md;
        }
        String signature = TuiaUtil.getSHA(TuiaAdConfig.getAppSecret(), meDecod, nonce, timeStamp);
        FoxBaseLogUtils.dTag(null,"md  is  "+md,"  meDecod is  "+ meDecod," signature is "+ signature);
        jsonObject.put("signature", signature);

        jsonObject.put("device_Id", mAd == null ? "" : "" + mAd.getDeviceId());
            jsonObject.put("userId", mAd == null ? "" : "" + mAd.getUserId());
        // 原生GG类型
        if (mAd != null) {
            jsonObject.put("type", mAd.getAdWrap() == null ? "pop" : "insert");
        }
        // 屏幕像素比
        jsonObject.put("dpr", "" + (int) FoxBaseScreenUtils.getScreenDensity());
        jsonObject.put("webViewWidth", adWebView.getWidth());
        jsonObject.put("webViewHeight", adWebView.getHeight());

        adWebView.callHandler("functionInJs", jsonObject.toString(), null);
    }

    @Override
    public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
        super.doUpdateVisitedHistory(view, url, isReload);
        // LogUtils.vTag(TAG, "=====doUpdateVisitedHistory=====");
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView webView, String url) {
        try {

            if (url == null) {
                return false;
            }
            //判断是否被jsbridge消费
            if (super.shouldOverrideUrlLoading(webView, url)) {
                return true;
            }
            //处理普通请求
            if (url.startsWith(AdConstants.KEY_URL_HTTP) || url.startsWith(AdConstants.KEY_URL_HTTPS)) {
                // 如果是8.0以上的,则不调用loadUrl,并返回false
//                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
//                    return false;
//                }
//                if (webView != null) {
//                    webView.loadUrl(url);
//                }
//                return true;
                // fixed:android 5.1 跳转落地页失败
                return false;
            } else {
                /**
                 * 防止  找不到网页net:err_unknown_url_scheme
                 * 支持scheme协议
                 */
                FoxBaseCommonUtils.startActivity(FoxBaseUtils.getApp(), Uri.parse(url));
//                boolean result = FoxBaseCommonUtils.startActivity(FoxBaseUtils.getApp(),Uri.parse(url));
//                // DeepLink 跳转埋点
//                FoxBaseMaidianUtil.build(45)
//                        .set("start_result", result ? "1" : "2")
//                        .set("land_page_url", url)
//                        .set("slot_id", mSlotId)
//                        .postDeepLinkStartLog();
                return true;
            }
        } catch (Exception e) { //防止crash (如果手机上没有安装处理某个scheme开头的url的APP, 会导致crash)
            FoxBaseCrashUtils.reportErrorData(e);
            e.printStackTrace();
            //返回true 代表让webview自己执行
            return true;
        }
    }
}
