package com.mediamain.android.nativead;

import android.app.Activity;
import android.view.View;

import com.mediamain.android.base.FoxBaseSDK;
import com.mediamain.android.base.config.FoxSDKType;
import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.FoxBaseResourceUtils;
import com.mediamain.android.base.util.FoxBaseToastUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.base.util.xpopup.core.BasePopupView;
import com.mediamain.android.nativead.jsbridgeimpl.BaseJsBridgeWebView;
import com.mediamain.android.nativead.jsbridgeimpl.interfaces.H5CallBack;
import com.mediamain.android.nativead.util.HttpUrlUtil;
import com.mediamain.android.nativead.util.TuiaUtil;
import com.mediamain.android.view.FoxActivity;
import com.mediamain.android.base.config.Constants;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.UUID;

import static com.mediamain.android.nativead.Ad.BLANK_URL;

/**
 * ================================================
 * 作    者：jint（金台）
 * 版    本：1.0
 * 创建日期：2019-05-10-15:03
 * 描    述：h5 jsbridge回调实现
 * 修订历史：必须判断当前activity时候为null和finsih
 * ================================================
 */
public class H5CallBackImpl implements H5CallBack {
    public static final String TAG = "AdCallBackImpl";


    /**
     * 活动dialog
     */
    BasePopupView mActivityDialog;
    /**
     * 奖励dialog
     */
    BasePopupView mRewardDialog;


    /**
     * 暴露给媒体的回调
     */
    private AdCallBack mAdCallBack;


    /**
     * 展示活动的activity
     */
    private Activity mActivity;
    private PopupActivityController mController;
    private Ad mAd;

    public H5CallBackImpl(PopupActivityController controller) {
        mController = controller;
    }

    public H5CallBackImpl(Activity activity) {
        mActivity = activity;
    }

    public H5CallBackImpl(Ad ad) {
        this.mAd = ad;
        this.mActivityDialog = ad.getActivityDialog();
        this.mRewardDialog = ad.getRewardDialog();
        this.mAdCallBack = ad.getAdCallBack();
        this.mActivity = mAd.getActivity();

    }

    @Override
    public void modalClose(int webViewType, JSONObject data) {
        if (mAd == null && mController != null) {
            // 悬浮升级使用
            mController.popupClose();
            return;
        }
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
        switch (webViewType) {
            case BaseJsBridgeWebView.WEBVIEW_TYPE_ACTIVITY:
                if (mActivityDialog != null && mActivityDialog.isShow()) {
                    if (mAd != null && mAd.getActivityWebView()!=null) {
                        // 清空webView的缓存
                        mAd.getActivityWebView().loadUrl(BLANK_URL);
                        mAd.getActivityWebView().clearHistory();
                    }
                    mActivityDialog.dismiss();
                }
                break;
            case BaseJsBridgeWebView.WEBVIEW_TYPE_REWARD:
            case BaseJsBridgeWebView.WEBVIEW_TYPE_INSERT:
                if (mRewardDialog != null && mRewardDialog.isShow()) {
                    mRewardDialog.dismiss();
                }
                break;
            default:
                break;
        }
        FoxBaseMaidianUtil.build("modalClose", mAd)
                .set("webViewType", "" + webViewType)
                .postNativeAd();
    }

    @Override
    public void modalShow(int webViewType, JSONObject data) {
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
        switch (webViewType) {
            case BaseJsBridgeWebView.WEBVIEW_TYPE_ACTIVITY:
            case BaseJsBridgeWebView.WEBVIEW_TYPE_INSERT:
                if (mRewardDialog != null) {
                    mRewardDialog.show();
                }
                break;

            case BaseJsBridgeWebView.WEBVIEW_TYPE_REWARD:
                break;

            default:
                break;
        }
        FoxBaseMaidianUtil.build("modalShow", mAd)
                .set("webViewType", "" + webViewType)
                .postNativeAd();
    }

    @Override
    public void initRewardWebView(int webViewType, JSONObject data) {
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }

        switch (webViewType) {
            case BaseJsBridgeWebView.WEBVIEW_TYPE_ACTIVITY:
            case BaseJsBridgeWebView.WEBVIEW_TYPE_INSERT:
                String strWebViewRewardHtml = FoxBaseResourceUtils.readAssets2String("fox_web_reward.html", "utf-8");
                try {
                    strWebViewRewardHtml = TuiaUtil.replaceRewardHtml(strWebViewRewardHtml, data);
                    FoxBaseLogUtils.vTag(TAG, strWebViewRewardHtml);
                    mAd.getRewardWebView().loadDataWithBaseURL(mAd.getActivityHost(), strWebViewRewardHtml, "text/HTML", "UTF-8", null);
                    if (mRewardDialog instanceof AdRewardDialog) {
                        ((AdRewardDialog) mRewardDialog).setPrepareShow(true);
                        if (((AdRewardDialog) mRewardDialog).getBack() != null) {
                            ((AdRewardDialog) mRewardDialog).getBack().setVisibility(View.GONE);
                        }
                    }
                } catch (Exception e) {
                    FoxBaseCrashUtils.reportErrorData(e);
                    e.printStackTrace();
                }

                break;
            case BaseJsBridgeWebView.WEBVIEW_TYPE_REWARD:

                break;

            default:
                break;
        }

        FoxBaseMaidianUtil.build("initRewardWebView", mAd)
                .set("webViewType", "" + webViewType)
                .postNativeAd();

    }

    @Override
    public void btnClick(int webViewType, JSONObject data) {
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
    }

    @Override
    public void imgClick(int webViewType, JSONObject data) {
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
    }

    @Override
    public void hasNoTimes(int webViewType, JSONObject data) {
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
    }

    @Override
    public void userStartBtn(int webViewType, JSONObject data) {
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
    }

    @Override
    public void jump2Land(int webViewType, JSONObject data) {
        if (mAd == null && mController != null) {
            String jumpUrl;
            try {
                if (data.getString("jumpUrl").startsWith("//")) {
                    jumpUrl = "http:" + data.getString("jumpUrl");
                } else {
                    jumpUrl = data.getString("jumpUrl");
                }
                FoxBaseLogUtils.v("land page url:" + jumpUrl);
                // 悬浮升级使用
                mController.jump2Land(jumpUrl);
            } catch (JSONException e) {
                FoxBaseCrashUtils.reportErrorData(e);
                e.printStackTrace();
            }
            return;
        }
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
        String mkey = UUID.randomUUID().toString();
        switch (webViewType) {
            case BaseJsBridgeWebView.WEBVIEW_TYPE_INSERT:
            case BaseJsBridgeWebView.WEBVIEW_TYPE_ACTIVITY:
                final String activityJumpurl;
                try {
                    //测试专用
                    //data.put("jumpUrl","//m.baidu.cn");
                    //判断是否是//开头
                    if (data.getString("jumpUrl").startsWith("//")) {
                        activityJumpurl = "http:" + data.getString("jumpUrl");
                    } else {
                        activityJumpurl = data.getString("jumpUrl");
                    }
                    FoxBaseLogUtils.vTag(TAG, activityJumpurl);
                    FoxActivity.startActivity(FoxBaseSDK.getContext(), mkey, mAd.getSlotId(), activityJumpurl, FoxSDKType.NATIVE_AD.getCode());

                    FoxBaseMaidianUtil.build("jump2Land", mAd)
                            .set("webViewType", "" + webViewType)
                            .set("url", "" + activityJumpurl)
                            .postNativeAd();
                } catch (JSONException e) {
                    FoxBaseCrashUtils.reportErrorData(e);
                    e.printStackTrace();
                }
                break;
            case BaseJsBridgeWebView.WEBVIEW_TYPE_REWARD:
                try {
                    String jumpUrl = data.getString("jumpUrl");
                    FoxBaseLogUtils.vTag(TAG, jumpUrl);
                    if (HttpUrlUtil.checkURLIsDownload(jumpUrl)) {
                        TuiaUtil.downloadAndInstall(mActivity,mAd!=null?mAd.getSlotId():"", HttpUrlUtil.getApkUrl(jumpUrl));
                    } else {
                        if (mAd!=null && mAd.getRewardDialog()!=null){
                            mAd.getRewardWebView().loadUrl(jumpUrl);
                        }
                    }
                    FoxBaseMaidianUtil.build("jump2Land", mAd)
                            .set("webViewType", "" + webViewType)
                            .set("url", "" + jumpUrl)
                            .postNativeAd();
                } catch (JSONException e) {
                    FoxBaseCrashUtils.reportErrorData(e);
                    e.printStackTrace();
                }
                break;
            default:
                break;
        }

    }

    @Override
    public void myPrize(int webViewType, JSONObject data) {
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
        switch (webViewType) {
            case BaseJsBridgeWebView.WEBVIEW_TYPE_ACTIVITY:
                FoxBaseToastUtils.showShort("弹窗式不支持当前操作");
                break;
            case BaseJsBridgeWebView.WEBVIEW_TYPE_REWARD:
                FoxBaseToastUtils.showShort("奖励弹窗不支持当前操作");
                break;
            case BaseJsBridgeWebView.WEBVIEW_TYPE_INSERT:
                final String jumpUrl;
                try {
                    //测试专用
                    //data.put("jumpUrl","//m.baidu.cn");
                    //判断是否是//开头
                    if (data.getString("jumpUrl").startsWith("//")) {
                        jumpUrl = "http:" + data.getString("jumpUrl");
                    } else {
                        jumpUrl = data.getString("jumpUrl");
                    }
                    final AdMyPrizeDialog dialog = (AdMyPrizeDialog) mAd.getMyPrizeDialog();
                    if (dialog != null) {
                        dialog.show();
                        dialog.postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                dialog.loadUrl(jumpUrl);
                            }
                        }, 100);
                    }
                    FoxBaseMaidianUtil.build("myPrize", mAd)
                            .set("webViewType", "" + webViewType)
                            .set("url", "" + jumpUrl)
                            .postNativeAd();
                } catch (JSONException e) {
                    FoxBaseCrashUtils.reportErrorData(e);
                    e.printStackTrace();
                }
                break;
            default:
                break;
        }

    }


    /**
     * 切换活动
     *
     * @param webViewType
     * @param data
     */
    @Override
    public void changeActivity(int webViewType, JSONObject data) {
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
        switch (webViewType) {
            case BaseJsBridgeWebView.WEBVIEW_TYPE_ACTIVITY:
            case BaseJsBridgeWebView.WEBVIEW_TYPE_INSERT:
                AdWebView activityWebView = mAd.getActivityWebView();
                AdWebView insertWebView = mAd.getInsertWebView();
                try {
                    String userType = data.getString("userType");
                    String moreEngineUrl = mAd.getMoreEngineUrl() + "&userType=" + userType;
                    if (activityWebView != null) {
                        activityWebView.loadUrl(moreEngineUrl);
                        if (mAd.getActivityWebViewClient() != null) {
                            mAd.getActivityWebViewClient().setNeedClearHistory(true);
                        }
                    }

                    if (insertWebView != null) {
                        insertWebView.loadUrl(moreEngineUrl);
                        if (mAd.getInsertAdWebViewClient() != null) {
                            mAd.getInsertAdWebViewClient().setNeedClearHistory(true);
                        }
                    }
                } catch (Exception e) {
                    FoxBaseCrashUtils.reportErrorData(e);
                    e.printStackTrace();
                    String moreEngineUrl = mAd.getMoreEngineUrl();
                    if (activityWebView != null) {
                        activityWebView.loadUrl(moreEngineUrl);
                        if (mAd.getActivityWebViewClient() != null) {
                            mAd.getActivityWebViewClient().setNeedClearHistory(true);
                        }
                    }

                    if (insertWebView != null) {
                        insertWebView.loadUrl(moreEngineUrl);
                        if (mAd.getInsertAdWebViewClient() != null) {
                            mAd.getInsertAdWebViewClient().setNeedClearHistory(true);
                        }
                    }
                }


                break;
            case BaseJsBridgeWebView.WEBVIEW_TYPE_REWARD:

                break;

            default:
                break;
        }

        FoxBaseMaidianUtil.build("changeActivity", mAd)
                .set("webViewType", "" + webViewType)
                .postNativeAd();
    }

    @Override
    public void setRewardShow(boolean isShow) {
        if (mAd != null) {
            mAd.setRewadShow(isShow);
        }
    }

    @Override
    public void setLandPageShow(boolean isShow) {
        if (mAd != null) {
            mAd.setLandPageShow(isShow);
        }
    }
}
