package com.mediamain.android.nativead;

import android.app.Activity;
import android.webkit.WebView;

import com.mediamain.android.base.util.FoxBaseLogUtils;
import com.mediamain.android.base.util.FoxBaseMaidianUtil;
import com.mediamain.android.base.util.xpopup.core.BasePopupView;
import com.mediamain.android.nativead.jsbridgeimpl.BaseJsBridgeWebView;
import com.mediamain.android.nativead.jsbridgeimpl.interfaces.WebViewCallBack;

/**
 * ================================================
 * 作    者：jint（金台）
 * 版    本：1.0
 * 创建日期：2019-05-10-15:03
 * 描    述：关于webview的回调实现
 * 修订历史：
 * ================================================
 */
public class WebViewCallBackImpl implements WebViewCallBack {

    public static final String TAG = "WebViewCallBackImpl";

    /**
     * 活动dialog
     */
    BasePopupView mActivityDialog;
    /**
     * 奖励dialog
     */
    BasePopupView mRewardDialog;
//    /**
//     * 加载中。。。
//     */
//    BasePopupView mLoadingDialog;


    /**
     * Ad 对象
     */
    private Ad mAd;
    private Activity mActivity;

    public WebViewCallBackImpl() {

    }

    public WebViewCallBackImpl(Ad ad) {
        this.mAd = ad;
        this.mActivityDialog = ad.getActivityDialog();
        this.mRewardDialog = ad.getRewardDialog();
        this.mActivity = mAd.getActivity();
    }

    @Override
    public void close(int webViewType) {
        FoxBaseLogUtils.vTag(TAG, " close");
//        if (mActivity == null || mActivity.isFinishing()) {
//            return;
//        }
//        switch (webViewType) {
//            case BaseJsBridgeWebView.WEBVIEW_TYPE_ACTIVITY:
//                if (mAd!=null && mAd.getActivityWebView()!=null){
//                    mAd.getActivityWebView().clearHistory();
//                }
//                if (mActivityDialog != null) {
//                    mActivityDialog.dismiss();
//                }
//                break;
//            case BaseJsBridgeWebView.WEBVIEW_TYPE_REWARD:
//                if (mRewardDialog != null) {
//                    mRewardDialog.dismiss();
//                }
//                break;
//            case BaseJsBridgeWebView.WEBVIEW_TYPE_INSERT:
//                break;
//            default:
//                break;
//        }
        FoxBaseMaidianUtil.build("close", mAd)
                .set("webViewType", "" + webViewType)
                .postNativeAd();
    }

    @Override
    public void onPageFinished(WebView webView,int webViewType) {
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
        switch (webViewType) {
            case BaseJsBridgeWebView.WEBVIEW_TYPE_ACTIVITY:
//                if (mLoadingDialog != null && mLoadingDialog.isShow()) {
//                    mLoadingDialog.dismiss();
//                }
                if (mActivityDialog != null && !mActivityDialog.isShow()) {
                    mActivityDialog.show();
                }
                break;
            case BaseJsBridgeWebView.WEBVIEW_TYPE_REWARD:
                String url = mAd.getRewardWebView().getUrl();
                FoxBaseLogUtils.vTag(TAG, "reward url=====>" + url);
                //奖励活动弹窗或者空页面在初始化完成以后不直接调用
                if (url.equals(Ad.BLANK_URL)) {
                    return;
                }
                if (mRewardDialog != null && ((AdRewardDialog) mRewardDialog).isPrepareShow()) {
                    if (mRewardDialog.isDismiss()) {
                        mRewardDialog.show();
                    }
                }
                break;
            case BaseJsBridgeWebView.WEBVIEW_TYPE_INSERT:
                //嵌入式GG
//                mAd.getInsertWebView().setVisibility(View.VISIBLE);
                break;
            default:
                break;
        }

    }
}
