package com.mediamain.android.nativead.jsbridgeimpl;

import org.json.JSONException;
import org.json.JSONObject;

import com.mediamain.android.base.util.FoxBaseToastUtils;
import com.mediamain.android.base.util.crash.FoxBaseCrashUtils;
import com.mediamain.android.nativead.jsbridgeimpl.handler.BaseJsBridgeHandler;
import com.mediamain.android.nativead.jsbridgeimpl.handler.JsBridgeList;
import com.mediamain.android.nativead.jsbridgeimpl.interfaces.H5CallBack;
import com.mediamain.android.nativead.Ad;
import com.mediamain.android.nativead.jsbridge.BridgeHandler;
import com.mediamain.android.nativead.jsbridge.CallBackFunction;
import com.mediamain.android.BuildConfig;

import android.util.Log;

/**
 * ================================================
 * 作    者：jint（金台）
 * 版    本：1.0
 * 创建日期：2018/5/2-14:23
 * 描    述：
 * 修订历史：
 * ================================================
 */
public class JsBridgeInject {

    private static final String TAG = "JsBridgeInject";

    public void inject(BaseJsBridgeWebView webView, H5CallBack jsBridgeCallback) {
        JsBridgeList jsBridgeList = new JsBridgeList(webView, jsBridgeCallback);
        for (final BaseJsBridgeHandler jsBridgeHandler : jsBridgeList.getCommHandlers(null)) {
            webView.registerHandler(jsBridgeHandler.getName(), new BridgeHandler() {
                @Override
                public void handler(String strData, CallBackFunction function) {
                    if (!BuildConfig.Release) {
                        FoxBaseToastUtils.showShort(jsBridgeHandler.getName());
                    }
                    Log.i(TAG, "handler = " + jsBridgeHandler.getName() + ", data from web = " + strData);
                    try {
                        //统一获取data jsonObject
                        JSONObject data = new JSONObject(strData).getJSONObject("data");
                        jsBridgeHandler.callBack(data, function);
                    } catch (Exception e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                        Log.e(TAG, e.getMessage());
                        try {
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("code", -200);
                            jsonObject.put("data", "");
                            jsonObject.put("message", "js调用本地方法发生如下错误:" + e.getMessage());
                            jsBridgeHandler.callH5Msg("error", jsonObject.toString());
                        } catch (JSONException e1) {
                            FoxBaseCrashUtils.reportErrorData(e1);
                            e1.printStackTrace();
                        }

                    }
                }
            });
        }
    }

    /**
     * @param webView
     * @desc 注册本地java方法给前段js调用
     */
    public void inject(Ad ad,BaseJsBridgeWebView webView, H5CallBack jsBridgeCallBack) {
        Log.v(TAG, webView.getWebViewType() + "=====inject======");
        JsBridgeList jsBridgeList = new JsBridgeList(webView, jsBridgeCallBack);
        for (final BaseJsBridgeHandler jsBridgeHandler : jsBridgeList.getCommHandlers(ad)) {
            webView.registerHandler(jsBridgeHandler.getName(), new BridgeHandler() {
                @Override
                public void handler(String strData, CallBackFunction function) {
                    if (!BuildConfig.Release) {
                        FoxBaseToastUtils.showShort(jsBridgeHandler.getName());
                    }
                    Log.i(TAG, "handler = " + jsBridgeHandler.getName() + ", data from web = " + strData);
                    try {
                        //统一获取data jsonObject
                        JSONObject data = new JSONObject(strData).getJSONObject("data");
                        jsBridgeHandler.callBack(data, function);
                    } catch (Exception e) {
                        FoxBaseCrashUtils.reportErrorData(e);
                        Log.e(TAG, e.getMessage());
                        try {
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("code", -200);
                            jsonObject.put("data", "");
                            jsonObject.put("message", "js调用本地方法发生如下错误:" + e.getMessage());
                            jsBridgeHandler.callH5Msg("error", jsonObject.toString());
                        } catch (JSONException e1) {
                            FoxBaseCrashUtils.reportErrorData(e1);
                            e1.printStackTrace();
                        }

                    }
                }
            });
        }
    }
}
